/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Collection;
import java.util.Iterator;
import javolution.util.function.Consumer;
import javolution.util.function.Equality;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

public class AtomicCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;
    protected volatile CollectionService<E> immutable = this.cloneTarget();
    protected transient Thread updatingThread;

    public AtomicCollectionImpl(CollectionService<E> target) {
        super(target);
    }

    @Override
    public synchronized boolean add(E element) {
        boolean changed = this.target().add(element);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        boolean changed = this.target().addAll(c);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized void clear() {
        this.clear();
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
    }

    @Override
    public synchronized AtomicCollectionImpl<E> clone() {
        AtomicCollectionImpl copy = (AtomicCollectionImpl)super.clone();
        copy.updatingThread = null;
        return copy;
    }

    @Override
    public Equality<? super E> comparator() {
        return this.immutable.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.targetView().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.targetView().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.targetView().equals(o);
    }

    @Override
    public int hashCode() {
        return this.targetView().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.targetView().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public synchronized boolean remove(Object o) {
        boolean changed = this.target().remove(o);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        boolean changed = this.target().removeAll(c);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean changed = this.target().retainAll(c);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public int size() {
        return this.targetView().size();
    }

    @Override
    public Object[] toArray() {
        return this.targetView().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.targetView().toArray(a);
    }

    @Override
    public synchronized void update(Consumer<CollectionService<E>> action, CollectionService<E> view) {
        this.updatingThread = Thread.currentThread();
        try {
            this.target().update(action, view);
        }
        finally {
            this.updatingThread = null;
            this.immutable = this.cloneTarget();
        }
    }

    protected CollectionService<E> cloneTarget() {
        try {
            return this.target().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Cannot happen since target is Cloneable.");
        }
    }

    protected CollectionService<E> targetView() {
        return this.updatingThread == null || this.updatingThread != Thread.currentThread() ? this.immutable : this.target();
    }

    protected final boolean updateInProgress() {
        return this.updatingThread == Thread.currentThread();
    }

    private class IteratorImpl
    implements Iterator<E> {
        private E current;
        private final Iterator<E> targetIterator;

        public IteratorImpl() {
            this.targetIterator = AtomicCollectionImpl.this.targetView().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.targetIterator.hasNext();
        }

        @Override
        public E next() {
            this.current = this.targetIterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            AtomicCollectionImpl.this.remove(this.current);
            this.current = null;
        }
    }
}

