/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.math;

import fr.profi.mzdb.util.math.DerivativeAnalysis;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.LongMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

public final class DerivativeAnalysis$ {
    public static DerivativeAnalysis$ MODULE$;

    static {
        new DerivativeAnalysis$();
    }

    public double[] calcTernarySlopes(double[] values, int derivativeLevel) {
        double[] signums;
        while (true) {
            signums = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).sliding(2).map((Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToDouble((double)DerivativeAnalysis$.$anonfun$calcTernarySlopes$1(buffer))).toArray(ClassTag$.MODULE$.Double());
            if (derivativeLevel == 1) break;
            --derivativeLevel;
            values = signums;
        }
        return signums;
    }

    public DerivativeAnalysis.ILocalDerivativeChange[] findMiniMaxi(double[] values) {
        Object object;
        Object object2;
        int valuesCount = values.length;
        int prevSlope = 0;
        double prevMaxValue = 0.0;
        boolean hasSeenAscendingSlope = false;
        boolean afterMinimum = true;
        boolean afterMaximum = false;
        ListBuffer changes = new ListBuffer();
        int maxPrevIdx = valuesCount - 2;
        for (int prevIdx = 0; prevIdx <= maxPrevIdx; ++prevIdx) {
            int curSlope;
            double curValue = values[prevIdx + 1];
            double prevValue = values[prevIdx];
            double curDiff = curValue - prevValue;
            int n = curSlope = curDiff == 0.0 ? 0 : RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(curDiff));
            if (!hasSeenAscendingSlope && curSlope == 1) {
                hasSeenAscendingSlope = true;
            }
            if (hasSeenAscendingSlope) {
                if (afterMaximum && curValue > prevMaxValue) {
                    prevMaxValue = curValue;
                }
                if (curSlope != prevSlope) {
                    if (prevSlope == 1 && afterMinimum) {
                        changes.$plus$eq((Object)new DerivativeAnalysis.LocalMaximum(values[prevIdx], prevIdx));
                        prevMaxValue = prevValue;
                        afterMaximum = true;
                        afterMinimum = false;
                    } else if (prevSlope == -1 && afterMaximum) {
                        changes.$plus$eq((Object)new DerivativeAnalysis.LocalMinimum(values[prevIdx], prevIdx));
                        afterMaximum = false;
                        afterMinimum = true;
                    }
                }
            }
            prevSlope = curSlope;
        }
        if (changes.isEmpty()) {
            return (DerivativeAnalysis.ILocalDerivativeChange[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(DerivativeAnalysis.ILocalDerivativeChange.class));
        }
        DerivativeAnalysis.ILocalDerivativeChange firstChange = (DerivativeAnalysis.ILocalDerivativeChange)changes.apply(0);
        if (firstChange.isMaximum()) {
            int firstChangeIdx = firstChange.index();
            if (firstChangeIdx == 0) {
                object2 = changes.remove(0);
            } else {
                double prevMinValue = Double.MAX_VALUE;
                int prevMinIndex = -1;
                for (int idx = 0; idx <= firstChangeIdx; ++idx) {
                    double value = values[idx];
                    if (!(value < prevMinValue)) continue;
                    prevMinValue = value;
                    prevMinIndex = idx;
                }
                if (prevMinValue != firstChange.value()) {
                    changes.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(prevMinValue, prevMinIndex)}));
                } else {
                    changes.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(values[0], 0)}));
                }
                object2 = BoxedUnit.UNIT;
            }
        } else {
            object2 = BoxedUnit.UNIT;
        }
        DerivativeAnalysis.ILocalDerivativeChange lastChange = (DerivativeAnalysis.ILocalDerivativeChange)changes.last();
        if (lastChange.isMaximum()) {
            int lastValueIndex;
            int lastChangeIndex = lastChange.index();
            if (lastChangeIndex == (lastValueIndex = valuesCount - 1)) {
                object = changes.remove(lastChangeIndex);
            } else {
                double nextMinValue = Double.MAX_VALUE;
                int nextMinIndex = -1;
                for (int idx = lastChange.index(); idx <= lastValueIndex; ++idx) {
                    double value = values[idx];
                    if (!(value < nextMinValue)) continue;
                    nextMinValue = value;
                    nextMinIndex = idx;
                }
                if (nextMinValue != lastChange.value()) {
                    changes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(nextMinValue, nextMinIndex)}));
                } else {
                    changes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(values[lastValueIndex], lastValueIndex)}));
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return (DerivativeAnalysis.ILocalDerivativeChange[])changes.toArray(ClassTag$.MODULE$.apply(DerivativeAnalysis.ILocalDerivativeChange.class));
    }

    public DerivativeAnalysis.ILocalDerivativeChange[] findSignificantMiniMaxi(double[] values, int miniMaxiDistanceThresh, float maxIntensityRelThresh) {
        DerivativeAnalysis.ILocalDerivativeChange[] miniMaxi = this.findMiniMaxi(values);
        int miniMaxiCount = miniMaxi.length;
        if (miniMaxiCount <= 3) {
            return miniMaxi;
        }
        List indexedMiniMaxi = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])miniMaxi)).toList().zipWithIndex(List$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = indexedMiniMaxi.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$1(x$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List indexedMaxima = (List)tuple2._1();
        List indexedMinima = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexedMaxima, (Object)indexedMinima);
        Tuple2 tuple23 = tuple22;
        List indexedMaxima2 = (List)tuple23._1();
        List indexedMinima2 = (List)tuple23._2();
        LongMap validatedMinimaIndexMap = new LongMap(indexedMinima2.length());
        indexedMinima2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int v = tuple2._2$mcI$sp();
            Option option = validatedMinimaIndexMap.put((long)v, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            return option;
        });
        LongMap validatedMaximaIndexMap = new LongMap(indexedMaxima2.length());
        indexedMaxima2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int v = tuple2._2$mcI$sp();
            Option option = validatedMaximaIndexMap.put((long)v, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            return option;
        });
        List sortedIndexedMaxima = (List)indexedMaxima2.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$6(x$5)), (Ordering)Ordering.Double$.MODULE$);
        sortedIndexedMaxima.withFilter((Function1 & Serializable & scala.Serializable)indexedMaximum -> BoxesRunTime.boxToBoolean((boolean)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$7(validatedMaximaIndexMap, indexedMaximum))).foreach((Function1 & Serializable & scala.Serializable)indexedMaximum -> {
            DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$8(indexedMiniMaxi, miniMaxiCount, validatedMaximaIndexMap, miniMaxi, maxIntensityRelThresh, miniMaxiDistanceThresh, validatedMinimaIndexMap, indexedMaximum);
            return BoxedUnit.UNIT;
        });
        ArrayBuffer filteredIndexedChanges = new ArrayBuffer();
        validatedMinimaIndexMap.$plus$plus((GenTraversableOnce)validatedMaximaIndexMap).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$9(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$10(x$8))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long minIdx = tuple2._1$mcJ$sp();
            ArrayBuffer arrayBuffer = filteredIndexedChanges.$plus$eq(indexedMiniMaxi.apply((int)minIdx));
            return arrayBuffer;
        });
        ArrayBuffer filteredAndSortedChanges = (ArrayBuffer)((SeqLike)filteredIndexedChanges.distinct()).sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        ArrayBuffer significantChanges = new ArrayBuffer();
        ObjectRef prevMin = ObjectRef.create(null);
        ObjectRef prevMax = ObjectRef.create(null);
        IntRef sigChangeIdx = IntRef.create((int)0);
        filteredAndSortedChanges.foreach((Function1 & Serializable & scala.Serializable)indexedDerivativeChange -> {
            DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$13(prevMax, significantChanges, indexedMiniMaxi, prevMin, sigChangeIdx, indexedDerivativeChange);
            return BoxedUnit.UNIT;
        });
        return (DerivativeAnalysis.ILocalDerivativeChange[])significantChanges.toArray(ClassTag$.MODULE$.apply(DerivativeAnalysis.ILocalDerivativeChange.class));
    }

    public static final /* synthetic */ double $anonfun$calcTernarySlopes$1(double[] buffer) {
        double diff = buffer[1] - buffer[0];
        return diff == 0.0 ? 0.0 : (double)RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(diff));
    }

    public static final /* synthetic */ boolean $anonfun$findSignificantMiniMaxi$1(Tuple2 x$1) {
        return ((DerivativeAnalysis.ILocalDerivativeChange)x$1._1()).isMaximum();
    }

    public static final /* synthetic */ boolean $anonfun$findSignificantMiniMaxi$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$findSignificantMiniMaxi$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$findSignificantMiniMaxi$6(Tuple2 x$5) {
        return -((DerivativeAnalysis.ILocalDerivativeChange)x$5._1()).value();
    }

    public static final /* synthetic */ boolean $anonfun$findSignificantMiniMaxi$7(LongMap validatedMaximaIndexMap$1, Tuple2 indexedMaximum) {
        return BoxesRunTime.unboxToBoolean((Object)validatedMaximaIndexMap$1.apply((long)indexedMaximum._2$mcI$sp()));
    }

    private static final void lookForSignificantMinimum$1(int direction, int maxIdx$1, List indexedMiniMaxi$1, int miniMaxiCount$1, LongMap validatedMaximaIndexMap$1, DerivativeAnalysis.ILocalDerivativeChange[] miniMaxi$1, DerivativeAnalysis.ILocalDerivativeChange maximum$1, float maxIntensityRelThresh$1, int miniMaxiDistanceThresh$1, LongMap validatedMinimaIndexMap$1) {
        boolean minimumAlreadyValidated = false;
        boolean isMinimumOK = false;
        int minIdx = maxIdx$1 + direction;
        while (!isMinimumOK && !minimumAlreadyValidated) {
            boolean isMinSignificant;
            boolean bl;
            boolean isBoundary;
            Tuple2 indexedMinimum = (Tuple2)indexedMiniMaxi$1.apply(minIdx);
            Tuple2 tuple2 = indexedMinimum;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DerivativeAnalysis.ILocalDerivativeChange minimum = (DerivativeAnalysis.ILocalDerivativeChange)tuple2._1();
            int minValueIdx = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)minimum, (Object)BoxesRunTime.boxToInteger((int)minValueIdx));
            Tuple2 tuple23 = tuple22;
            DerivativeAnalysis.ILocalDerivativeChange minimum2 = (DerivativeAnalysis.ILocalDerivativeChange)tuple23._1();
            int minValueIdx2 = tuple23._2$mcI$sp();
            boolean bl2 = isBoundary = minValueIdx2 == 0 || minValueIdx2 == miniMaxiCount$1 - 1;
            if (isBoundary) {
                bl = true;
            } else {
                DerivativeAnalysis.ILocalDerivativeChange nextValidMax = null;
                for (int maxIdx = minIdx + direction; nextValidMax == null && maxIdx > 0 && maxIdx < miniMaxiCount$1; maxIdx += 2 * direction) {
                    if (!BoxesRunTime.unboxToBoolean((Object)validatedMaximaIndexMap$1.apply((long)maxIdx))) continue;
                    DerivativeAnalysis.ILocalDerivativeChange nextMax = miniMaxi$1[maxIdx];
                    boolean isUnderThresholdFromCurrentMax = minimum2.value() / maximum$1.value() <= (double)maxIntensityRelThresh$1;
                    boolean isUnderThresholdFromOtherMax = minimum2.value() / nextMax.value() <= (double)maxIntensityRelThresh$1;
                    int distFromCurrentMax = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(minimum2.index() - maximum$1.index()));
                    int distFromOtherMax = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(minimum2.index() - nextMax.index()));
                    if (!isUnderThresholdFromCurrentMax || !isUnderThresholdFromOtherMax || distFromCurrentMax < miniMaxiDistanceThresh$1 || distFromOtherMax < miniMaxiDistanceThresh$1) continue;
                    nextValidMax = nextMax;
                }
                bl = isMinSignificant = nextValidMax != null;
            }
            if (isMinSignificant) {
                isMinimumOK = true;
                validatedMinimaIndexMap$1.update((long)minIdx, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                continue;
            }
            if (BoxesRunTime.unboxToBoolean((Object)validatedMinimaIndexMap$1.apply((long)minIdx))) {
                validatedMinimaIndexMap$1.update((long)minIdx, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                validatedMaximaIndexMap$1.update((long)maxIdx$1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                minimumAlreadyValidated = true;
                continue;
            }
            validatedMaximaIndexMap$1.update((long)(minIdx + direction), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            minIdx += 2 * direction;
        }
    }

    public static final /* synthetic */ void $anonfun$findSignificantMiniMaxi$8(List indexedMiniMaxi$1, int miniMaxiCount$1, LongMap validatedMaximaIndexMap$1, DerivativeAnalysis.ILocalDerivativeChange[] miniMaxi$1, float maxIntensityRelThresh$1, int miniMaxiDistanceThresh$1, LongMap validatedMinimaIndexMap$1, Tuple2 indexedMaximum) {
        Tuple2 tuple2 = indexedMaximum;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DerivativeAnalysis.ILocalDerivativeChange maximum = (DerivativeAnalysis.ILocalDerivativeChange)tuple2._1();
        int maxIdx = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)maximum, (Object)BoxesRunTime.boxToInteger((int)maxIdx));
        Tuple2 tuple23 = tuple22;
        DerivativeAnalysis.ILocalDerivativeChange maximum2 = (DerivativeAnalysis.ILocalDerivativeChange)tuple23._1();
        int maxIdx2 = tuple23._2$mcI$sp();
        DerivativeAnalysis$.lookForSignificantMinimum$1(1, maxIdx2, indexedMiniMaxi$1, miniMaxiCount$1, validatedMaximaIndexMap$1, miniMaxi$1, maximum2, maxIntensityRelThresh$1, miniMaxiDistanceThresh$1, validatedMinimaIndexMap$1);
        DerivativeAnalysis$.lookForSignificantMinimum$1(-1, maxIdx2, indexedMiniMaxi$1, miniMaxiCount$1, validatedMaximaIndexMap$1, miniMaxi$1, maximum2, maxIntensityRelThresh$1, miniMaxiDistanceThresh$1, validatedMinimaIndexMap$1);
    }

    public static final /* synthetic */ boolean $anonfun$findSignificantMiniMaxi$9(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$findSignificantMiniMaxi$10(Tuple2 x$8) {
        boolean isValidated;
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = isValidated = tuple2._2$mcZ$sp();
        return bl;
    }

    public static final /* synthetic */ double $anonfun$findSignificantMiniMaxi$14(Tuple2 x$12) {
        return ((DerivativeAnalysis.ILocalDerivativeChange)x$12._1()).value();
    }

    public static final /* synthetic */ void $anonfun$findSignificantMiniMaxi$13(ObjectRef prevMax$1, ArrayBuffer significantChanges$1, List indexedMiniMaxi$1, ObjectRef prevMin$1, IntRef sigChangeIdx$1, Tuple2 indexedDerivativeChange) {
        Tuple2 tuple2 = indexedDerivativeChange;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DerivativeAnalysis.ILocalDerivativeChange derivativeChange = (DerivativeAnalysis.ILocalDerivativeChange)tuple2._1();
        int derivativeChangeIdx = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)derivativeChange, (Object)BoxesRunTime.boxToInteger((int)derivativeChangeIdx));
        Tuple2 tuple23 = tuple22;
        DerivativeAnalysis.ILocalDerivativeChange derivativeChange2 = (DerivativeAnalysis.ILocalDerivativeChange)tuple23._1();
        int derivativeChangeIdx2 = tuple23._2$mcI$sp();
        if (derivativeChange2.isMaximum()) {
            BoxedUnit boxedUnit;
            if ((Tuple2)prevMax$1.elem != null) {
                int firstIdx = ((Tuple2)prevMax$1.elem)._2$mcI$sp();
                int lastIdx = derivativeChangeIdx2;
                boxedUnit = significantChanges$1.$plus$eq(((Tuple2)indexedMiniMaxi$1.slice(firstIdx, lastIdx + 1).minBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)DerivativeAnalysis$.$anonfun$findSignificantMiniMaxi$14(x$12)), (Ordering)Ordering.Double$.MODULE$))._1());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            significantChanges$1.$plus$eq((Object)derivativeChange2);
            prevMin$1.elem = null;
            prevMax$1.elem = indexedDerivativeChange;
            ++sigChangeIdx$1.elem;
        } else {
            if ((Tuple2)prevMin$1.elem == null) {
                significantChanges$1.$plus$eq((Object)derivativeChange2);
                ++sigChangeIdx$1.elem;
            } else if (derivativeChange2.value() < ((DerivativeAnalysis.ILocalDerivativeChange)((Tuple2)prevMin$1.elem)._1()).value()) {
                significantChanges$1.update(sigChangeIdx$1.elem - 1, (Object)derivativeChange2);
            }
            prevMin$1.elem = indexedDerivativeChange;
            prevMax$1.elem = null;
        }
    }

    private DerivativeAnalysis$() {
        MODULE$ = this;
    }
}

