/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.math;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.PythonImage;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.math.StatsImplementation;
import fr.proline.studio.python.math.StatsUtil;
import fr.proline.studio.python.model.ExprTableModel;
import fr.proline.studio.rserver.RServerManager;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.types.LogInfo;
import fr.proline.studio.types.LogRatio;
import fr.proline.studio.types.PValue;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.RList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsRImplementation {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final String LIB_PROSTAR = "DAPAR";
    private static final String LIB_CP4P = "cp4p";
    private static final double LOG2 = StrictMath.log(2.0);

    public static PyObject adjustP(Col pvaluesCol, String pi0Parameter, PyFloat alpha, PyInteger nbins, PyFloat pz) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        boolean RStarted = serverR.startRProcessWithRetry();
        if (!RStarted) {
            throw Py.RuntimeError((String)"Server R not found");
        }
        serverR.connect();
        int nbRow = pvaluesCol.getRowCount();
        Table t = pvaluesCol.getTable();
        File tempFile = File.createTempFile("adjustp", "csv");
        tempFile.deleteOnExit();
        FileWriter fw = new FileWriter(tempFile);
        for (int i = 0; i < nbRow; ++i) {
            double d = StatsRImplementation.asDoubleValue(pvaluesCol, i);
            fw.write(String.valueOf(d));
            fw.write(10);
        }
        fw.close();
        ColDoubleData c = StatsRImplementation._adjustP(t, tempFile, pi0Parameter, alpha, nbins, pz);
        tempFile.delete();
        return c;
    }

    private static double asDoubleValue(Col pvaluesCol, int i) {
        double d;
        Object o = pvaluesCol.getValueAt(i);
        if (o instanceof LazyData) {
            o = ((LazyData)o).getData();
        }
        if (o != null && o instanceof Number) {
            d = ((Number)o).doubleValue();
            if (d != d) {
                d = 0.0;
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    private static ColDoubleData _adjustP(Table t, File f, String pi0Parameter, PyFloat alpha, PyInteger nbins, PyFloat pz) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        String path = f.getCanonicalPath().replaceAll("\\\\", "/");
        serverR.parseAndEval("library(cp4p)");
        String cmdReadCSV = "testadjustp<-read.delim('" + path + "',header=F, sep=';')";
        serverR.parseAndEval(cmdReadCSV);
        String cmdBB1 = "resadjustp<-adjust.p(p=testadjustp[,1:1], " + pi0Parameter + ", alpha=" + alpha.toString() + ", nbins=" + nbins.toString() + ", pz=" + pz.toString() + ")";
        String cmdBB2 = "adjp<-resadjustp$adjp";
        serverR.parseAndEval(cmdBB1);
        REXPGenericVector resVector = (REXPGenericVector)serverR.parseAndEval(cmdBB2);
        Object o = resVector.asNativeJavaObject();
        HashMap map = (HashMap)o;
        double[] values = null;
        Set keySet = map.keySet();
        for (Object key : keySet) {
            Object value = map.get(key);
            if (value.toString().compareTo("adjusted.p") != 0) continue;
            values = (double[])key;
            break;
        }
        if (values == null) {
            throw new Exception("Data not correctly parsed");
        }
        ArrayList<Double> resArray = new ArrayList<Double>(values.length);
        for (int i = 0; i < values.length; ++i) {
            resArray.add(values[i]);
        }
        return new ColDoubleData(t, resArray, null);
    }

    public static Table bbinomial(PyTuple p) throws Exception {
        StatsUtil.startRServer();
        PyTuple[] pArray = StatsUtil.colTupleToTuplesArray(p);
        ColRef[] cols = StatsUtil.colTupleToColArray(pArray);
        File matrixTempFile = StatsUtil.columnsToMatrixTempFile(cols, false, false, false);
        Table t = cols[0].getTable();
        int nb1 = pArray[0].size();
        int nb2 = pArray[1].size();
        int nb3 = pArray.length <= 2 ? 0 : pArray[2].size();
        Table resTable = StatsRImplementation._bbinomialR(t, matrixTempFile, nb1, nb2, nb3, pArray, cols);
        matrixTempFile.delete();
        return resTable;
    }

    private static Table _bbinomialR(Table t, File matrixTempFile, int nbCols1, int nbCols2, int nbCols3, PyTuple[] pArray, ColRef[] cols) throws Exception {
        final boolean hasBest = pArray.length <= 2;
        final int colPValue = t.getModel().getColumnCount() + 1;
        final int colLogFC = colPValue + 1;
        ExprTableModel model = new ExprTableModel(t.getModel()){

            @Override
            public int[] getBestColIndex(PlotType plotType) {
                if (plotType == PlotType.SCATTER_PLOT && hasBest) {
                    int[] cols = new int[]{colLogFC, colPValue};
                    return cols;
                }
                return super.getBestColIndex(plotType);
            }

            @Override
            public PlotType getBestPlotType() {
                return PlotType.SCATTER_PLOT;
            }
        };
        Table resTable = new Table((GlobalTableModelInterface)model);
        RServerManager serverR = RServerManager.getRServerManager();
        serverR.parseAndEval("library(ibb)");
        StatsUtil.readMatrixData(matrixTempFile, false);
        int nbCols = nbCols1 + nbCols2 + nbCols3;
        Object forCol3 = "";
        if (nbCols3 > 0) {
            forCol3 = ",rep('C3'," + nbCols3 + ")";
        }
        String cmdBB = "resbinomial<-bb.test(x=matrixProlineValues[,1:" + nbCols + "], tx=colSums(matrixProlineValues[,1:" + nbCols + "]), group=c(rep('C1'," + nbCols1 + "),rep('C2'," + nbCols2 + ")" + (String)forCol3 + "),n.threads=-2)";
        REXPGenericVector resVector = (REXPGenericVector)serverR.parseAndEval(cmdBB);
        Object o = resVector.asNativeJavaObject();
        HashMap map = (HashMap)o;
        double[] values = (double[])map.keySet().toArray()[0];
        int nbRows = values.length;
        ArrayList<Double> valuesForCol = new ArrayList<Double>(nbRows);
        for (int i = 0; i < nbRows; ++i) {
            valuesForCol.add(values[i]);
        }
        String colName = "bbinomial PValue";
        ColDoubleData pvalueCol = new ColDoubleData(resTable, valuesForCol, colName);
        ColDoubleData log10PvalueCol = StatsImplementation.log10(pvalueCol);
        ColDoubleData minusLog10PvalueCol = StatsImplementation.neg(log10PvalueCol);
        model.addExtraColumn(pvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
        model.addExtraColumnInfo(model.getColumnCount() - 1, new PValue());
        model.addExtraColumn(minusLog10PvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
        model.addExtraColumnInfo(model.getColumnCount() - 1, new PValue());
        model.addExtraColumnInfo(model.getColumnCount() - 1, new LogInfo(LogInfo.LogState.LOG10));
        if (pArray.length <= 2) {
            nbRows = t.getModel().getRowCount();
            ArrayList<Double> valuesForCol2 = new ArrayList<Double>(nbRows);
            for (int row = 0; row < nbRows; ++row) {
                int c;
                double n = 0.0;
                for (c = 0; c < nbCols1; ++c) {
                    n += StatsRImplementation.asDoubleValue(cols[c], row) + 1.0;
                }
                double d = 0.0;
                while (c < nbCols1 + nbCols2) {
                    d += StatsRImplementation.asDoubleValue(cols[c], row) + 1.0;
                    ++c;
                }
                valuesForCol2.add(StrictMath.log(n / (double)nbCols1 / (d / (double)nbCols2)) / LOG2);
            }
            colName = "log Ratio";
            model.addExtraColumn(new ColDoubleData(resTable, valuesForCol2, colName), (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
            model.addExtraColumnInfo(model.getColumnCount() - 1, new LogRatio());
        }
        return resTable;
    }

    public static PythonImage boxPlot(PyTuple p, PyTuple labels) throws Exception {
        StatsUtil.startRServer();
        PyTuple[] pArray = StatsUtil.colTupleToTuplesArray(p);
        ColRef[] cols = StatsUtil.colTupleToColArray(pArray);
        File matrixTempFile = StatsUtil.columnsToMatrixTempFile(cols, true, false, true);
        File imageTempFile = StatsUtil.createImageTempFile();
        PythonImage image = StatsRImplementation._boxPlotR(matrixTempFile, imageTempFile, StatsUtil.colNamesToTuple(cols), labels);
        matrixTempFile.delete();
        imageTempFile.delete();
        return image;
    }

    private static PythonImage _boxPlotR(File matrixTempFile, File imageTempFile, PyTuple columnsName, PyTuple labels) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        serverR.parseAndEval("library(DAPAR)");
        StatsUtil.readMatrixData(matrixTempFile, true);
        return StatsUtil.createImage(imageTempFile, "boxPlotD(matrixProlineValues,dataForXAxis=data.frame(Label=" + StatsUtil.stringTupleToRVector(columnsName) + "),labels=" + StatsUtil.stringTupleToRVector(labels) + ")");
    }

    public static PyObject calibrationPlot(Col pvaluesCol, PyString pi0Method, PyInteger nbins, PyFloat pz) throws Exception {
        StatsUtil.startRServer();
        File matrixTempFile = StatsUtil.columnToMatrixTempFile(pvaluesCol);
        File imageTempFile = StatsUtil.createImageTempFile();
        PythonImage image = StatsRImplementation._calibrationPlot(matrixTempFile, imageTempFile, pi0Method, nbins, pz);
        matrixTempFile.delete();
        imageTempFile.delete();
        return image;
    }

    public static PythonImage _calibrationPlot(File matrixTempFile, File imageTempFile, PyString pi0Method, PyInteger nbins, PyFloat pz) throws Exception {
        String pi0Parameter;
        RServerManager serverR = RServerManager.getRServerManager();
        serverR.parseAndEval("library(cp4p)");
        StatsUtil.readMatrixData(matrixTempFile, false);
        String pi0String = pi0Method.toString();
        try {
            Double.parseDouble(pi0String);
            pi0Parameter = "pi0.method=" + pi0Method.toString();
        }
        catch (NumberFormatException nfe) {
            pi0Parameter = "pi0.method=\"" + pi0Method.toString() + "\"";
        }
        String cmd = "calibration.plot(p=matrixProlineValues[,1:1], " + pi0Parameter + ", nbins=" + nbins.toString() + ", pz=" + pz.toString() + ")";
        return StatsUtil.createImage(imageTempFile, cmd);
    }

    public static PythonImage densityPlot(PyTuple p, PyTuple labels) throws Exception {
        StatsUtil.startRServer();
        PyTuple[] pArray = StatsUtil.colTupleToTuplesArray(p);
        ColRef[] cols = StatsUtil.colTupleToColArray(pArray);
        File matrixTempFile = StatsUtil.columnsToMatrixTempFile(cols, true, false, true);
        File imageTempFile = StatsUtil.createImageTempFile();
        PythonImage image = StatsRImplementation._densityPlotR(matrixTempFile, imageTempFile, labels);
        matrixTempFile.delete();
        imageTempFile.delete();
        return image;
    }

    private static PythonImage _densityPlotR(File matrixTempFile, File imageTempFile, PyTuple labels) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        serverR.parseAndEval("library(DAPAR)");
        StatsUtil.readMatrixData(matrixTempFile, true);
        return StatsUtil.createImage(imageTempFile, "densityPlotD(matrixProlineValues,labels=" + StatsUtil.stringTupleToRVector(labels) + ")");
    }

    public static PythonImage varianceDistPlot(PyTuple p, PyTuple labels) throws Exception {
        StatsUtil.startRServer();
        PyTuple[] pArray = StatsUtil.colTupleToTuplesArray(p);
        ColRef[] cols = StatsUtil.colTupleToColArray(pArray);
        File matrixTempFile = StatsUtil.columnsToMatrixTempFile(cols, true, false, true);
        File imageTempFile = StatsUtil.createImageTempFile();
        PythonImage image = StatsRImplementation._varianceDistPlot(matrixTempFile, imageTempFile, StatsUtil.colNamesToTuple(cols), labels);
        matrixTempFile.delete();
        imageTempFile.delete();
        return image;
    }

    private static PythonImage _varianceDistPlot(File matrixTempFile, File imageTempFile, PyTuple columnsName, PyTuple labels) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        serverR.parseAndEval("library(DAPAR)");
        StatsUtil.readMatrixData(matrixTempFile, true);
        return StatsUtil.createImage(imageTempFile, "varianceDistD(matrixProlineValues,labels=" + StatsUtil.stringTupleToRVector(labels) + ")");
    }

    public static Table normalize(PyTuple p, PyTuple labels, PyString normalizeFamily, PyString normalizeOption) throws Exception {
        StatsUtil.startRServer();
        PyTuple[] pArray = StatsUtil.colTupleToTuplesArray(p);
        ColRef[] cols = StatsUtil.colTupleToColArray(pArray);
        File matrixTempFile = StatsUtil.columnsToMatrixTempFile(cols, false, false, true);
        Table t = cols[0].getTable();
        Table resTable = StatsRImplementation._normalizeR(t, matrixTempFile, labels, cols, normalizeFamily, normalizeOption);
        matrixTempFile.delete();
        return resTable;
    }

    private static Table _normalizeR(Table t, File matrixTempFile, PyTuple labels, ColRef[] cols, PyString normalizeFamily, PyString normalizeOption) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        serverR.parseAndEval("library(DAPAR)");
        StatsUtil.readMatrixData(matrixTempFile, false);
        String cmdBB = "normalizeD(matrixProlineValues," + StatsUtil.stringTupleToRVector(labels) + ",\"" + normalizeFamily + "\",\"" + normalizeOption + "\")";
        REXP res = serverR.parseAndEval(cmdBB);
        ExprTableModel model = new ExprTableModel(t.getModel());
        Table resTable = new Table((GlobalTableModelInterface)model);
        HashMap<Integer, Col> modifiedColumns = new HashMap<Integer, Col>();
        if (res instanceof REXPDouble) {
            int j;
            REXPDouble matrixDouble = (REXPDouble)res;
            double[][] d = matrixDouble.asDoubleMatrix();
            int nbRows = d.length;
            int nbCols = cols.length;
            ArrayList valuesForCol = new ArrayList();
            for (j = 0; j < nbCols; ++j) {
                valuesForCol.add(new ArrayList());
            }
            for (int i = 0; i < nbRows; ++i) {
                for (int j2 = 0; j2 < nbCols; ++j2) {
                    ((ArrayList)valuesForCol.get(j2)).add(d[i][j2]);
                }
            }
            for (j = 0; j < nbCols; ++j) {
                modifiedColumns.put(cols[j].getModelCol(), new ColDoubleData(resTable, (ArrayList)valuesForCol.get(j), "norm(" + cols[j].getExportColumnName() + ")"));
            }
        } else {
            REXPGenericVector matrix = (REXPGenericVector)res;
            RList list = matrix.asList();
            for (int i = 0; i < list.size(); ++i) {
                REXPDouble resDoubleArray = (REXPDouble)list.get(i);
                double[] d = resDoubleArray.asDoubles();
                ArrayList<Double> values = new ArrayList<Double>();
                for (int j = 0; j < d.length; ++j) {
                    values.add(d[j]);
                }
                modifiedColumns.put(cols[i].getModelCol(), new ColDoubleData(resTable, values, "norm(" + cols[i].getExportColumnName() + ")"));
            }
        }
        model.modifyColumnValues(modifiedColumns, null);
        return resTable;
    }

    public static Table mvimputation(PyTuple p, PyString method) throws Exception {
        StatsUtil.startRServer();
        PyTuple[] pArray = StatsUtil.colTupleToTuplesArray(p);
        ColRef[] cols = StatsUtil.colTupleToColArray(pArray);
        File matrixTempFile = StatsUtil.columnsToMatrixTempFile(cols, false, false, true);
        Table t = cols[0].getTable();
        Table resTable = StatsRImplementation._mvimputationR(t, matrixTempFile, cols, method);
        matrixTempFile.delete();
        return resTable;
    }

    private static Table _mvimputationR(Table t, File matrixTempFile, ColRef[] cols, PyString method) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        serverR.parseAndEval("library(DAPAR)");
        StatsUtil.readMatrixData(matrixTempFile, false);
        String cmdBB = "mvImputation(matrixProlineValues,\"" + method + "\")";
        REXP res = serverR.parseAndEval(cmdBB);
        ExprTableModel model = new ExprTableModel(t.getModel());
        Table resTable = new Table((GlobalTableModelInterface)model);
        HashMap<Integer, Col> modifiedColumns = new HashMap<Integer, Col>();
        if (res instanceof REXPDouble) {
            int j;
            REXPDouble matrixDouble = (REXPDouble)res;
            double[][] d = matrixDouble.asDoubleMatrix();
            int nbRows = d.length;
            int nbCols = cols.length;
            ArrayList valuesForCol = new ArrayList();
            for (j = 0; j < nbCols; ++j) {
                valuesForCol.add(new ArrayList());
            }
            for (int i = 0; i < nbRows; ++i) {
                for (int j2 = 0; j2 < nbCols; ++j2) {
                    ((ArrayList)valuesForCol.get(j2)).add(d[i][j2]);
                }
            }
            for (j = 0; j < nbCols; ++j) {
                modifiedColumns.put(cols[j].getModelCol(), new ColDoubleData(resTable, (ArrayList)valuesForCol.get(j), "mvi(" + cols[j].getExportColumnName() + ")"));
            }
        } else {
            REXPGenericVector matrix = (REXPGenericVector)res;
            RList list = matrix.asList();
            for (int i = 0; i < list.size(); ++i) {
                REXPDouble resDoubleArray = (REXPDouble)list.get(i);
                double[] d = resDoubleArray.asDoubles();
                ArrayList<Double> values = new ArrayList<Double>();
                for (int j = 0; j < d.length; ++j) {
                    values.add(d[j]);
                }
                modifiedColumns.put(cols[i].getModelCol(), new ColDoubleData(resTable, values, "mvi(" + cols[i].getExportColumnName() + ")"));
            }
        }
        model.modifyColumnValues(modifiedColumns, null);
        return resTable;
    }

    public static Table diffanalysis(PyTuple p, PyTuple labels, PyString diffAnalysisType) throws Exception {
        StatsUtil.startRServer();
        PyTuple[] pArray = StatsUtil.colTupleToTuplesArray(p);
        ColRef[] cols = StatsUtil.colTupleToColArray(pArray);
        File matrixTempFile = StatsUtil.columnsToMatrixTempFile(cols, false, false, true);
        m_logger.debug("R input file created : " + matrixTempFile.getAbsolutePath());
        Table t = cols[0].getTable();
        Table resTable = StatsRImplementation._diffanalysisR(t, matrixTempFile, labels, cols, diffAnalysisType);
        matrixTempFile.delete();
        return resTable;
    }

    private static Table _diffanalysisR(Table t, File matrixTempFile, PyTuple labels, ColRef[] cols, PyString diffAnalysisType) throws Exception {
        Table resTable;
        block13: {
            String diffAnalysisTypeString;
            RServerManager serverR;
            ExprTableModel model;
            block12: {
                final int colPValue = t.getModel().getColumnCount() + 1;
                final int colLogFC = colPValue + 1;
                model = new ExprTableModel(t.getModel()){

                    @Override
                    public int[] getBestColIndex(PlotType plotType) {
                        if (plotType == PlotType.SCATTER_PLOT) {
                            int[] cols = new int[]{colLogFC, colPValue};
                            return cols;
                        }
                        return super.getBestColIndex(plotType);
                    }

                    @Override
                    public PlotType getBestPlotType() {
                        return PlotType.SCATTER_PLOT;
                    }
                };
                resTable = new Table((GlobalTableModelInterface)model);
                serverR = RServerManager.getRServerManager();
                serverR.parseAndEval("library(DAPAR)");
                serverR.parseAndEval("library(limma)");
                StatsUtil.readMatrixData(matrixTempFile, false);
                diffAnalysisTypeString = diffAnalysisType.toString();
                if (diffAnalysisTypeString.compareTo("Limma") != 0) break block12;
                int nbValues = labels.getArray().length;
                Object cmdBB = "limmaObject <- limmaCompleteTest(matrixProlineValues," + StatsUtil.RVectorToRFactor(StatsUtil.stringTupleToRVector(labels)) + ",factor(1:" + nbValues + "),factor(1:" + nbValues + "))";
                serverR.parseAndEval((String)cmdBB);
                cmdBB = "limmaObject<-limmaObject[order(as.numeric(rownames(limmaObject))),,drop=FALSE]";
                serverR.parseAndEval((String)cmdBB);
                REXP resPValue = serverR.parseAndEval("limmaObject$P_Value");
                REXP resLogFC = serverR.parseAndEval("limmaObject$logFC");
                double[] pvaluesArray = ((REXPDouble)resPValue).asDoubles();
                double[] logFCArray = ((REXPDouble)resLogFC).asDoubles();
                int nbRows = pvaluesArray.length;
                ArrayList<Double> valuesForCol = new ArrayList<Double>(nbRows);
                for (int i = 0; i < nbRows; ++i) {
                    valuesForCol.add(pvaluesArray[i]);
                }
                String colName = diffAnalysisTypeString + " PValue";
                ColDoubleData pvalueCol = new ColDoubleData(resTable, valuesForCol, colName);
                ColDoubleData log10PvalueCol = StatsImplementation.log10(pvalueCol);
                ColDoubleData minusLog10PvalueCol = StatsImplementation.neg(log10PvalueCol);
                model.addExtraColumn(pvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                model.addExtraColumnInfo(model.getColumnCount() - 1, new PValue());
                model.addExtraColumn(minusLog10PvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                model.addExtraColumnInfo(model.getColumnCount() - 1, new PValue());
                model.addExtraColumnInfo(model.getColumnCount() - 1, new LogInfo(LogInfo.LogState.LOG10));
                valuesForCol = new ArrayList(nbRows);
                for (int i = 0; i < nbRows; ++i) {
                    valuesForCol.add(-logFCArray[i]);
                }
                colName = diffAnalysisTypeString + " log Ratio";
                model.addExtraColumn(new ColDoubleData(resTable, valuesForCol, colName), (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                model.addExtraColumnInfo(model.getColumnCount() - 1, new LogRatio());
                break block13;
            }
            if (diffAnalysisTypeString.compareTo("Welch") != 0) break block13;
            String cmdBB = "diffAnaWelch(matrixProlineValues," + StatsUtil.stringTupleToRVector(labels) + ",\"group0\",\"group1\")";
            REXP res = serverR.parseAndEval(cmdBB);
            if (res instanceof REXPDouble) {
                int j;
                REXPDouble matrixDouble = (REXPDouble)res;
                double[][] d = matrixDouble.asDoubleMatrix();
                int nbRows = d.length;
                int nbCols = cols.length;
                ArrayList valuesForCol = new ArrayList();
                for (j = 0; j < nbCols; ++j) {
                    valuesForCol.add(new ArrayList());
                }
                for (int i = 0; i < nbRows; ++i) {
                    for (int j2 = 0; j2 < nbCols; ++j2) {
                        ((ArrayList)valuesForCol.get(j2)).add(d[i][j2]);
                    }
                }
                for (j = 0; j < nbCols; ++j) {
                    String colName;
                    if (j == 0) {
                        colName = diffAnalysisTypeString + " PValue";
                        ColDoubleData pvalueCol = new ColDoubleData(resTable, (ArrayList)valuesForCol.get(j), colName);
                        ColDoubleData log10PvalueCol = StatsImplementation.log10(pvalueCol);
                        ColDoubleData minusLog10PvalueCol = StatsImplementation.neg(log10PvalueCol);
                        model.addExtraColumn(pvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                        model.addExtraColumnInfo(model.getColumnCount() - 1, new PValue());
                        model.addExtraColumn(minusLog10PvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                        model.addExtraColumnInfo(model.getColumnCount() - 1, new PValue());
                        model.addExtraColumnInfo(model.getColumnCount() - 1, new LogInfo(LogInfo.LogState.LOG10));
                        continue;
                    }
                    if (j != 1) continue;
                    colName = diffAnalysisTypeString + " log Ratio";
                    model.addExtraColumn(new ColDoubleData(resTable, (ArrayList)valuesForCol.get(j), colName), (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                    model.addExtraColumnInfo(model.getColumnCount() - 1, new LogRatio());
                }
            } else {
                REXPGenericVector matrix = (REXPGenericVector)res;
                RList list = matrix.asList();
                for (int i = 0; i < list.size(); ++i) {
                    Object colExtraInfo;
                    REXPDouble resDoubleArray = (REXPDouble)list.get(i);
                    double[] d = resDoubleArray.asDoubles();
                    ArrayList<Double> values = new ArrayList<Double>();
                    for (int j = 0; j < d.length; ++j) {
                        values.add(d[j]);
                    }
                    if (i == 0) {
                        String colName = diffAnalysisTypeString + " PValue";
                        colExtraInfo = new PValue();
                        ColDoubleData pvalueCol = new ColDoubleData(resTable, values, colName);
                        ColDoubleData log10PvalueCol = StatsImplementation.log10(pvalueCol);
                        ColDoubleData minusLog10PvalueCol = StatsImplementation.neg(log10PvalueCol);
                        model.addExtraColumn(pvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                        model.addExtraColumnInfo(model.getColumnCount() - 1, colExtraInfo);
                        model.addExtraColumn(minusLog10PvalueCol, (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                        model.addExtraColumnInfo(model.getColumnCount() - 1, colExtraInfo);
                        model.addExtraColumnInfo(model.getColumnCount() - 1, new LogInfo(LogInfo.LogState.LOG10));
                        continue;
                    }
                    if (i != 1) continue;
                    String colName = diffAnalysisTypeString + " log Ratio";
                    colExtraInfo = new LogRatio();
                    model.addExtraColumn(new ColDoubleData(resTable, values, colName), (TableCellRenderer)ExprTableModel.DOUBLE_RENDERER);
                    model.addExtraColumnInfo(model.getColumnCount() - 1, colExtraInfo);
                }
            }
        }
        return resTable;
    }

    public static PyObject computeFDR(Col pvaluesCol, Col logFCCol, PyFloat minusLogPvalueThreshold, PyFloat logFCThreshold, String pi0Parameter, PyFloat alpha, PyInteger nbins, PyFloat pz) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        boolean RStarted = serverR.startRProcessWithRetry();
        if (!RStarted) {
            throw Py.RuntimeError((String)"Server R not found");
        }
        serverR.connect();
        int nbRow = pvaluesCol.getRowCount();
        File tempFile = File.createTempFile("computeFDR", "csv");
        tempFile.deleteOnExit();
        FileWriter fw = new FileWriter(tempFile);
        for (int i = 0; i < nbRow; ++i) {
            double pvalueDouble = StatsRImplementation.asDoubleValue(pvaluesCol, i);
            double logFCDouble = StatsRImplementation.asDoubleValue(logFCCol, i);
            fw.write(String.valueOf(pvalueDouble));
            fw.write(59);
            fw.write(String.valueOf(logFCDouble));
            fw.write(10);
        }
        fw.close();
        PyFloat d = StatsRImplementation._computeFDR(tempFile, minusLogPvalueThreshold, logFCThreshold, pi0Parameter, alpha, nbins, pz);
        tempFile.delete();
        return d;
    }

    private static PyFloat _computeFDR(File f, PyFloat minusLogPvalueThreshold, PyFloat logFCThreshold, String pi0Parameter, PyFloat alpha, PyInteger nbins, PyFloat pz) throws Exception {
        double pValue = minusLogPvalueThreshold.getValue();
        RServerManager serverR = RServerManager.getRServerManager();
        String path = f.getCanonicalPath().replaceAll("\\\\", "/");
        serverR.parseAndEval("library(DAPAR)");
        String cmdReadCSV = "computeFDRValues<-read.delim('" + path + "',header=F, sep=';', col.names=c(\"P_Value\",\"logFC\"))";
        serverR.parseAndEval(cmdReadCSV);
        String cmdBB1 = "computedFDR<-diffAnaComputeFDR(computeFDRValues, " + pValue + "," + logFCThreshold.toString() + "," + pi0Parameter + ")";
        REXPDouble fdr = (REXPDouble)serverR.parseAndEval(cmdBB1);
        return new PyFloat(fdr.asDouble() * 100.0);
    }
}

