/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.math;

import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.PythonImage;
import fr.proline.studio.rserver.RServerManager;
import fr.proline.studio.table.LazyData;
import java.io.File;
import java.io.FileWriter;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class StatsUtil {
    public static final String MATRIX_VARIABLE = "matrixProlineValues";

    public static RServerManager startRServer() throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        boolean RStarted = serverR.startRProcessWithRetry();
        if (!RStarted) {
            throw Py.RuntimeError((String)"Server R not found");
        }
        serverR.connect();
        return serverR;
    }

    public static File columnsToMatrixTempFile(ColRef[] cols, boolean header, boolean log2, boolean keepNaNForR) throws Exception {
        int nbRow = cols[0].getRowCount();
        File tempFile = File.createTempFile("matrix", "csv");
        tempFile.deleteOnExit();
        FileWriter fw = new FileWriter(tempFile);
        if (header) {
            for (int j = 0; j < cols.length; ++j) {
                ColRef c = cols[j];
                fw.write(c.getExportColumnName());
                if (j >= cols.length - 1) continue;
                fw.write(59);
            }
            fw.write(10);
        }
        double LOG2 = StrictMath.log(2.0);
        for (int i = 0; i < nbRow; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                double d;
                ColRef c = cols[j];
                Object o = c.getValueAt(i);
                if (o instanceof LazyData) {
                    o = ((LazyData)o).getData();
                }
                if (o != null && o instanceof Number) {
                    d = ((Number)o).doubleValue();
                    if (d != d && !keepNaNForR) {
                        d = 0.0;
                    }
                } else {
                    d = 0.0;
                }
                if (log2) {
                    d = StrictMath.log(d) / LOG2;
                }
                if (d == d) {
                    fw.write(String.valueOf(d));
                }
                if (j >= cols.length - 1) continue;
                fw.write(59);
            }
            fw.write(10);
        }
        fw.close();
        return tempFile;
    }

    public static File columnToMatrixTempFile(Col col) throws Exception {
        int nbRow = col.getRowCount();
        File tempFile = File.createTempFile("matrix", "csv");
        tempFile.deleteOnExit();
        FileWriter fw = new FileWriter(tempFile);
        for (int i = 0; i < nbRow; ++i) {
            double d;
            Object o = col.getValueAt(i);
            if (o instanceof LazyData) {
                o = ((LazyData)o).getData();
            }
            if (o != null && o instanceof Number) {
                d = ((Number)o).doubleValue();
                if (d != d) {
                    d = 0.0;
                }
            } else {
                d = 0.0;
            }
            fw.write(String.valueOf(d));
            fw.write(10);
        }
        fw.close();
        return tempFile;
    }

    public static File createImageTempFile() throws Exception {
        File imageFile = File.createTempFile("graphics", ".png");
        imageFile.deleteOnExit();
        return imageFile;
    }

    public static PyTuple[] colTupleToTuplesArray(PyTuple p) {
        PyObject[] objArray1 = p.getArray();
        int nb = objArray1.length;
        PyTuple[] tuples = new PyTuple[nb];
        for (int i = 0; i < nb; ++i) {
            tuples[i] = (PyTuple)objArray1[i];
        }
        return tuples;
    }

    public static ColRef[] colTupleToColArray(PyTuple[] pArray) {
        int size = pArray.length;
        int totalNb = 0;
        for (int i = 0; i < size; ++i) {
            PyTuple p = pArray[i];
            PyObject[] objArray = p.getArray();
            totalNb += objArray.length;
        }
        ColRef[] cols = new ColRef[totalNb];
        int index = 0;
        for (int i = 0; i < size; ++i) {
            PyTuple p = pArray[i];
            PyObject[] objArray = p.getArray();
            int nb = objArray.length;
            for (int j = 0; j < nb; ++j) {
                cols[index] = (ColRef)objArray[j];
                ++index;
            }
        }
        return cols;
    }

    public static ColRef[] colTupleToColArray(PyTuple p) {
        PyObject[] objArray1 = p.getArray();
        int nb1 = objArray1.length;
        ColRef[] cols = new ColRef[nb1];
        for (int i = 0; i < nb1; ++i) {
            cols[i] = (ColRef)objArray1[i];
        }
        return cols;
    }

    public static double[] colRefToDoubleArray(ColRef c) {
        int nb = c.getRowCount();
        double[] doubleArray = new double[nb];
        for (int i = 0; i < nb; ++i) {
            double d;
            Object o = c.getValueAt(i);
            if (o instanceof LazyData) {
                o = ((LazyData)o).getData();
            }
            if (o != null && o instanceof Number) {
                d = ((Number)o).doubleValue();
                if (d != d) {
                    d = 0.0;
                }
            } else {
                d = 0.0;
            }
            doubleArray[i] = d;
        }
        return doubleArray;
    }

    public static String stringTupleToRVector(PyTuple p) {
        StringBuilder sb = new StringBuilder();
        sb.append("c(");
        PyObject[] stringArray = p.getArray();
        int nb = stringArray.length;
        for (int i = 0; i < nb; ++i) {
            String s = stringArray[i].toString();
            if (i > 0) {
                sb.append(',');
            }
            sb.append('\"').append(s).append('\"');
        }
        sb.append(')');
        return sb.toString();
    }

    public static String RVectorToRFactor(String rVector) {
        StringBuilder sb = new StringBuilder();
        sb.append("factor(").append(rVector).append(')');
        return sb.toString();
    }

    public static PyTuple colNamesToTuple(ColRef[] cols) {
        int nb = cols.length;
        PyObject[] colNames = new PyObject[nb];
        for (int i = 0; i < nb; ++i) {
            colNames[i] = new PyString(cols[i].getExportColumnName());
        }
        return new PyTuple(colNames);
    }

    public static String getPath(File f) throws Exception {
        return f.getCanonicalPath().replaceAll("\\\\", "/");
    }

    public static void readMatrixData(File matrixTempFile, boolean header) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        char headerChar = header ? (char)'T' : 'F';
        String cmdReadCSV = "matrixProlineValues<-read.delim('" + StatsUtil.getPath(matrixTempFile) + "',header=" + headerChar + ", sep=';')";
        serverR.parseAndEval(cmdReadCSV);
    }

    public static PythonImage createImage(File imageTempFile, String cmd) throws Exception {
        RServerManager serverR = RServerManager.getRServerManager();
        String cmdBB1 = "png(\"" + StatsUtil.getPath(imageTempFile) + "\",width=500, height=500)";
        String cmdBB2 = cmd;
        String cmdBB3 = "dev.off()";
        serverR.parseAndEval(cmdBB1);
        serverR.parseAndEval(cmdBB2);
        serverR.parseAndEval(cmdBB3);
        return new PythonImage(imageTempFile.getCanonicalPath());
    }
}

