/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.model;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ChildModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.BooleanFilter;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

public class ExprTableModel
extends DecoratedTableModel
implements ChildModelInterface {
    private GlobalTableModelInterface m_parentModel;
    public static DoubleRenderer DOUBLE_RENDERER = new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4, true, true);
    private HashMap<Integer, HashMap<Class, Object>> m_colValueMap = null;
    private HashMap<Integer, Col> m_modifiedColumns = null;
    private final ArrayList<Col> m_extraColumns = new ArrayList();
    private final ArrayList<TableCellRenderer> m_extraColumnRenderers = new ArrayList();
    private int m_bestXAxisColIndex = -1;
    private int m_bestYAxisColIndex = -1;
    private PlotType m_bestPlotType = null;

    public ExprTableModel(GlobalTableModelInterface parentModel) {
        this.m_parentModel = parentModel;
    }

    public ExprTableModel(Col column, TableCellRenderer colRenderer, GlobalTableModelInterface parentModel) {
        this(parentModel);
        this.addExtraColumn(column, colRenderer);
    }

    public final void addExtraColumn(Col column, TableCellRenderer colRenderer) {
        this.m_extraColumns.add(column);
        this.m_extraColumnRenderers.add(colRenderer);
    }

    public final void addExtraColumnInfo(int colIndex, Object colExtraInfo) {
        if (colExtraInfo == null) {
            return;
        }
        if (this.m_colValueMap == null) {
            this.m_colValueMap = new HashMap();
        }
        Class<?> c = colExtraInfo.getClass();
        HashMap<Class<Object>, Object> map = this.m_colValueMap.get(colIndex);
        if (map == null) {
            map = new HashMap();
            this.m_colValueMap.put(colIndex, map);
        }
        map.put(c, colExtraInfo);
    }

    public final void modifyColumnValues(HashMap<Integer, Col> modifiedColumns, HashMap<Integer, Object> modifiedColumnsExtraInfo) {
        this.m_modifiedColumns = modifiedColumns;
        if (modifiedColumnsExtraInfo != null) {
            if (this.m_colValueMap == null) {
                this.m_colValueMap = new HashMap();
            }
            for (Integer colIndex : modifiedColumnsExtraInfo.keySet()) {
                Object value = modifiedColumnsExtraInfo.get(colIndex);
                Class<?> c = value.getClass();
                HashMap<Class<Object>, Object> map = this.m_colValueMap.get(colIndex);
                if (map == null) {
                    map = new HashMap();
                    this.m_colValueMap.put(colIndex, map);
                }
                map.put(c, value);
            }
        }
    }

    public int getRowCount() {
        return this.m_parentModel.getRowCount();
    }

    public int getColumnCount() {
        return this.m_parentModel.getColumnCount() + this.m_extraColumns.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Col c;
        int parentCount = this.m_parentModel.getColumnCount();
        if (columnIndex >= parentCount) {
            return this.m_extraColumns.get(columnIndex - parentCount).getValueAt(rowIndex);
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(columnIndex)) != null) {
            return c.getValueAt(rowIndex);
        }
        return this.m_parentModel.getValueAt(rowIndex, columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this.m_parentModel.getColumnCount()) {
            return this.m_extraColumns.get(columnIndex - this.m_parentModel.getColumnCount()).getColumnClass();
        }
        if (this.m_modifiedColumns != null && this.m_modifiedColumns.containsKey(columnIndex)) {
            return Double.class;
        }
        return this.m_parentModel.getColumnClass(columnIndex);
    }

    public String getColumnName(int columnIndex) {
        Col c;
        int parentCount = this.m_parentModel.getColumnCount();
        if (columnIndex >= parentCount) {
            return this.m_extraColumns.get(columnIndex - parentCount).getColumnName();
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(columnIndex)) != null) {
            return c.getColumnName();
        }
        return this.m_parentModel.getColumnName(columnIndex);
    }

    public Long getTaskId() {
        return this.m_parentModel.getTaskId();
    }

    public LazyData getLazyData(int row, int col) {
        Col c;
        if (col >= this.m_parentModel.getColumnCount()) {
            return null;
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(col)) != null) {
            return null;
        }
        return this.m_parentModel.getLazyData(row, col);
    }

    public void givePriorityTo(Long taskId, int row, int col) {
        if (col >= this.m_parentModel.getColumnCount()) {
            return;
        }
        this.m_parentModel.givePriorityTo(taskId, row, col);
    }

    public void sortingChanged(int col) {
        if (col >= this.m_parentModel.getColumnCount()) {
            return;
        }
        this.m_parentModel.sortingChanged(col);
    }

    public int getSubTaskId(int col) {
        if (col >= this.m_parentModel.getColumnCount()) {
            return -1;
        }
        return this.m_parentModel.getSubTaskId(col);
    }

    public String getToolTipForHeader(int col) {
        Col c;
        if (col >= this.m_parentModel.getColumnCount()) {
            return this.getColumnName(col);
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(col)) != null) {
            return c.getColumnName();
        }
        return this.m_parentModel.getToolTipForHeader(col);
    }

    public String getTootlTipValue(int row, int col) {
        Col c;
        if (col >= this.m_parentModel.getColumnCount()) {
            return null;
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(col)) != null) {
            return c.getTooltip();
        }
        return this.m_parentModel.getTootlTipValue(row, col);
    }

    public String getDataColumnIdentifier(int columnIndex) {
        Col c;
        if (columnIndex >= this.m_parentModel.getColumnCount()) {
            return this.getColumnName(columnIndex);
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(columnIndex)) != null) {
            return c.getColumnName();
        }
        return this.m_parentModel.getDataColumnIdentifier(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        if (columnIndex >= this.m_parentModel.getColumnCount()) {
            return this.m_extraColumns.get(columnIndex - this.m_parentModel.getColumnCount()).getColumnClass();
        }
        if (this.m_modifiedColumns != null && this.m_modifiedColumns.containsKey(columnIndex)) {
            return Double.class;
        }
        return this.m_parentModel.getDataColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Col c;
        int parentCount = this.m_parentModel.getColumnCount();
        if (columnIndex >= parentCount) {
            return this.m_extraColumns.get(columnIndex - parentCount).getValueAt(rowIndex);
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(columnIndex)) != null) {
            return c.getValueAt(rowIndex);
        }
        return this.m_parentModel.getDataValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        return this.m_parentModel.getKeysColumn();
    }

    public int getInfoColumn() {
        return this.m_parentModel.getInfoColumn();
    }

    public void setName(String name) {
        this.m_parentModel.setName(name);
    }

    public String getName() {
        return this.m_parentModel.getName();
    }

    public Map<String, Object> getExternalData() {
        return this.m_parentModel.getExternalData();
    }

    public PlotInformation getPlotInformation() {
        return this.m_parentModel.getPlotInformation();
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        if (filtersMap.isEmpty()) {
            this.m_parentModel.addFilters(filtersMap);
        }
        int parentCount = this.m_parentModel.getColumnCount();
        for (int i = 0; i < this.m_extraColumns.size(); ++i) {
            Integer key = i + parentCount;
            if (filtersMap.containsKey(key)) continue;
            Class c = this.m_extraColumns.get(i).getColumnClass();
            if (c.equals(Double.class)) {
                filtersMap.put(key, (Filter)new DoubleFilter(this.m_extraColumns.get(i).getColumnName(), null, parentCount + i));
                continue;
            }
            if (!c.equals(Boolean.class)) continue;
            filtersMap.put(key, (Filter)new BooleanFilter(this.m_extraColumns.get(i).getColumnName(), null, parentCount + i));
        }
    }

    public boolean isLoaded() {
        return this.m_parentModel.isLoaded();
    }

    public int getLoadingPercentage() {
        return this.m_parentModel.getLoadingPercentage();
    }

    public PlotType getBestPlotType() {
        if (this.m_bestPlotType != null) {
            return this.m_bestPlotType;
        }
        return this.m_parentModel.getBestPlotType();
    }

    public int[] getBestColIndex(PlotType plotType) {
        if (this.m_bestPlotType != null) {
            int[] cols = new int[]{this.m_bestXAxisColIndex, this.m_bestYAxisColIndex};
            return cols;
        }
        return this.m_parentModel.getBestColIndex(plotType);
    }

    public void setBestPlot(int bestXAxisColIndex, int bestYAxisColIndex, PlotType bestPlotType) {
        this.m_bestXAxisColIndex = bestXAxisColIndex;
        this.m_bestYAxisColIndex = bestYAxisColIndex;
        this.m_bestPlotType = bestPlotType;
    }

    public String getExportRowCell(int row, int col) {
        Col c;
        if (col >= this.m_parentModel.getColumnCount()) {
            Object o = this.getValueAt(row, col);
            if (o == null) {
                return "";
            }
            return o.toString();
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(col)) != null) {
            Object d = c.getValueAt(row);
            if (d == null) {
                return "";
            }
            return d.toString();
        }
        return this.m_parentModel.getExportRowCell(row, col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        Col c;
        if (col >= this.m_parentModel.getColumnCount()) {
            return null;
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(col)) != null) {
            return null;
        }
        return this.m_parentModel.getExportFonts(row, col);
    }

    public String getExportColumnName(int col) {
        Col c;
        if (col >= this.m_parentModel.getColumnCount()) {
            return this.getColumnName(col);
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(col)) != null) {
            return this.getColumnName(col);
        }
        return this.m_parentModel.getExportColumnName(col);
    }

    public void setParentModel(GlobalTableModelInterface parentModel) {
        if (this.m_parentModel != null) {
            this.m_parentModel.removeTableModelListener((TableModelListener)((Object)this));
        }
        this.m_parentModel = parentModel;
        this.m_parentModel.addTableModelListener((TableModelListener)((Object)this));
    }

    public GlobalTableModelInterface getParentModel() {
        return this.m_parentModel;
    }

    public void tableChanged(TableModelEvent e) {
        this.fireTableDataChanged();
    }

    public TableCellRenderer getRenderer(int row, int col) {
        Col c;
        int parentCount = this.m_parentModel.getColumnCount();
        if (col >= parentCount) {
            return this.m_extraColumnRenderers.get(col - parentCount);
        }
        if (this.m_modifiedColumns != null && (c = this.m_modifiedColumns.get(col)) != null) {
            return DOUBLE_RENDERER;
        }
        return this.m_parentModel.getRenderer(row, col);
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return this.m_parentModel.getExtraDataTypes();
    }

    public Object getValue(Class c) {
        return this.m_parentModel.getValue(c);
    }

    public Object getRowValue(Class c, int row) {
        return this.m_parentModel.getRowValue(c, row);
    }

    public Object getColValue(Class c, int col) {
        Object value;
        HashMap<Class, Object> map;
        if (this.m_colValueMap != null && (map = this.m_colValueMap.get(col)) != null && (value = map.get(c)) != null) {
            return value;
        }
        int parentCount = this.m_parentModel.getColumnCount();
        if (col < parentCount) {
            return this.m_parentModel.getColValue(c, col);
        }
        return null;
    }
}

