/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import fr.proline.logparser.gui.Config;
import fr.proline.logparser.gui.TaskConsolePane;
import fr.proline.logparser.gui.TaskListInterface;
import fr.proline.logparser.gui.TaskLoaderWorker;
import fr.proline.logparser.gui.TaskView;
import fr.proline.logparser.model.LogTask;
import fr.proline.logparser.model.TaskInJsonCtrl;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public abstract class LogControlPanel
extends JPanel {
    protected TaskView m_taskView;
    protected TaskConsolePane m_taskConsole;
    protected TaskListInterface m_taskQueueView;
    protected JProgressBar m_progressBar;

    public LogControlPanel() {
        super(new BorderLayout());
    }

    public abstract void setProgressBarVisible(boolean var1);

    public abstract void setProgress(int var1);

    public abstract boolean isBigFile();

    public abstract int getMaxLine2Show();

    public abstract void redo();

    public void setData(ArrayList<LogTask> tasks, String fileName) {
        this.m_taskQueueView.setData(tasks, fileName);
        if (tasks == null || tasks.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No task to show");
            this.m_taskView.setData(null);
            this.m_taskConsole.setData("");
        }
        this.repaint();
        this.requestFocus();
    }

    public TaskConsolePane getConsole() {
        return this.m_taskConsole;
    }

    public void valueChanged(LogTask selectedTask) {
        Object order = "";
        if (selectedTask != null) {
            order = "" + selectedTask.getTaskOrder();
        }
        this.m_taskView.setData(selectedTask);
        if (selectedTask == null) {
            this.m_taskConsole.setData("");
        } else {
            this.m_taskConsole.setData("In loading...");
            ArrayList<LogTask.LogLine> trace = selectedTask.getTrace();
            if (trace == null) {
                trace = TaskInJsonCtrl.getInstance().loadTrace(selectedTask.getTaskOrder(), Config.getMaxLine2Show());
            }
            TaskLoaderWorker taskLoader = new TaskLoaderWorker(trace, selectedTask.getNbLine(), this);
            taskLoader.execute();
        }
    }

    public void clear() {
        this.m_taskQueueView.setData(null, null);
        this.m_taskView.setData(null);
        this.m_taskConsole.setData("");
    }
}

