/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import fr.proline.logparser.gui.ColorPalette;
import fr.proline.logparser.gui.Config;
import fr.proline.logparser.gui.LogReaderWorker;
import fr.proline.logparser.gui.LogViewControlPanel;
import fr.proline.logparser.model.LogLineReader;
import fr.proline.logparser.model.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogGuiApp
extends JFrame {
    protected static final Logger m_logger = LoggerFactory.getLogger(LogGuiApp.class);
    JFileChooser m_fileChooser = new JFileChooser();
    Utility.DATE_FORMAT m_dateFormat;
    LogViewControlPanel m_logPanel;
    LogLineReader m_logReader;
    LogReaderWorker m_readWorker;
    private String m_path;
    private List<File> m_fileList;
    private JFrame m_taskFlowFrame;
    private JTextPane m_taskFlowPane;
    private boolean m_isBigFile = false;
    private ColorPalette m_colorPanel;
    private JProgressBar m_progressBar;
    static final String TodayDebugFileName = "proline_cortex_debug.txt";
    public static String KEY_LOG_FILE_PATH = "Server_log_file_path";

    public LogGuiApp() {
        super("Log Analyser");
        this.m_fileChooser.setFileFilter(new CortexLogFileFilter());
        this.m_fileChooser.setMultiSelectionEnabled(true);
        this.m_logPanel = new LogViewControlPanel(this);
        this.m_dateFormat = Utility.DATE_FORMAT.SHORT;
        this.m_path = this.initParameters();
        File defaultFile = new File(this.m_path);
        this.m_fileList = new ArrayList<File>();
        this.m_fileChooser.setSelectedFile(defaultFile);
        this.m_fileList.add(defaultFile);
        this.initComponents();
        this.setLocation(230, 2);
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        Image icon = null;
        try {
            String path = "prolineLogo32x32.png";
            ImageIcon ic = new ImageIcon(ImageIO.read(ClassLoader.getSystemResource(path)));
            icon = ic.getImage();
            this.setIconImage(icon);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_taskFlowPane = new JTextPane();
        this.m_taskFlowFrame = new JFrame("Log Task Flow");
        this.m_taskFlowFrame.getContentPane().add(new JScrollPane(this.m_taskFlowPane));
        this.m_taskFlowFrame.setSize(700, 750);
        this.m_taskFlowFrame.setLocation(950, 250);
        this.m_taskFlowFrame.setVisible(true);
        this.m_taskFlowFrame.setIconImage(icon);
        this.setDefaultCloseOperation(3);
        JMenuBar jMenuBar = this.initMenuBar();
        this.setJMenuBar(jMenuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_logPanel, "Center");
        this.m_colorPanel = new ColorPalette();
        this.m_colorPanel.setSize(this.m_colorPanel.getPreferredSize());
        this.m_colorPanel.setLocation(750, 1);
        this.getLayeredPane().add((Component)this.m_colorPanel, JLayeredPane.DRAG_LAYER);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setStringPainted(true);
        this.m_progressBar.setSize(400, 50);
        this.m_progressBar.setVisible(false);
        this.m_progressBar.setLocation(200, 200);
        this.getLayeredPane().add((Component)this.m_progressBar, JLayeredPane.PALETTE_LAYER);
    }

    private JMenuBar initMenuBar() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem analyseFileMenuItem = new JMenuItem("Analyse File");
        analyseFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGuiApp.this.analyseFileActionPerformed(evt);
            }
        });
        fileMenu.add(analyseFileMenuItem);
        JMenuItem exitMunuItem = new JMenuItem("Exit");
        exitMunuItem.addActionListener(evt -> {
            this.dispose();
            System.exit(0);
        });
        fileMenu.add(exitMunuItem);
        JMenu taskMenu = new JMenu("Tasks");
        JMenuItem showTaskFlowItem = new JMenuItem("Show Flow of the tasks");
        showTaskFlowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGuiApp.this.m_taskFlowFrame.setVisible(true);
            }
        });
        final JRadioButtonMenuItem showNBTaskItem = new JRadioButtonMenuItem("Show Color Palette of Parallel Tasks Numbers");
        showNBTaskItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGuiApp.this.m_colorPanel.setVisible(showNBTaskItem.isSelected());
            }
        });
        taskMenu.add(showTaskFlowItem);
        taskMenu.add(showNBTaskItem);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(fileMenu);
        jMenuBar.add(taskMenu);
        return jMenuBar;
    }

    private void analyseFileActionPerformed(ActionEvent evt) {
        int returnVal = this.m_fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this.m_logPanel.clear();
                File f = this.m_fileChooser.getSelectedFile();
                this.m_isBigFile = false;
                m_logger.debug("");
                m_logger.info("Analyse begin with: " + f.getName());
                this.prepareFileList();
                this.parseFile();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex + "\n" + ex.getStackTrace()[0], "Exception", 0);
                StackTraceElement[] trace = ex.getStackTrace();
                Object result = "";
                for (StackTraceElement el : trace) {
                    result = (String)result + el.toString() + "\n";
                }
                m_logger.error(ex + "\n" + (String)result);
            }
        } else {
            m_logger.debug("Open command cancelled by user.");
        }
    }

    private void prepareFileList() {
        File[] files = this.m_fileChooser.getSelectedFiles();
        this.m_fileList = Arrays.asList(files);
        Comparator<File> FileNameComparator = new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String fileName1 = f1.getName();
                String fileName2 = f2.getName();
                if (fileName1.equals(LogGuiApp.TodayDebugFileName)) {
                    return -1;
                }
                if (fileName2.equals(LogGuiApp.TodayDebugFileName)) {
                    return -1;
                }
                return fileName1.compareTo(fileName2);
            }
        };
        Collections.sort(this.m_fileList, FileNameComparator);
        long fileLength = 0L;
        for (File f : this.m_fileList) {
            fileLength += f.length();
        }
        long bigFileSize = Config.getBigFileSize();
        if (fileLength > bigFileSize) {
            this.m_isBigFile = true;
        }
    }

    private void parseFile() {
        File firstFile = this.m_fileList.get(0);
        this.m_logReader = new LogLineReader(firstFile.getName(), this.m_dateFormat, this.m_isBigFile, false);
        this.m_readWorker = new LogReaderWorker(this.m_logPanel, this.m_taskFlowPane, this.m_fileList, this.m_dateFormat, this.m_logReader);
        this.m_readWorker.setStandalon(true);
        this.m_taskFlowFrame.setVisible(true);
        this.m_taskFlowFrame.requestFocus();
        this.m_readWorker.execute();
    }

    public String initParameters() {
        return "";
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new LogGuiApp();
            }
        });
    }

    boolean isBigFile() {
        return this.m_isBigFile;
    }

    void redo() {
        this.m_dateFormat = this.m_dateFormat.equals((Object)Utility.DATE_FORMAT.NORMAL) ? Utility.DATE_FORMAT.SHORT : Utility.DATE_FORMAT.NORMAL;
        this.parseFile();
    }

    public void setProgress(int percent) {
        this.m_progressBar.setValue(percent);
    }

    public void setProgressBarVisible(boolean b) {
        this.m_progressBar.setVisible(b);
    }

    class CortexLogFileFilter
    extends FileFilter {
        CortexLogFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return (name.startsWith("proline_cortex_log") || name.startsWith("proline_cortex_debug_")) && name.endsWith(".txt") || name.equals(LogGuiApp.TodayDebugFileName);
        }

        @Override
        public String getDescription() {
            return "Only proline_cortex_log(debug_).*.txt";
        }
    }
}

