/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.model;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import fr.proline.logparser.model.LogTask;
import fr.proline.logparser.model.ProlineException;
import fr.proline.logparser.model.TaskInJsonCtrl;
import fr.proline.logparser.model.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLineReader {
    protected static final Logger m_logger = LoggerFactory.getLogger(LogLineReader.class);
    private static final int MAX_LINE = 1000;
    private HashMap<String, LogTask> m_msgId2TaskMap;
    private HashMap<String, LogTask> m_thread2TaskMap;
    private ArrayList<String> m_thread2Ignore;
    private ArrayList<LogTask> m_taskInOrder;
    private ArrayList<LogTask> m_taskInRun;
    private Matcher m_lastBeginMatch;
    private Stack<String> m_noTreatLine;
    private Stack<Long> m_noTreatLineIndex;
    private Utility.DATE_FORMAT m_dateFormat;
    public static final String regex_logLevel_9 = "(\\bDEBUG|\\bWARN |\\bERROR|\\bINFO )";
    final String regex_content_Task_ID = "ID:([\\w-]+)";
    final String regex_consumerTaskKey1 = "Consumer selector string:";
    final String regex_ignoreSource = "PeakelsDetector";
    final String regex_consumerTaskKey3 = "Entering ExpiredMessage Consumer receive loop";
    final String regex_consumerTaskKey4 = "Entering Notification Topic Publisher send loop";
    LogTasksFlow m_flow;
    private boolean m_hasNewTrace;
    private TasksFlowWriter m_flowWriter;
    private TaskInJsonCtrl m_taskInJsonCtrl;
    private boolean m_useJsonCtrl;
    private String m_fileName;
    private int m_fileIndex;
    File m_nonTreatedLineFile;

    public LogLineReader(String fileName, Utility.DATE_FORMAT dateFormat, boolean isBigFile, boolean stdout) {
        Utility.init();
        this.m_fileName = fileName.replace(".txt", "");
        this.m_useJsonCtrl = isBigFile;
        this.m_flow = new LogTasksFlow();
        this.m_hasNewTrace = false;
        this.m_flowWriter = new TasksFlowWriter(stdout);
        this.m_flowWriter.open(this.m_fileName);
        this.m_dateFormat = dateFormat;
        this.m_msgId2TaskMap = new HashMap();
        this.m_thread2TaskMap = new HashMap();
        this.m_thread2Ignore = new ArrayList();
        this.m_taskInOrder = new ArrayList();
        this.m_taskInRun = new ArrayList();
        this.m_noTreatLine = new Stack();
        this.m_noTreatLineIndex = new Stack();
        this.m_taskInJsonCtrl = TaskInJsonCtrl.getInstance();
        this.m_taskInJsonCtrl.initFileSystem(fileName);
        this.m_nonTreatedLineFile = new File(Utility.WORKING_DATA_DIRECTORY + File.separator + this.m_fileName + "_NoTreatedLine.txt");
        if (this.m_nonTreatedLineFile.isFile()) {
            this.m_nonTreatedLineFile.delete();
        }
    }

    public String getNewTrace() {
        this.m_hasNewTrace = false;
        return this.m_flow.getNewTrace();
    }

    public boolean isHasNewTrace() {
        return this.m_hasNewTrace;
    }

    private void push(long i, String line) {
        if (this.m_noTreatLine.size() > 1000) {
            this.showNoTreatedLines();
        }
        this.m_noTreatLine.push(line);
        this.m_noTreatLineIndex.push(i);
    }

    private void pop() {
        this.m_noTreatLine.pop();
        this.m_noTreatLineIndex.pop();
    }

    public int getNoTreatLineCount() {
        return this.m_noTreatLine.size();
    }

    public void showNoTreatedLines() {
        if (this.m_noTreatLine.size() == 0) {
            return;
        }
        File nonTreatedLineFile = new File(Utility.WORKING_DATA_DIRECTORY + File.separator + this.m_fileName + "_NoTreatedLine.txt");
        try {
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(nonTreatedLineFile, true));
            while (!this.m_noTreatLine.isEmpty()) {
                bWriter.write("[" + this.m_noTreatLineIndex.pop() + "]," + this.m_noTreatLine.pop());
                bWriter.newLine();
            }
            bWriter.close();
        }
        catch (FileNotFoundException ex) {
            m_logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            m_logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public ArrayList<LogTask> getTasks() {
        return this.m_taskInOrder;
    }

    public void registerTask(int fileIndex, String line, long index) throws ProlineException {
        this.m_fileIndex = fileIndex;
        String regex_date_123 = "^(0[1-9]|[12]\\d|3[01])[ ]([\\w|.]{3,5})[ ](20\\d\\d)";
        String regex_time_4567 = "([01]\\d|2[0-3]):([0-5]\\d):([0-5]\\d).(\\d\\d\\d)";
        String regex_threadPool_8 = "(\\[[\\w|-]+\\])";
        String regex_logSource_10 = "(f[\\w.$]+)";
        String regex_content_Begin = "  - ";
        if (line.length() == 0) {
            return;
        }
        boolean isFound = false;
        String regex_LogLine_pool_head = "^(0[1-9]|[12]\\d|3[01])[ ]([\\w|.]{3,5})[ ](20\\d\\d) ([01]\\d|2[0-3]):([0-5]\\d):([0-5]\\d).(\\d\\d\\d) (\\[[\\w|-]+\\]) (\\bDEBUG|\\bWARN |\\bERROR|\\bINFO ) (f[\\w.$]+)  - ";
        Pattern pattern = Pattern.compile("^(0[1-9]|[12]\\d|3[01])[ ]([\\w|.]{3,5})[ ](20\\d\\d) ([01]\\d|2[0-3]):([0-5]\\d):([0-5]\\d).(\\d\\d\\d) (\\[[\\w|-]+\\]) (\\bDEBUG|\\bWARN |\\bERROR|\\bINFO ) (f[\\w.$]+)  - ");
        Matcher matcher = pattern.matcher(line);
        boolean isNotMatch = false;
        if (matcher.find()) {
            this.m_lastBeginMatch = matcher;
            this.push(index, line);
            Date date = this.getDate(matcher);
            String threadName = matcher.group(8);
            int cutPosition = matcher.end();
            String string2Analyse = line.substring(cutPosition);
            if (threadName.equals("[main]") || threadName.equals("[Timer-PurgeTempDir]")) {
                LogTask existTask = this.m_thread2TaskMap.get(threadName);
                if (existTask != null) {
                    existTask.addLine(this.m_fileIndex, index, line, date, null);
                    this.pop();
                } else {
                    this.createOtherTask(index, line, threadName, date);
                }
            } else {
                if (threadName.contains("ForkJoinPool")) {
                    this.pop();
                    return;
                }
                LogTask existTask = this.m_thread2TaskMap.get(threadName);
                if (existTask != null) {
                    boolean bl = isNotMatch = !this.matchTaskEnd(index, line, string2Analyse, date, threadName);
                    if (isNotMatch) {
                        boolean bl2 = isNotMatch = !this.matchTaskStart(index, line, string2Analyse, date, threadName);
                    }
                    if (isNotMatch) {
                        this.pop();
                        existTask.addLine(this.m_fileIndex, index, line, date, null);
                    }
                } else if (string2Analyse.contains(this.regex_consumerTaskKey1) || string2Analyse.contains(this.regex_consumerTaskKey3) || string2Analyse.contains(this.regex_consumerTaskKey4)) {
                    this.createOtherTask(index, line, threadName, date);
                } else {
                    boolean bl = isNotMatch = !this.matchTaskStart(index, line, string2Analyse, date, threadName);
                    if (isNotMatch) {
                        boolean bl3 = isNotMatch = !this.matchTaskEnd(index, line, string2Analyse, date, threadName);
                        if (isNotMatch) {
                            String source = matcher.group(10);
                            if (!source.contains("PeakelsDetector")) {
                                isNotMatch = !this.matchSubTaskPeakel(string2Analyse, threadName);
                            } else {
                                this.pop();
                            }
                        }
                    }
                }
            }
        } else {
            String regex_content_with_parame = "Calling service \\[([\\w./]+)\\] with JSON Request \\[(\\{[\\w\\W]+\\})\\] \\(##Message##_ID:([\\w-]+)\\)";
            String regex_content_no_parame = "Calling BytesMessage Service \\[([\\w.\\/]+)\\] ()\\(##Message##_ID:([\\w-]+)\\)";
            boolean bl = isNotMatch = !this.matchCallingService("Calling service \\[([\\w./]+)\\] with JSON Request \\[(\\{[\\w\\W]+\\})\\] \\(##Message##_ID:([\\w-]+)\\)", index, line);
            if (isNotMatch) {
                boolean bl4 = isNotMatch = !this.matchCallingService("Calling BytesMessage Service \\[([\\w.\\/]+)\\] ()\\(##Message##_ID:([\\w-]+)\\)", index, line);
            }
            if (isNotMatch) {
                if (this.m_lastBeginMatch != null) {
                    String threadName = this.m_lastBeginMatch.group(8);
                    LogTask task = this.m_thread2TaskMap.get(threadName);
                    if (task != null) {
                        task.addLine(this.m_fileIndex, index, line, null, null);
                    }
                } else {
                    this.push(index, line);
                }
            }
        }
    }

    private void createOtherTask(long index, String line, String threadName, Date date) {
        LogTask newTask = new LogTask(this.m_fileIndex, threadName + "_" + Math.random(), this.m_useJsonCtrl);
        newTask.setThreadName(threadName);
        newTask.setStartLine(this.m_fileIndex, index, line, date);
        newTask.addLine(this.m_fileIndex, index, line, date, null);
        this.pop();
        this.m_thread2TaskMap.put(threadName, newTask);
    }

    private boolean matchSubTaskPeakel(String line, String threadName) {
        String lcmsBegin = "Detecting LC-MS maps...";
        String lcmsEnd = "Peakel stream successfully published !";
        Pattern pattern = Pattern.compile("Detecting LC-MS maps...");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            this.m_thread2Ignore.add(threadName);
            this.pop();
            return true;
        }
        matcher = Pattern.compile("Peakel stream successfully published !").matcher(line);
        if (matcher.find()) {
            this.m_thread2Ignore.remove(threadName);
            this.pop();
            return true;
        }
        if (this.m_thread2Ignore.contains(threadName)) {
            this.pop();
            return true;
        }
        return false;
    }

    private void addTask(LogTask task) {
        task.setTaskOrder(this.m_taskInOrder.size());
        this.m_taskInOrder.add(task);
    }

    private void newTask(LogTask task) {
        String newLine = this.m_flow.taskStart(task);
        if (this.m_flowWriter != null) {
            this.m_flowWriter.addLine(newLine);
        }
        if (this.m_useJsonCtrl) {
            this.m_taskInJsonCtrl.initTaskFile(task);
        }
        this.m_hasNewTrace = true;
    }

    public void close() {
        if (this.m_flow != null) {
            this.m_flow.close();
            this.m_flow = null;
        }
        this.m_hasNewTrace = false;
        this.m_flowWriter.close();
        long start = 0L;
        this.m_dateFormat = null;
        this.m_msgId2TaskMap = null;
        this.m_thread2TaskMap = null;
        this.m_thread2Ignore = null;
        this.m_taskInOrder = null;
        this.m_taskInRun = null;
        this.m_noTreatLine = null;
        this.m_noTreatLineIndex = null;
    }

    public void memoryClean() {
        if (this.m_useJsonCtrl) {
            for (LogTask task : this.m_taskInOrder) {
                if (task.getTrace() == null) continue;
                this.m_taskInJsonCtrl.writeTaskTrace(task, task.isFirstWrite(), true);
                task.emptyTrace();
            }
        }
        this.m_taskInRun = null;
        this.m_msgId2TaskMap = null;
        this.m_thread2TaskMap = null;
    }

    private void removeTask(long time, LogTask task) {
        for (LogTask t : this.m_taskInRun) {
            t.updateNbTask(time, this.m_taskInRun.size() - 1);
        }
        this.m_taskInRun.remove(task);
        this.m_msgId2TaskMap.remove(task.getMessageId());
        this.m_thread2TaskMap.remove(task.getThreadName());
        String newLine = this.m_flow.taskStop(task);
        if (this.m_flowWriter != null) {
            this.m_flowWriter.addLine(newLine);
        }
        this.m_hasNewTrace = true;
        if (this.m_useJsonCtrl) {
            this.m_taskInJsonCtrl.writeTaskTrace(task, task.isFirstWrite(), true);
            task.emptyTrace();
        }
    }

    private boolean matchCallingService(String regex_calling, long index, String line) throws ProlineException {
        Pattern pattern = Pattern.compile(regex_calling);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String service = matcher.group(1);
            String parameter = matcher.group(2);
            String messageId = matcher.group(3);
            LogTask task = this.m_msgId2TaskMap.get(messageId);
            Date date = this.getDate(this.m_lastBeginMatch);
            if (task == null) {
                task = new LogTask(this.m_fileIndex, messageId, this.m_useJsonCtrl);
                this.m_msgId2TaskMap.put(messageId, task);
                String threadName = this.m_lastBeginMatch.group(8);
                this.addTask(task);
                this.m_taskInRun.add(task);
                task.setThreadName(threadName);
                task.setStartLine(this.m_fileIndex, index, line, date);
                LogTask existTaskEnThread = this.m_thread2TaskMap.get(threadName);
                if (existTaskEnThread != null) {
                    LogTask.LogLine lastLine = existTaskEnThread.removeLastLine();
                    task.addLine(this.m_fileIndex, index - 1L, this.m_lastBeginMatch.group(), date, LogTask.STATUS.FINISHED_WARN);
                    this.m_thread2TaskMap.remove(threadName);
                    this.m_taskInRun.remove(existTaskEnThread);
                } else {
                    task.addLine(this.m_fileIndex, index - 1L, this.m_noTreatLine.pop(), date, LogTask.STATUS.RUNNING);
                    this.m_noTreatLineIndex.pop();
                }
                this.updateTaskInRun(task, date.getTime());
                this.m_thread2TaskMap.put(threadName, task);
            }
            task.setCallService(service);
            if (!parameter.isEmpty()) {
                Gson gson = new Gson();
                LinkedTreeMap paramMap = new LinkedTreeMap();
                paramMap = (LinkedTreeMap)gson.fromJson(parameter, paramMap.getClass());
                task.setRequestParam(paramMap);
            }
            task.addLine(this.m_fileIndex, index, line, date, LogTask.STATUS.RUNNING);
            this.matchMetaInfo(service, parameter, task);
            this.newTask(task);
            return true;
        }
        return false;
    }

    private void matchMetaInfo(String service, String parameter, LogTask task) {
        String regex_fileName = "\"[\\w|\\d| |_|.|-]+\"";
        String regex_filePath = "[\\w|\\d| |_|.|-|\\\\|\\/]+";
        if (service.contains("UserAccount")) {
            String regex_login = "(\"login\":\"[\\w\\d]+\")";
            Pattern pattern = Pattern.compile("(\"login\":\"[\\w\\d]+\")");
            Matcher matcher = pattern.matcher(parameter);
            if (matcher.find()) {
                String result = matcher.group(1);
                task.setDataSet(result);
            }
        } else if (service.contains("RegisterRawFile")) {
            String regex_rowFile = "(\"raw_file_identifier\":\"[\\w|\\d| |_|.|-]+\"),";
            Pattern pattern = Pattern.compile("(\"raw_file_identifier\":\"[\\w|\\d| |_|.|-]+\"),");
            Matcher matcher = pattern.matcher(parameter);
            if (matcher.find()) {
                String result = matcher.group(1);
                task.setDataSet(result);
            }
        } else if (service.contains("CreateProject")) {
            Pattern pattern = Pattern.compile("(\"name\":\"[\\w|\\d| |_|.|-]+\"),");
            Matcher matcher = pattern.matcher(parameter);
            if (matcher.find()) {
                String result = matcher.group(1);
                task.setDataSet(result);
            }
        } else if (parameter.contains("ImportMaxQuantResults")) {
            Pattern pattern = Pattern.compile("(\"result_files_dir\":[\\w|\\d| |_|.|-|\\\\|\\/]+),");
            Matcher matcher = pattern.matcher(parameter);
            if (matcher.find()) {
                String result = matcher.group(1);
                task.setDataSet(result);
            }
        } else {
            String regex_projectId = "\"project_id\":([\\d]+)[,]?";
            String regex_dataSet = "(\"result_summary_id\"|\"result_summary_ids\"|\"result_set_ids\"|\"result_set_id\"|\"dataset_id\"|\"resultset_ids\"):([\\[]?[\\d,]+[\\]]?)[,]?";
            String regex_resultFile = "(\"result_files\"):\\[\\{\"(path)\":\"([\\w|\\d| |_|.|-|\\\\|\\/]+)\",";
            Pattern pattern = Pattern.compile("\"project_id\":([\\d]+)[,]?");
            Matcher matcher = pattern.matcher(parameter);
            if (matcher.find()) {
                Object result = matcher.group(1);
                task.setProjectId((String)result);
                pattern = Pattern.compile("(\"result_summary_id\"|\"result_summary_ids\"|\"result_set_ids\"|\"result_set_id\"|\"dataset_id\"|\"resultset_ids\"):([\\[]?[\\d,]+[\\]]?)[,]?");
                matcher = pattern.matcher(parameter);
                if (matcher.find()) {
                    result = matcher.group(1) + ":" + matcher.group(2);
                    task.setDataSet((String)result);
                } else {
                    pattern = Pattern.compile("(\"result_files\"):\\[\\{\"(path)\":\"([\\w|\\d| |_|.|-|\\\\|\\/]+)\",");
                    matcher = pattern.matcher(parameter);
                    if (matcher.find()) {
                        result = matcher.group(1) + ":" + matcher.group(3);
                        task.setDataSet((String)result);
                    } else {
                        String regex_name = "\"project_id\":[\\d]+,(\"[\\w|_]+\":\\d+,)*(\"name\":\"[\\w|\\d| |_|.|-]+\"),";
                        pattern = Pattern.compile("\"project_id\":[\\d]+,(\"[\\w|_]+\":\\d+,)*(\"name\":\"[\\w|\\d| |_|.|-]+\"),");
                        matcher = pattern.matcher(parameter);
                        if (matcher.find()) {
                            result = matcher.group(2);
                            task.setDataSet((String)result);
                        } else {
                            String regex_quant_channel = "\"project_id\":[\\d]+,(\"master_quant_channel_id\":[\\d]+),";
                            pattern = Pattern.compile("\"project_id\":[\\d]+,(\"master_quant_channel_id\":[\\d]+),");
                            matcher = pattern.matcher(parameter);
                            if (matcher.find()) {
                                result = matcher.group(1);
                                task.setDataSet((String)result);
                            } else {
                                String regex_export_rsm = "\"project_id\":\\d+,\"ds_id\":\\d+,\"rsm_id\":(\\d+)";
                                pattern = Pattern.compile("\"project_id\":\\d+,\"ds_id\":\\d+,\"rsm_id\":(\\d+)");
                                matcher = pattern.matcher(parameter);
                                result = "\"rsm_id\": [";
                                while (matcher.find()) {
                                    result = (String)result + matcher.group(1) + ",";
                                }
                                result = (String)result + "]";
                                task.setDataSet((String)result);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean matchTaskEnd(long index, String line2add, String line2Analyse, Date date, String threadName) throws ProlineException {
        LogTask task;
        String regex_content_task_end_2format = "^JMS [r|R]esponse to [\\w\\W]+ID:([\\w-]+)";
        String regex_task_end_no_client = "Request JMS Message has no 'JMSReplyTo' destination: cannot send JSON response to the client";
        Pattern pattern = Pattern.compile("^JMS [r|R]esponse to [\\w\\W]+ID:([\\w-]+)", 8);
        Matcher matcher = pattern.matcher(line2Analyse);
        if (matcher.find()) {
            String messageId = matcher.group(1);
            LogTask task2 = this.m_msgId2TaskMap.get(messageId);
            if (task2 == null) {
                task2 = new LogTask(this.m_fileIndex, messageId, this.m_useJsonCtrl);
                task2.setThreadName(threadName);
                task2.setStartLine(this.m_fileIndex, index, line2add, date);
                this.m_msgId2TaskMap.put(messageId, task2);
                this.addTask(task2);
            }
            task2.addLine(this.m_fileIndex, index, line2add, date, LogTask.STATUS.FINISHED);
            task2.setStopLine(this.m_fileIndex, index, line2Analyse);
            this.removeTask(date.getTime(), task2);
            this.pop();
            return true;
        }
        if (line2Analyse.contains("Request JMS Message has no 'JMSReplyTo' destination: cannot send JSON response to the client") && (task = this.m_thread2TaskMap.get(threadName)) != null) {
            task.addLine(this.m_fileIndex, index, line2add, date, LogTask.STATUS.FINISHED_WARN);
            task.setStopLine(this.m_fileIndex, index, line2Analyse);
            this.removeTask(date.getTime(), task);
            this.pop();
            return true;
        }
        return false;
    }

    private boolean matchTaskStart(long index, String line2add, String line2Analyse, Date date, String threadName) throws ProlineException {
        String test = "Handling Request JMS Message [ID:7ce3cec3-f3e7-11e9-8dbc-7175f01018fd]";
        String regex_content_JMS_BEGIN = "Handling [\\w]+ JMS Message \\[ID:([\\w-]+)\\]";
        Pattern pattern = Pattern.compile("Handling [\\w]+ JMS Message \\[ID:([\\w-]+)\\]", 8);
        Matcher matcher = pattern.matcher(line2Analyse);
        if (matcher.find()) {
            String messageId = matcher.group(1);
            LogTask task = new LogTask(this.m_fileIndex, messageId, this.m_useJsonCtrl);
            this.m_msgId2TaskMap.put(messageId, task);
            this.addTask(task);
            this.m_taskInRun.add(task);
            task.setStatus(LogTask.STATUS.RUNNING);
            task.setStartLine(this.m_fileIndex, index, line2Analyse, date);
            task.setThreadName(threadName);
            LogTask existTask = this.m_thread2TaskMap.get(threadName);
            if (existTask == null) {
                this.m_thread2TaskMap.put(threadName, task);
            } else {
                this.m_thread2TaskMap.replace(threadName, task);
                existTask.setStatus(LogTask.STATUS.FINISHED_WARN);
                this.m_taskInRun.remove(existTask);
            }
            task.addLine(this.m_fileIndex, index, line2add, date, LogTask.STATUS.RUNNING);
            this.pop();
            this.updateTaskInRun(task, date.getTime());
            return true;
        }
        return false;
    }

    public void setDateFormat(Utility.DATE_FORMAT dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    private Date getDate(Matcher matcher) throws ProlineException {
        String LOG_DATE_FORMAT = "dd MMM yyyy HH:mm:ss.SSS";
        String dateString = matcher.group(1) + " " + matcher.group(2) + " " + matcher.group(3) + " " + matcher.group(4) + ":" + matcher.group(5) + ":" + matcher.group(6) + "." + matcher.group(7);
        SimpleDateFormat dateF = switch (this.m_dateFormat) {
            case Utility.DATE_FORMAT.NORMAL -> new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
            case Utility.DATE_FORMAT.SHORT -> {
                DateFormatSymbols symbols = new DateFormatSymbols(new Locale("en", "US"));
                yield new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS", symbols);
            }
            default -> throw new ProlineException(this.m_dateFormat.name());
        };
        try {
            Date date = dateF.parse(dateString);
            return date;
        }
        catch (ParseException ex) {
            throw new ProlineException("DataFormat Exception, in log file date format is: " + dateString + ", dateFormat is " + this.m_dateFormat, ex);
        }
    }

    private void updateTaskInRun(LogTask task, long time) {
        int size = this.m_taskInRun.size() - 1;
        for (LogTask taskInRun : this.m_taskInRun) {
            taskInRun.updateNbTask(time, size);
        }
    }

    class LogTasksFlow {
        ArrayList<LogTask> m_taskList = new ArrayList();
        ArrayList<String> m_newTrace = new ArrayList();
        String m_lineEnd = "\n";

        public void close() {
            this.m_taskList = null;
            this.m_newTrace = new ArrayList();
        }

        private String getNewTrace() {
            Object result = "";
            for (String line : this.m_newTrace) {
                result = (String)result + line;
            }
            this.m_newTrace = new ArrayList();
            return result;
        }

        public String taskStart(LogTask task) {
            Object startMark = "|";
            Object startAddMark = "|";
            ArrayList<LogTask> tasks2Remove = new ArrayList<LogTask>();
            for (int i = 0; i < this.m_taskList.size(); ++i) {
                LogTask oneTask = this.m_taskList.get(i);
                if (oneTask.getStatus().equals((Object)LogTask.STATUS.FINISHED) || oneTask.getStatus().equals((Object)LogTask.STATUS.FINISHED_WARN) || oneTask.getStatus().equals((Object)LogTask.STATUS.FAILED)) {
                    startMark = (String)startMark + "/" + oneTask.getTaskOrder();
                    tasks2Remove.add(oneTask);
                    continue;
                }
                startMark = (String)startMark + "|";
                startAddMark = (String)startAddMark + "|";
            }
            for (LogTask t : tasks2Remove) {
                this.m_taskList.remove(t);
            }
            this.m_taskList.add(task);
            String newLine = (String)startMark + "\\    " + task.getDataSet() + this.m_lineEnd + (String)startMark + "|+" + task.getStartInfo() + this.m_lineEnd;
            this.m_newTrace.add(newLine);
            return newLine;
        }

        public String taskStop(LogTask task) {
            Object startMark = "|";
            Object removeMark = "|";
            for (int i = 0; i < this.m_taskList.size(); ++i) {
                LogTask oneTask = this.m_taskList.get(i);
                startMark = (String)startMark + "|";
                if (oneTask.equals(task)) {
                    String number = i == this.m_taskList.size() - 1 ? "" : "" + oneTask.getTaskOrder();
                    removeMark = (String)removeMark + "/" + number;
                    continue;
                }
                removeMark = (String)removeMark + "|";
            }
            this.m_taskList.remove(task);
            String newLine = (String)startMark + "-" + task.getStopInfo() + this.m_lineEnd + (String)removeMark + this.m_lineEnd;
            this.m_newTrace.add(newLine);
            return newLine;
        }
    }

    class TasksFlowWriter {
        FileWriter m_outputFile;
        boolean m_stdout;
        String FILE_NAME_END = "_TasksFlow.txt";

        public TasksFlowWriter(boolean stdout) {
            this.m_stdout = stdout;
        }

        public void close() {
            try {
                if (this.m_outputFile != null) {
                    this.m_outputFile.close();
                }
            }
            catch (IOException ex) {
                m_logger.error(ex.getMessage(), (Throwable)ex);
            }
        }

        public void open(String file2Anaylse) {
            try {
                this.m_outputFile = new FileWriter(Utility.WORKING_DATA_DIRECTORY + File.separator + file2Anaylse + this.FILE_NAME_END);
                String head = "Analyse " + file2Anaylse;
                this.m_outputFile.write(head);
                if (this.m_stdout) {
                    System.out.println(head);
                }
            }
            catch (IOException ex) {
                m_logger.error(ex.getMessage(), (Throwable)ex);
            }
        }

        public void addLine(String s) {
            try {
                this.m_outputFile.write(s);
                if (this.m_stdout) {
                    System.out.print(s);
                }
            }
            catch (IOException ex) {
                m_logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

