/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.MsQuery;
import fr.proline.core.orm.msi.ResultSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@NamedQueries(value={@NamedQuery(name="findPeptideMatchesByResultSet", query="Select pm from PeptideMatch pm where pm.resultSet.id=:id"), @NamedQuery(name="findPeptideMatchesByPeptide", query="Select pm from PeptideMatch pm where pm.peptideId=:id"), @NamedQuery(name="findPeptideMatchesByPeptideAndResultSet", query="Select pm from PeptideMatch pm where pm.resultSet.id=:resultset_id and pm.peptideId=:peptide_id")})
@Table(name="peptide_match")
public class PeptideMatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private int charge;
    @Column(name="delta_moz")
    private Float deltaMoz;
    @Column(name="experimental_moz")
    private double experimentalMoz;
    @Column(name="fragment_match_count")
    private Integer fragmentMatchCount;
    @Column(name="is_decoy")
    private boolean isDecoy;
    @Column(name="missed_cleavage")
    private int missedCleavage;
    @Column(name="peptide_id")
    private long peptideId;
    private Integer rank;
    @Column(name="cd_pretty_rank")
    private Integer cdPrettyRank;
    @Column(name="sd_pretty_rank")
    private Integer sdPrettyRank;
    @ManyToOne
    @JoinColumn(name="result_set_id")
    private ResultSet resultSet;
    private Float score;
    @Column(name="scoring_id")
    private long scoringId;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ms_query_id")
    private MsQuery msQuery;
    @ManyToOne
    @JoinColumn(name="best_child_id")
    private PeptideMatch bestPeptideMatch;
    @OneToMany
    @JoinTable(name="peptide_match_relation", joinColumns={@JoinColumn(name="child_peptide_match_id")}, inverseJoinColumns={@JoinColumn(name="parent_peptide_match_id")})
    private Set<PeptideMatch> children;
    @ElementCollection
    @MapKeyColumn(name="schema_name")
    @Column(name="object_tree_id")
    @CollectionTable(name="peptide_match_object_tree_map", joinColumns={@JoinColumn(name="peptide_match_id", referencedColumnName="id")})
    private Map<String, Long> objectTreeIdByName;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int pCharge) {
        this.charge = pCharge;
    }

    public Float getDeltaMoz() {
        return this.deltaMoz;
    }

    public void setDeltaMoz(Float pDeltaMoz) {
        this.deltaMoz = pDeltaMoz;
    }

    public double getExperimentalMoz() {
        return this.experimentalMoz;
    }

    public void setExperimentalMoz(double experimentalMoz) {
        this.experimentalMoz = experimentalMoz;
    }

    public Integer getFragmentMatchCount() {
        return this.fragmentMatchCount;
    }

    public void setFragmentMatchCount(Integer fragmentMatchCount) {
        this.fragmentMatchCount = fragmentMatchCount;
    }

    public boolean getIsDecoy() {
        return this.isDecoy;
    }

    public void setIsDecoy(boolean pIsDecoy) {
        this.isDecoy = pIsDecoy;
    }

    public int getMissedCleavage() {
        return this.missedCleavage;
    }

    public void setMissedCleavage(int pMissedCleavage) {
        this.missedCleavage = pMissedCleavage;
    }

    public long getPeptideId() {
        return this.peptideId;
    }

    public void setPeptideId(long pPeptideId) {
        this.peptideId = pPeptideId;
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getCDPrettyRank() {
        return this.cdPrettyRank;
    }

    public void setCDPrettyRank(Integer cdPrettyRank) {
        this.cdPrettyRank = cdPrettyRank;
    }

    public Integer getSDPrettyRank() {
        return this.sdPrettyRank;
    }

    public void setSDPrettyRank(Integer sdPrettyRank) {
        this.sdPrettyRank = sdPrettyRank;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float pScore) {
        this.score = pScore;
    }

    public long getScoringId() {
        return this.scoringId;
    }

    public void setScoringId(long pScoringId) {
        this.scoringId = pScoringId;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public MsQuery getMsQuery() {
        return this.msQuery;
    }

    public void setMsQuery(MsQuery msQuery) {
        this.msQuery = msQuery;
    }

    public PeptideMatch getBestPeptideMatch() {
        return this.bestPeptideMatch;
    }

    public void setBestPeptideMatch(PeptideMatch bestPeptideMatch) {
        this.bestPeptideMatch = bestPeptideMatch;
    }

    public Set<PeptideMatch> getChildren() {
        return this.children;
    }

    public void setChildren(Set<PeptideMatch> children) {
        this.children = children;
    }

    void setObjectTreeIdByName(Map<String, Long> objectTree) {
        this.objectTreeIdByName = objectTree;
    }

    public Map<String, Long> getObjectTreeIdByName() {
        return this.objectTreeIdByName;
    }

    public Long putObject(String schemaName, long objectId) {
        if (StringUtils.isEmpty((String)schemaName)) {
            throw new IllegalArgumentException("Invalid schemaName");
        }
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree == null) {
            localObjectTree = new HashMap<String, Long>();
            this.setObjectTreeIdByName(localObjectTree);
        }
        return localObjectTree.put(schemaName, objectId);
    }

    public Long removeObject(String schemaName) {
        Long result = null;
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree != null) {
            result = localObjectTree.remove(schemaName);
        }
        return result;
    }
}

