/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@NamedQuery(name="findPtmClassificationForName", query="select pc from fr.proline.core.orm.msi.PtmClassification pc where upper(pc.name) = :name")
@Table(name="ptm_classification")
public class PtmClassification
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private long id;
    private String name;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(PtmClassificationName name) {
        this.name = name.toString();
    }

    public static final class PtmClassificationName
    extends Enum<PtmClassificationName> {
        public static final /* enum */ PtmClassificationName UNKNOWN = new PtmClassificationName("-");
        public static final /* enum */ PtmClassificationName POST_TRANSLATIONAL = new PtmClassificationName("Post-translational");
        public static final /* enum */ PtmClassificationName CO_TRANSLATIONAL = new PtmClassificationName("Co-translational");
        public static final /* enum */ PtmClassificationName PRE_TRANSLATIONAL = new PtmClassificationName("Pre-translational");
        public static final /* enum */ PtmClassificationName CHEMICAL_DERIVATIVE = new PtmClassificationName("Chemical derivative");
        public static final /* enum */ PtmClassificationName ARTEFACT = new PtmClassificationName("Artefact");
        public static final /* enum */ PtmClassificationName N_LINKED_GLYCOSYLATION = new PtmClassificationName("N-linked glycosylation");
        public static final /* enum */ PtmClassificationName O_LINKED_GLYCOSYLATION = new PtmClassificationName("O-linked glycosylation");
        public static final /* enum */ PtmClassificationName OTHER_GLYCOSYLATION = new PtmClassificationName("Other glycosylation");
        public static final /* enum */ PtmClassificationName SYNTH_PEP_PROTECT_GP = new PtmClassificationName("Synth. pep. protect. gp.");
        public static final /* enum */ PtmClassificationName ISOTOPIC_LABEL = new PtmClassificationName("Isotopic label");
        public static final /* enum */ PtmClassificationName NON_STANDARD_RESIDUE = new PtmClassificationName("Non-standard residue");
        public static final /* enum */ PtmClassificationName MULTIPLE = new PtmClassificationName("Multiple");
        public static final /* enum */ PtmClassificationName OTHER = new PtmClassificationName("Other");
        public static final /* enum */ PtmClassificationName AA_SUBSTITUTION = new PtmClassificationName("AA substitution");
        private final String m_name;
        private static HashMap<String, PtmClassificationName> ptmClassifNameByName;
        private static final /* synthetic */ PtmClassificationName[] $VALUES;

        public static PtmClassificationName[] values() {
            return (PtmClassificationName[])$VALUES.clone();
        }

        public static PtmClassificationName valueOf(String name) {
            return Enum.valueOf(PtmClassificationName.class, name);
        }

        private PtmClassificationName(String name) {
            assert (!StringUtils.isEmpty((String)name)) : "Classification.Name() invalid name";
            this.m_name = name;
        }

        public static PtmClassificationName withName(String name) {
            if (ptmClassifNameByName == null) {
                ptmClassifNameByName = new HashMap();
                for (PtmClassificationName ptmClassifName : PtmClassificationName.values()) {
                    ptmClassifNameByName.put(ptmClassifName.toString(), ptmClassifName);
                }
            }
            return ptmClassifNameByName.get(name);
        }

        public String toString() {
            return this.m_name;
        }

        private static /* synthetic */ PtmClassificationName[] $values() {
            return new PtmClassificationName[]{UNKNOWN, POST_TRANSLATIONAL, CO_TRANSLATIONAL, PRE_TRANSLATIONAL, CHEMICAL_DERIVATIVE, ARTEFACT, N_LINKED_GLYCOSYLATION, O_LINKED_GLYCOSYLATION, OTHER_GLYCOSYLATION, SYNTH_PEP_PROTECT_GP, ISOTOPIC_LABEL, NON_STANDARD_RESIDUE, MULTIPLE, OTHER, AA_SUBSTITUTION};
        }

        static {
            $VALUES = PtmClassificationName.$values();
            ptmClassifNameByName = null;
        }
    }
}

