/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;

@Entity
@NamedQuery(name="findScoringForScoreType", query="select s from fr.proline.core.orm.msi.Scoring s where concat(concat(s.searchEngine, ':'), s.name) = :scoreType")
public class Scoring
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String description;
    private String name;
    @Column(name="search_engine")
    private String searchEngine;
    @Column(name="serialized_properties")
    private String serializedProperties;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSearchEngine() {
        return this.searchEngine;
    }

    public void setSearchEngine(String searchEngine) {
        this.searchEngine = searchEngine;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type ANDROMEDA_SCORE = new Type("andromeda", "score", "The score provided by Andromeda for a peptide match.");
        public static final /* enum */ Type COMET_EVALUE_LOG_SCALED = new Type("comet", "evalue log scaled", "The -log10(expectation value) provided by Comet for a peptide match.");
        public static final /* enum */ Type MASCOT_IONS_SCORE = new Type("mascot", "ions score", "The score provided for each Mascot peptide.");
        public static final /* enum */ Type MASCOT_STANDARD_SCORE = new Type("mascot", "standard score", "The score provided for each Mascot protein hit (it corresponds to the sum of ion scores).");
        public static final /* enum */ Type MASCOT_MUDPIT_SCORE = new Type("mascot", "mudpit score", "The score provided for each Mascot protein hit when the number of MS/MS queries is high.");
        public static final /* enum */ Type MASCOT_MODIFIED_MUDPIT_SCORE = new Type("mascot", "modified mudpit score", "A modified version of the MudPIT score computed by Proline.");
        public static final /* enum */ Type OMSSA_EVALUE = new Type("omssa", "expect value", "The -log10(E-value) provided by OMSSA for a peptide match.");
        public static final /* enum */ Type PEPTIDE_SHAKER_PSM_SCORE = new Type("peptide_shaker", "psm score", "The score provided by PeptideShaker for a peptide match.");
        public static final /* enum */ Type MSGF_EVALUE_LOG_SCALED = new Type("msgf", "evalue log scaled", "The -log10(EValue) provided by MS-GF for a peptide match.");
        public static final /* enum */ Type PERCOLATOR_PEP_LOG_SCALED = new Type("percolator", "pep log scaled", "The -10 * log10(PEP) provided by Percolator for a peptide match.");
        public static final /* enum */ Type SEQUEST_EXPECT_LOG_SCALED = new Type("sequest", "expect log scaled", "The -log10(expect) provided by Sequest for a peptide match.");
        public static final /* enum */ Type XTANDEM_EXPECT_LOG_SCALED = new Type("xtandem", "expect log scaled", "The -log10(expect) provided by X!Tandem for a peptide match.");
        public static final /* enum */ Type XTANDEM_HYPERSCORE = new Type("xtandem", "hyperscore", "The hyperscore provided by X!Tandem for a peptide match.");
        public static final /* enum */ Type PROLINE_FISHERSCORE = new Type("proline", "fisher score", "The score calculated by Proline for a protein.");
        private final String m_searchEngine;
        private final String m_name;
        private final String m_description;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String searchEngine, String name, String description) {
            assert (!StringUtils.isEmpty((String)searchEngine)) : "Scoring.Type() invalid searchEngine";
            assert (!StringUtils.isEmpty((String)name)) : "Scoring.Type() invalid name";
            assert (!StringUtils.isEmpty((String)description)) : "Scoring.Type() invalid description";
            this.m_searchEngine = searchEngine;
            this.m_name = name;
            this.m_description = description;
        }

        public String getSearchEngine() {
            return this.m_searchEngine;
        }

        public String getName() {
            return this.m_name;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String toString() {
            return this.m_searchEngine + ":" + this.m_name;
        }

        private static /* synthetic */ Type[] $values() {
            return new Type[]{ANDROMEDA_SCORE, COMET_EVALUE_LOG_SCALED, MASCOT_IONS_SCORE, MASCOT_STANDARD_SCORE, MASCOT_MUDPIT_SCORE, MASCOT_MODIFIED_MUDPIT_SCORE, OMSSA_EVALUE, PEPTIDE_SHAKER_PSM_SCORE, MSGF_EVALUE_LOG_SCALED, PERCOLATOR_PEP_LOG_SCALED, SEQUEST_EXPECT_LOG_SCALED, XTANDEM_EXPECT_LOG_SCALED, XTANDEM_HYPERSCORE, PROLINE_FISHERSCORE};
        }

        static {
            $VALUES = Type.$values();
        }
    }
}

