/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.proline.core.orm.msi.MasterQuantComponent;
import fr.proline.core.orm.msi.MasterQuantPeptideIon;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.PeptideMatch;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DQuantPeptideIon;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DMasterQuantPeptideIon {
    private long m_id;
    private ResultSummary m_resultSummary;
    private DPeptideInstance m_peptideInstance;
    private Map<Long, DQuantPeptideIon> m_quantPeptideIonByQchIds = null;
    private MasterQuantComponent m_masterQuantComponent;
    private DPeptideMatch m_bestPeptideMatch;
    private int m_charge;
    private double m_moz;
    private float m_elutionTime;
    private Long m_lcmsMasterFeatureId;
    private DPeptideMatch m_representativePepMatch;
    private Boolean m_usedInPeptide;
    private PepIonStatus m_pepIonStatus;

    public DMasterQuantPeptideIon() {
        this.m_pepIonStatus = PepIonStatus.UNKNOWN;
    }

    public DMasterQuantPeptideIon(MasterQuantPeptideIon mqpi) {
        this.m_id = mqpi.getId();
        this.m_resultSummary = mqpi.getResultSummary();
        this.m_quantPeptideIonByQchIds = mqpi.getQuantPeptideIonByQchIds();
        this.m_masterQuantComponent = mqpi.getMasterQuantComponent();
        this.m_charge = mqpi.getCharge();
        this.m_moz = mqpi.getMoz();
        this.m_elutionTime = mqpi.getElutionTime();
        this.m_lcmsMasterFeatureId = mqpi.getLcmsMasterFeatureId();
        try {
            this.m_peptideInstance = new DPeptideInstance(mqpi.getPeptideInstance());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updatePepIonStatus();
    }

    public DMasterQuantPeptideIon(PeptideInstance pi, MasterQuantPeptideIon mqpi, Peptide p, PeptideMatch bpm) throws IOException {
        this.m_id = mqpi.getId();
        this.m_resultSummary = mqpi.getResultSummary();
        this.m_quantPeptideIonByQchIds = mqpi.getQuantPeptideIonByQchIds();
        this.m_masterQuantComponent = mqpi.getMasterQuantComponent();
        this.m_charge = mqpi.getCharge();
        this.m_moz = mqpi.getMoz();
        this.m_elutionTime = mqpi.getElutionTime();
        this.m_peptideInstance = new DPeptideInstance(pi);
        this.m_peptideInstance.setPeptide(p);
        this.m_bestPeptideMatch = new DPeptideMatch(bpm.getId(), bpm.getRank(), bpm.getCharge(), bpm.getDeltaMoz(), bpm.getExperimentalMoz(), bpm.getMissedCleavage(), bpm.getScore(), bpm.getResultSet().getId(), bpm.getCDPrettyRank(), bpm.getSDPrettyRank(), bpm.getIsDecoy(), bpm.getSerializedProperties());
        this.m_bestPeptideMatch.setPeptide(p);
        this.m_lcmsMasterFeatureId = mqpi.getLcmsMasterFeatureId();
        this.updatePepIonStatus();
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long pId) {
        this.m_id = pId;
    }

    public ResultSummary getResultSummary() {
        return this.m_resultSummary;
    }

    public void setResultSummary(ResultSummary resultSummary) {
        this.m_resultSummary = resultSummary;
    }

    public DPeptideInstance getPeptideInstance() {
        return this.m_peptideInstance;
    }

    public void setPeptideInstance(DPeptideInstance pPeptideInstance) {
        this.m_peptideInstance = pPeptideInstance;
    }

    public int getCharge() {
        return this.m_charge;
    }

    public void setCharge(int charge) {
        this.m_charge = charge;
    }

    public double getMoz() {
        return this.m_moz;
    }

    public void setMoz(double pMoz) {
        this.m_moz = pMoz;
    }

    public float getElutionTime() {
        return this.m_elutionTime;
    }

    public void setElutionTime(float pElutionTime) {
        this.m_elutionTime = pElutionTime;
    }

    public Map<Long, DQuantPeptideIon> getQuantPeptideIonByQchIds() {
        return this.m_quantPeptideIonByQchIds;
    }

    public Long getLcmsMasterFeatureId() {
        return this.m_lcmsMasterFeatureId;
    }

    public void setLcmsMasterFeatureId(Long pLcmsMasterFeatureId) {
        this.m_lcmsMasterFeatureId = pLcmsMasterFeatureId;
    }

    public void setQuantPeptideIonByQchIds(Map<Long, DQuantPeptideIon> quantPeptideIonByQchIds) {
        this.m_quantPeptideIonByQchIds = quantPeptideIonByQchIds;
    }

    public MasterQuantComponent getMasterQuantComponent() {
        return this.m_masterQuantComponent;
    }

    public void setMasterQuantComponent(MasterQuantComponent masterQuantComponent) {
        this.m_masterQuantComponent = masterQuantComponent;
        this.updatePepIonStatus();
    }

    public DPeptideMatch getBestPeptideMatch() {
        return this.m_bestPeptideMatch;
    }

    public void setBestPeptideMatch(DPeptideMatch bestPeptideMatch) {
        this.m_bestPeptideMatch = bestPeptideMatch;
    }

    public DPeptideMatch getRepresentativePepMatch() {
        if (this.m_representativePepMatch == null) {
            return this.getBestPeptideMatch();
        }
        return this.m_representativePepMatch;
    }

    public void setRepresentativePepMatch(DPeptideMatch representativePepMatch) {
        this.m_representativePepMatch = representativePepMatch;
    }

    public Map<Long, DQuantPeptideIon> parseQuantPeptideIonFromProperties(String quantPeptideIonData) {
        try {
            ObjectMapper objectMapper = JsonSerializer.getMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            List quantPepIons = (List)objectMapper.readValue(quantPeptideIonData, (TypeReference)new TypeReference<List<DQuantPeptideIon>>(){});
            this.m_quantPeptideIonByQchIds = new HashMap<Long, DQuantPeptideIon>();
            if (quantPepIons != null) {
                for (int i = 0; i < quantPepIons.size(); ++i) {
                    DQuantPeptideIon nextQuantPepIon = (DQuantPeptideIon)quantPepIons.get(i);
                    if (nextQuantPepIon == null) continue;
                    this.m_quantPeptideIonByQchIds.put(nextQuantPepIon.getQuantChannelId(), nextQuantPepIon);
                }
            }
        }
        catch (Exception e) {
            this.m_quantPeptideIonByQchIds = null;
        }
        return this.m_quantPeptideIonByQchIds;
    }

    public void setUsedInPeptide(boolean isUsed) {
        if (this.m_usedInPeptide == null || !this.m_usedInPeptide.equals(isUsed)) {
            this.m_usedInPeptide = isUsed;
            this.updatePepIonStatus();
        }
    }

    public Boolean isUsedInPeptide() {
        return this.m_usedInPeptide;
    }

    private void updatePepIonStatus() {
        boolean selected;
        if (this.m_masterQuantComponent == null) {
            this.m_pepIonStatus = PepIonStatus.UNKNOWN;
            return;
        }
        boolean bl = selected = this.m_masterQuantComponent.getSelectionLevel() >= 2;
        this.m_pepIonStatus = !selected ? PepIonStatus.INVALIDATED : (this.m_usedInPeptide == null ? PepIonStatus.VALIDATED : (this.m_usedInPeptide != false ? PepIonStatus.USED_VALIDATED : PepIonStatus.UNUSED_VALIDATED));
    }

    public PepIonStatus getPepIonStatus() {
        return this.m_pepIonStatus;
    }

    public static enum PepIonStatus {
        UNKNOWN,
        INVALIDATED,
        VALIDATED,
        USED_VALIDATED,
        UNUSED_VALIDATED;

    }
}

