/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import fr.proline.core.orm.msi.dto.DSpectrum;

public class DMsQuery
implements Comparable<DMsQuery> {
    private long m_peptideMatchId;
    private long m_id;
    private int m_initialId;
    private Float m_precursorIntensity;
    private int m_charge;
    private double m_moz;
    private DSpectrum m_dSpectrum;
    private boolean m_spectrumSet;

    public DMsQuery(long peptideMatchId, long id, int initialId, Float precursorIntensity) {
        this.m_peptideMatchId = peptideMatchId;
        this.m_id = id;
        this.m_initialId = initialId;
        this.m_precursorIntensity = precursorIntensity;
        this.m_dSpectrum = null;
        this.m_spectrumSet = false;
    }

    public int getCharge() {
        return this.m_charge;
    }

    public void setCharge(int charge) {
        this.m_charge = charge;
    }

    public double getMoz() {
        return this.m_moz;
    }

    public void setMoz(double moz) {
        this.m_moz = moz;
    }

    public Float getPrecursorIntensity() {
        return this.m_precursorIntensity;
    }

    public long getPeptideMatchId() {
        return this.m_peptideMatchId;
    }

    public long getId() {
        return this.m_id;
    }

    public int getInitialId() {
        return this.m_initialId;
    }

    public DSpectrum getDSpectrum() {
        return this.m_dSpectrum;
    }

    public void setDSpectrum(DSpectrum spectrum) {
        this.m_dSpectrum = spectrum;
        this.m_spectrumSet = true;
    }

    public boolean isSpectrumSet() {
        return this.m_spectrumSet;
    }

    public boolean isSpectrumFullySet() {
        if (!this.m_spectrumSet) {
            return false;
        }
        return this.getDSpectrum().getIntensityList() != null;
    }

    @Override
    public int compareTo(DMsQuery otherQuery) {
        return Integer.valueOf(this.getInitialId()).compareTo(otherQuery.getInitialId());
    }

    public String toString() {
        return Integer.toString(this.getInitialId());
    }
}

