/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.PeaklistSoftware;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class MsiPeaklistSoftwareRepository {
    private MsiPeaklistSoftwareRepository() {
    }

    public static PeaklistSoftware findPeaklistSoftForNameAndVersion(EntityManager msiEm, String name, String version) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        PeaklistSoftware result = null;
        TypedQuery query = null;
        if (version == null) {
            query = msiEm.createNamedQuery("findMsiPeaklistSoftForName", PeaklistSoftware.class);
        } else {
            query = msiEm.createNamedQuery("findMsiPeaklistSoftForNameAndVersion", PeaklistSoftware.class);
            query.setParameter("version", (Object)version.toUpperCase());
        }
        query.setParameter("name", (Object)name.toUpperCase());
        List softs = query.getResultList();
        if (softs != null && !softs.isEmpty()) {
            if (softs.size() == 1) {
                result = (PeaklistSoftware)softs.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one PeaklistSoftware for given name and version");
            }
        }
        return result;
    }
}

