/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.dto;

import fr.proline.core.orm.MergeMode;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.ObjectTree;
import fr.proline.core.orm.uds.ObjectTreeSchema;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.dto.DDataset;

public class DDatasetType {
    private Dataset.DatasetType m_type;
    private Aggregation m_aggregation;
    private AggregationInformation m_aggregationInformation = AggregationInformation.UNKNOWN;
    private QuantitationMethod m_quantitationMethod;
    private DDataset m_dataset;

    public DDatasetType(DDataset dataset, Dataset.DatasetType m_type, Aggregation m_aggregation, QuantitationMethod m_quantitationMethod) {
        this.m_dataset = dataset;
        this.m_type = m_type;
        this.m_aggregation = m_aggregation;
        this.m_quantitationMethod = m_quantitationMethod;
    }

    protected void setAggregation(Aggregation aggregation) {
        this.m_aggregation = aggregation;
    }

    protected Aggregation getAggregation() {
        return this.m_aggregation;
    }

    protected void setQuantitationMethod(QuantitationMethod quantitationMethod) {
        this.m_quantitationMethod = quantitationMethod;
    }

    protected QuantitationMethod getQuantitationMethod() {
        return this.m_quantitationMethod;
    }

    protected void setAggregationInformation(AggregationInformation aggregationInformation) {
        this.m_aggregationInformation = aggregationInformation;
    }

    public boolean isIdentification() {
        return this.m_type == Dataset.DatasetType.IDENTIFICATION || this.m_type == Dataset.DatasetType.IDENTIFICATION_FOLDER || this.m_type == Dataset.DatasetType.AGGREGATE;
    }

    public boolean isQuantitation() {
        return this.m_type == Dataset.DatasetType.QUANTITATION || this.m_type == Dataset.DatasetType.QUANTITATION_FOLDER;
    }

    public boolean isTrash() {
        return this.m_type == Dataset.DatasetType.TRASH;
    }

    public boolean isFolder() {
        return this.m_type == Dataset.DatasetType.IDENTIFICATION_FOLDER || this.m_type == Dataset.DatasetType.QUANTITATION_FOLDER;
    }

    public boolean isAggregation() {
        if (this.m_type == Dataset.DatasetType.AGGREGATE) {
            return true;
        }
        if (this.m_dataset != null) {
            ObjectTree quantProcessingConfig = this.m_dataset.getQuantProcessingConfig();
            return this.isQuantitation() && quantProcessingConfig != null && quantProcessingConfig.getSchema().getName().equals(ObjectTreeSchema.SchemaName.AGGREGATION_QUANT_CONFIG.getKeyName());
        }
        return false;
    }

    public AggregationInformation getAggregationInformation() {
        if (this.m_aggregationInformation == null || this.m_aggregationInformation.equals((Object)AggregationInformation.UNKNOWN)) {
            this.m_aggregationInformation = AggregationInformation.UNKNOWN;
            try {
                ResultSet resultSet = this.m_dataset.getResultSet();
                ResultSummary resultSummary = this.m_dataset.getResultSummary();
                if (resultSet != null && (resultSet.getMergeMode().equals((Object)MergeMode.UNION) || resultSet.getMergeMode().equals((Object)MergeMode.AGGREGATION))) {
                    switch (resultSet.getMergeMode()) {
                        case UNION: {
                            this.m_aggregationInformation = AggregationInformation.SEARCH_RESULT_UNION;
                            break;
                        }
                        case AGGREGATION: {
                            this.m_aggregationInformation = AggregationInformation.SEARCH_RESULT_AGG;
                        }
                    }
                } else if (resultSummary != null && (resultSummary.getMergeMode().equals((Object)MergeMode.UNION) || resultSummary.getMergeMode().equals((Object)MergeMode.AGGREGATION))) {
                    switch (resultSummary.getMergeMode()) {
                        case UNION: {
                            this.m_aggregationInformation = AggregationInformation.IDENTIFICATION_SUMMARY_UNION;
                            break;
                        }
                        case AGGREGATION: {
                            this.m_aggregationInformation = AggregationInformation.IDENTIFICATION_SUMMARY_AGG;
                        }
                    }
                } else if (resultSet != null && resultSummary != null && resultSet.getMergeMode().equals((Object)MergeMode.NO_MERGE) && resultSummary.getMergeMode().equals((Object)MergeMode.NO_MERGE)) {
                    this.m_aggregationInformation = AggregationInformation.NONE;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_aggregationInformation;
    }

    public QuantitationMethodInfo getQuantMethodInfo() {
        if (this.m_quantitationMethod == null) {
            return QuantitationMethodInfo.NONE;
        }
        if (this.m_quantitationMethod.getAbundanceUnit().equalsIgnoreCase("feature_intensity")) {
            return QuantitationMethodInfo.FEATURES_EXTRACTION;
        }
        if (this.m_quantitationMethod.getAbundanceUnit().equalsIgnoreCase("spectral_counts")) {
            return QuantitationMethodInfo.SPECTRAL_COUNTING;
        }
        return QuantitationMethodInfo.valueOf(this.m_quantitationMethod.getType().toUpperCase());
    }

    public static enum AggregationInformation {
        UNKNOWN,
        NONE,
        SEARCH_RESULT_UNION,
        IDENTIFICATION_SUMMARY_UNION,
        SEARCH_RESULT_AGG,
        IDENTIFICATION_SUMMARY_AGG;

    }

    public static enum QuantitationMethodInfo {
        NONE,
        ATOM_LABELING,
        ISOBARIC_TAGGING,
        RESIDUE_LABELING,
        SPECTRAL_COUNTING,
        FEATURES_EXTRACTION;

    }
}

