/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.util;

import fr.profi.util.StringUtils;
import fr.proline.repository.DatabaseConnectorFactory;
import fr.proline.repository.IDataStoreConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDSConnectorFactory
implements IDataStoreConnectorFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDSConnectorFactory.class);
    protected final Object m_managerLock = new Object();
    protected IDatabaseConnector m_udsDbConnector;
    protected final Map<Long, IDatabaseConnector> m_msiDbConnectors = new HashMap<Long, IDatabaseConnector>();
    protected final Map<Long, IDatabaseConnector> m_lcMsDbConnectors = new HashMap<Long, IDatabaseConnector>();
    protected final Map<Long, Map<Object, Object>> m_msiDbPropertiesMaps = new HashMap<Long, Map<Object, Object>>();
    protected final Map<Long, Map<Object, Object>> m_lcMsDbPropertiesMaps = new HashMap<Long, Map<Object, Object>>();

    public abstract void initialize(IDatabaseConnector var1, String var2);

    protected abstract IDatabaseConnector createProjectDatabaseConnector(long var1, ProlineDatabaseType var3, Map<Long, Map<Object, Object>> var4);

    public void initialize(IDatabaseConnector udsDbConnector) {
        this.initialize(udsDbConnector, "Proline");
    }

    public void initialize(Map<Object, Object> udsDbProperties) {
        this.initialize(udsDbProperties, "Proline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Map<Object, Object> udsDbProperties, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("This IDataStoreConnectorFactory ALREADY initialized");
            }
            if (udsDbProperties == null) {
                throw new IllegalArgumentException("UdsDbProperties Map is null");
            }
            this.initialize(DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.UDS, udsDbProperties), applicationName);
        }
    }

    public void initialize(String udsDbPropertiesFileName) {
        this.initialize(udsDbPropertiesFileName, "Proline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String udsDbPropertiesFileName, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("DataStoreConnectorFactory ALREADY initialized");
            }
            if (StringUtils.isEmpty((String)udsDbPropertiesFileName)) {
                throw new IllegalArgumentException("Invalid udsDbPropertiesFileName");
            }
            this.initialize(DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.UDS, (String)udsDbPropertiesFileName), applicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        boolean result;
        Object object = this.m_managerLock;
        synchronized (object) {
            result = this.m_udsDbConnector != null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDatabaseConnector getUdsDbConnector() {
        IDatabaseConnector udsDbConnector;
        Object object = this.m_managerLock;
        synchronized (object) {
            this.checkInitialization();
            udsDbConnector = this.m_udsDbConnector;
        }
        return udsDbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDatabaseConnector getMsiDbConnector(long projectId) {
        IDatabaseConnector msiDbConnector = null;
        Object object = this.m_managerLock;
        synchronized (object) {
            this.checkInitialization();
            Long key = projectId;
            msiDbConnector = this.m_msiDbConnectors.get(key);
            if (msiDbConnector == null && (msiDbConnector = this.createProjectDatabaseConnector(projectId, ProlineDatabaseType.MSI, this.m_msiDbPropertiesMaps)) != null) {
                this.m_msiDbConnectors.put(key, msiDbConnector);
            }
        }
        return msiDbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDatabaseConnector getLcMsDbConnector(long projectId) {
        IDatabaseConnector lcMsDbConnector = null;
        Object object = this.m_managerLock;
        synchronized (object) {
            this.checkInitialization();
            Long key = projectId;
            lcMsDbConnector = this.m_lcMsDbConnectors.get(key);
            if (lcMsDbConnector == null && (lcMsDbConnector = this.createProjectDatabaseConnector(projectId, ProlineDatabaseType.LCMS, this.m_lcMsDbPropertiesMaps)) != null) {
                this.m_lcMsDbConnectors.put(key, lcMsDbConnector);
            }
        }
        return lcMsDbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLcMsDbConnector(long projectId) {
        Object object = this.m_managerLock;
        synchronized (object) {
            try {
                IDatabaseConnector lcMsDbConnector = this.m_lcMsDbConnectors.get(projectId);
                if (lcMsDbConnector != null) {
                    lcMsDbConnector.close();
                    this.m_lcMsDbConnectors.remove(projectId);
                }
            }
            catch (Exception exClose) {
                LOG.error("Error closing LCMS Db Connector", (Throwable)exClose);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeMsiDbConnector(long projectId) {
        Object object = this.m_managerLock;
        synchronized (object) {
            try {
                IDatabaseConnector msiDbConnector = this.m_msiDbConnectors.get(projectId);
                if (msiDbConnector != null) {
                    msiDbConnector.close();
                    this.m_msiDbConnectors.remove(projectId);
                }
            }
            catch (Exception exClose) {
                LOG.error("Error closing MSI Db Connector", (Throwable)exClose);
            }
        }
    }

    public void closeProjectConnectors(long projectId) {
        this.closeLcMsDbConnector(projectId);
        this.closeMsiDbConnector(projectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Object object = this.m_managerLock;
        synchronized (object) {
            for (IDatabaseConnector lcMsDbConnector : this.m_lcMsDbConnectors.values()) {
                try {
                    lcMsDbConnector.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing LCMS Db Connector", (Throwable)exClose);
                }
            }
            this.m_lcMsDbConnectors.clear();
            for (IDatabaseConnector msiDbConnector : this.m_msiDbConnectors.values()) {
                try {
                    msiDbConnector.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing MSI Db Connector", (Throwable)exClose);
                }
            }
            this.m_msiDbConnectors.clear();
            if (this.m_udsDbConnector != null) {
                try {
                    this.m_udsDbConnector.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing UDS Db Connector", (Throwable)exClose);
                }
                this.m_udsDbConnector = null;
            }
        }
    }

    protected void checkInitialization() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("DataStoreConnectorFactory NOT yet initialized");
        }
    }
}

