/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.serverfilesystem;

import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.serverfilesystem.RootInfo;
import fr.proline.studio.dpm.serverfilesystem.ServerFile;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.FileSystemBrowseTask;
import fr.proline.studio.dpm.task.jms.FileSystemRootsTask;
import fr.proline.studio.utils.IconManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class ServerFileSystemView
extends FileSystemView {
    private static ServerFileSystemView m_singleton;
    private static File[] m_roots;
    private static HashMap<String, ArrayList<String>> m_rootsInfo;

    private ServerFileSystemView() {
    }

    public void setRoots(File[] roots) {
        m_roots = roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getRoots() {
        if (m_roots == null || m_roots.length == 0) {
            final Object mutexRootsLoaded = new Object();
            ArrayList<RootInfo> rootInfoArray = new ArrayList<RootInfo>();
            try {
                Object object = mutexRootsLoaded;
                synchronized (object) {
                    AbstractJMSCallback callback = new AbstractJMSCallback(){

                        @Override
                        public boolean mustBeCalledInAWT() {
                            return false;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run(boolean success) {
                            Object object = mutexRootsLoaded;
                            synchronized (object) {
                                mutexRootsLoaded.notifyAll();
                            }
                        }
                    };
                    FileSystemRootsTask task = new FileSystemRootsTask(callback, rootInfoArray);
                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask(task);
                    mutexRootsLoaded.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            m_roots = new File[rootInfoArray.size()];
            m_rootsInfo = new HashMap();
            for (int i = 0; i < rootInfoArray.size(); ++i) {
                String label = rootInfoArray.get(i).getLabel();
                String type = rootInfoArray.get(i).getType();
                ServerFileSystemView.m_roots[i] = new ServerFile(label, label, true, 0L, 0L);
                ArrayList<String> labels = m_rootsInfo.get(type);
                if (labels == null) {
                    labels = new ArrayList();
                    m_rootsInfo.put(type, labels);
                }
                labels.add(label);
            }
        }
        return m_roots;
    }

    public ArrayList<String> getLabels(String type) {
        this.getRoots();
        return m_rootsInfo.get(type);
    }

    public static ServerFileSystemView getServerFileSystemView() {
        if (m_singleton == null) {
            m_singleton = new ServerFileSystemView();
        }
        return m_singleton;
    }

    @Override
    public Icon getSystemIcon(File f) {
        if (f == null) {
            return null;
        }
        return f.isDirectory() ? IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER) : IconManager.getIcon((IconManager.IconType)IconManager.IconType.FILE);
    }

    @Override
    public File getParentDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        return dir.getParentFile();
    }

    @Override
    public String getSystemDisplayName(File f) {
        return f.getName();
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        throw new IOException("It is not allowed to create a directory.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        final Object mutexFileLoaded = new Object();
        ArrayList<ServerFile> files = new ArrayList<ServerFile>();
        try {
            Object object = mutexFileLoaded;
            synchronized (object) {
                AbstractJMSCallback callback = new AbstractJMSCallback(){

                    @Override
                    public boolean mustBeCalledInAWT() {
                        return false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(boolean success) {
                        Object object = mutexFileLoaded;
                        synchronized (object) {
                            mutexFileLoaded.notifyAll();
                        }
                    }
                };
                FileSystemBrowseTask task = new FileSystemBrowseTask(callback, dir.getPath(), files);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask(task);
                mutexFileLoaded.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        File[] fileArray = new File[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            fileArray[i] = (File)files.get(i);
        }
        return fileArray;
    }

    static {
        m_roots = null;
        m_rootsInfo = null;
    }
}

