/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.profi.util.security.EncryptionManager;
import fr.profi.util.security.SecurityUtils;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class AuthenticateUserTask
extends AbstractJMSTask {
    private final String m_userName;
    private final String m_password;
    private final String[] m_databasePassword;
    private static final int TASK_TIMEOUT_MS = 20000;

    public AuthenticateUserTask(AbstractJMSCallback callback, String m_userName, String m_password, String[] m_databasePassword) {
        super(callback, true, new TaskInfo("Check User " + m_userName, false, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_userName = m_userName;
        this.m_password = m_password;
        this.m_databasePassword = m_databasePassword;
        super.setResponseTimeout(20000);
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("authenticate", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/admin/UserAccount");
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.debug("Message AuthenticateUserTask [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login", this.m_userName);
        params.put("password_hash", SecurityUtils.sha256Hex((String)this.m_password));
        params.put("return_db_password", Boolean.TRUE);
        EncryptionManager encryptionMgr = EncryptionManager.getEncryptionManager();
        params.put("public_key", encryptionMgr.getPublicKeyAsString());
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null) {
            m_loggerProline.trace("Internal Error : No DB password received");
            throw new Exception("Internal Error : No DB password received ");
        }
        String dbPwd = result.toString();
        this.m_databasePassword[0] = EncryptionManager.getEncryptionManager().decrypt(dbPwd);
        m_loggerProline.trace("Result :\n" + this.m_databasePassword[0]);
    }
}

