/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class CancelTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/misc/CancelService";
    private String m_messageId;

    public CancelTask(String msgID) {
        super(null, new TaskInfo("Send Cancel request to message " + msgID, false, "Services JMS", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_messageId = msgID;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("cancel", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setJMSCorrelationID(this.m_messageId);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("CancelTask Message [{}] sent ", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", this.m_messageId);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null) {
            m_loggerProline.debug("NULL result");
            throw new Exception("NULL result ");
        }
        m_loggerProline.debug("Result :\n" + result);
    }
}

