/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class GenerateMSDiagReportTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msi/GenerateMSDiagReport";
    private final Long m_projectId;
    private final Long m_resultSetId;
    private final Map<String, Object> m_msdiagParameters;
    public ArrayList<Object> m_resultMessages;

    public GenerateMSDiagReportTask(AbstractJMSCallback callback, Long projectId, Long resultSetId, Map<String, Object> msdiagParameters, ArrayList<Object> resultMessages) {
        super(callback, new TaskInfo((String)(resultSetId != null ? "Generate Quality Control Report for resultSet id " + resultSetId : "Generate Quality Control Report"), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_projectId = projectId;
        this.m_resultSetId = resultSetId;
        this.m_resultMessages = resultMessages;
        this.m_msdiagParameters = msdiagParameters;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("result_set_id", this.m_resultSetId);
        params.put("msdiag_settings", this.m_msdiagParameters);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !String.class.isInstance(result)) {
            m_loggerProline.debug("Invalid result");
            throw new Exception("Invalid result " + result);
        }
        m_loggerProline.debug("Result :\n" + result);
        this.m_resultMessages.add((String)result);
    }
}

