/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class GenerateSpectrumMatchTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msi/GenerateSpectrumMatches";
    private final Long m_projectId;
    private final Long m_resultSetId;
    private final Long m_resultSummaryId;
    private final Long m_peptideMatchId;
    private final Boolean m_forceGenerate;
    private final Long m_fragmentRuleSetId;

    public GenerateSpectrumMatchTask(AbstractJMSCallback callback, String datasetName, Long projectId, Long resultSetId, Long resultSummaryId, Long peptideMatchId, long fragmRuleSetId, Boolean forceGenerate) {
        super(callback, new TaskInfo((String)(datasetName != null ? "Generate Spectrum Matches for " + datasetName : "Generate Spectrum Match(es)"), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_projectId = projectId;
        this.m_resultSetId = resultSetId;
        this.m_resultSummaryId = resultSummaryId;
        this.m_peptideMatchId = peptideMatchId;
        this.m_fragmentRuleSetId = fragmRuleSetId;
        this.m_forceGenerate = forceGenerate;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("result_set_id", this.m_resultSetId);
        if (this.m_peptideMatchId != null) {
            ArrayList<Long> peptideMatches = new ArrayList<Long>();
            peptideMatches.add(this.m_peptideMatchId);
            params.put("peptide_match_ids", peptideMatches);
        } else if (this.m_resultSummaryId != null) {
            params.put("result_summary_id", this.m_resultSummaryId);
        }
        if (this.m_fragmentRuleSetId != null && this.m_fragmentRuleSetId > 0L) {
            params.put("fragmentation_rule_set_id", this.m_fragmentRuleSetId);
        }
        params.put("force_insert", this.m_forceGenerate);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !Boolean.class.isInstance(result)) {
            m_loggerProline.debug("Invalid result");
            throw new Exception("Invalid result " + result);
        }
        m_loggerProline.debug("Result :\n" + result);
    }
}

