/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ImportMaxQuantTask
extends AbstractJMSTask {
    public static int RESULT_SET_IDS_LIST = 0;
    public static int WARNING_MESSAGES = 1;
    public static int RESULT_SUMMARY_IDS_MAP = 2;
    public static int QUANTITATION_DATASET_ID = 3;
    public static int RESULTS_SIZE = 4;
    private final String m_filePath;
    private final long m_instrumentId;
    private long m_peaklistSoftwareId;
    private final long m_projectId;
    private final String m_accessionRegexp;
    private final Boolean m_importQuantResult;
    private Object[] m_taskResult = null;

    public ImportMaxQuantTask(AbstractJMSCallback callback, String filePath, long instrumentId, long peaklistSoftwareId, long projectId, Object[] resultsFromTask) {
        super(callback, new TaskInfo("Import MaxQuant file " + filePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_filePath = filePath;
        this.m_instrumentId = instrumentId;
        this.m_peaklistSoftwareId = peaklistSoftwareId;
        this.m_projectId = projectId;
        this.m_importQuantResult = false;
        this.m_accessionRegexp = "*";
        this.m_taskResult = resultsFromTask;
    }

    public ImportMaxQuantTask(AbstractJMSCallback callback, String filePath, long instrumentId, String accessionRegexp, Boolean importQuantitation, long projectId, Object[] resultsFromTask) {
        super(callback, new TaskInfo("Import MaxQuant file " + filePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_filePath = filePath;
        this.m_instrumentId = instrumentId;
        this.m_accessionRegexp = accessionRegexp;
        this.m_importQuantResult = importQuantitation;
        this.m_projectId = projectId;
        this.m_taskResult = resultsFromTask;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/ImportMaxQuantResults");
        message.setStringProperty("Proline_ServiceVersion", "2.0");
        this.addSupplementaryInfo((Message)message, this.m_projectId);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Long datasetId;
        Object result = jsonResponse.getResult();
        if (result == null || !Map.class.isInstance(result)) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned values");
            throw new Exception("Invalid result " + result);
        }
        Map returnedValues = (Map)result;
        List returnedRsIds = (List)returnedValues.get("result_set_Ids");
        if (returnedRsIds == null || returnedRsIds.isEmpty()) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned ResultSet Ids");
            throw new Exception("Import result error : No returned ResultSet Ids");
        }
        Map resultSummaries = (Map)returnedValues.get("result_summary_ids_by_result_set_id");
        if (resultSummaries != null && !resultSummaries.isEmpty()) {
            this.m_taskResult[ImportMaxQuantTask.RESULT_SUMMARY_IDS_MAP] = resultSummaries;
        }
        if ((datasetId = (Long)returnedValues.get("quantitation_dataset_id")) != null) {
            this.m_taskResult[ImportMaxQuantTask.QUANTITATION_DATASET_ID] = datasetId;
        }
        this.m_taskResult[ImportMaxQuantTask.RESULT_SET_IDS_LIST] = returnedRsIds;
        this.m_taskResult[ImportMaxQuantTask.WARNING_MESSAGES] = (String)returnedValues.get("warning_msg");
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("result_files_dir", this.m_filePath);
        params.put("instrument_config_id", this.m_instrumentId);
        if (this.m_accessionRegexp != null && !this.m_accessionRegexp.isEmpty()) {
            params.put("accession_regexp", this.m_accessionRegexp);
        }
        params.put("import_quant_result", this.m_importQuantResult);
        return params;
    }
}

