/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class RetrieveBioSeqTask
extends AbstractJMSTask {
    private static boolean isRunning;
    private final List<Long> m_resultSummariesIds;
    private final long m_projectId;
    private final boolean m_forceUpdate;

    public RetrieveBioSeqTask(AbstractJMSCallback callback, List<Long> rsmIds, long projectId, boolean forceUpdate) {
        super(callback, new TaskInfo("Retrieve Protein's Sequences", false, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_resultSummariesIds = rsmIds;
        this.m_projectId = projectId;
        this.m_forceUpdate = forceUpdate;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/seq/RetrieveBioSeqForRSMs");
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        isRunning = true;
        this.m_producer.send((Message)message);
        String m_lastMsgId = message.getJMSMessageID();
        m_loggerProline.info("Message [{}] sent", (Object)m_lastMsgId);
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("result_summaries_ids", this.m_resultSummariesIds);
        params.put("force_update", this.m_forceUpdate);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        isRunning = false;
        super.taskDone(jmsMessage);
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned values");
            throw new Exception("Invalid result " + result);
        }
    }

    public static boolean isRetrieveRunning() {
        return isRunning;
    }
}

