/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class RunQuantitationTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msq/Quantify";
    private final String m_version = "4.0";
    private final Long[] m_xicQuantiResult;
    private final String m_quantiDSName;
    private final Long m_pId;
    private final Long m_quantMethodId;
    private final Map<String, Object> m_quantParams;
    private final Map<String, Object> m_expDesignParams;

    public RunQuantitationTask(AbstractJMSCallback callback, Long projectId, String quantDSName, Map<String, Object> quantParams, Map<String, Object> expDesignParams, Long quantMethodId, Long[] retValue) {
        super(callback, new TaskInfo("Run Quantitation for " + quantDSName, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_xicQuantiResult = retValue;
        this.m_expDesignParams = expDesignParams;
        this.m_quantiDSName = quantDSName;
        this.m_pId = projectId;
        this.m_quantParams = quantParams;
        this.m_quantMethodId = quantMethodId;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        message.setStringProperty("Proline_ServiceVersion", "4.0");
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", this.m_quantiDSName);
        params.put("description", this.m_quantiDSName);
        params.put("project_id", this.m_pId);
        params.put("method_id", this.m_quantMethodId);
        params.put("experimental_design", this.m_expDesignParams);
        params.put("quantitation_config", this.m_quantParams);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !Long.class.isInstance(result)) {
            m_loggerProline.debug("Invalid result: No returned Quantitation dataset Id");
            throw new Exception("Invalid result " + result);
        }
        m_loggerProline.debug("Result :\n" + result);
        this.m_xicQuantiResult[0] = (Long)result;
    }
}

