/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.util;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import fr.proline.studio.dpm.data.JMSNotificationMessage;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.util.JMSMessageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNotificationListener
implements MessageListener {
    public static final String NOTIFICATION_SERVICE_NAME_KEY = "service_name";
    public static final String NOTIFICATION_SERVICE_VERSION_KEY = "service_version";
    public static final String NOTIFICATION_SERVICE_SOURCE_KEY = "service_source";
    public static final String NOTIFICATION_SERVICE_DESCR_KEY = "service_description";
    public static final String NOTIFICATION_SERVICE_MORE_INFO_KEY = "complementary_info";
    public static final String NOTIFICATION_TIMESTAMP_KEY = "event_timestamp";
    public static final String NOTIFICATION_JMS_ID_KEY = "request_jms_message_id";
    public static final String NOTIFICATION_JSON_REQ_ID_KEY = "json_rpc_request_id";
    public static final String NOTIFICATION_SERVICE_STATUS_KEY = "event_type";
    protected static final Logger m_loggerProline = LoggerFactory.getLogger((String)"ProlineStudio.DPM.Task");
    private List<AbstractJMSCallback> m_callbacks = new ArrayList<AbstractJMSCallback>();
    private List<JMSNotificationMessage[]> m_replyVals = new ArrayList<JMSNotificationMessage[]>();

    public void addServiceNotifierCallback(AbstractJMSCallback callback, JMSNotificationMessage[] replyVal) {
        if (callback == null || replyVal == null || replyVal.length != 1) {
            throw new RuntimeException("Must specify callback and reply value pair to register for PurgeConsumer ");
        }
        this.m_callbacks.add(callback);
        this.m_replyVals.add(replyVal);
    }

    public void removeCallback(AbstractJMSCallback callback) {
        int index = this.m_callbacks.indexOf(callback);
        if (index < 0) {
            return;
        }
        this.m_callbacks.remove(index);
        this.m_replyVals.remove(index);
    }

    public void onMessage(Message jmsMessage) {
        m_loggerProline.debug(" JMS Notification Listener Receiving message  : " + JMSMessageUtil.formatMessage(jmsMessage));
        if (jmsMessage instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)jmsMessage;
            try {
                String jsonString = textMessage.getText();
                if (!jsonString.startsWith("{\"method\":")) {
                    m_loggerProline.error(" *** None valide JSONRPC2Notification : Do not start with method entry.");
                    return;
                }
                JSONRPC2Notification jsonNotif = JSONRPC2Notification.parse((String)jsonString);
                Map params = jsonNotif.getNamedParams();
                JMSNotificationMessage resultMsg = new JMSNotificationMessage(params.getOrDefault(NOTIFICATION_SERVICE_NAME_KEY, "Undefined").toString(), params.getOrDefault(NOTIFICATION_SERVICE_VERSION_KEY, "default").toString(), params.getOrDefault(NOTIFICATION_SERVICE_SOURCE_KEY, "Unknown").toString(), params.getOrDefault(NOTIFICATION_SERVICE_DESCR_KEY, "").toString(), params.getOrDefault(NOTIFICATION_SERVICE_MORE_INFO_KEY, "Unknown").toString(), params.getOrDefault(NOTIFICATION_TIMESTAMP_KEY, 0L), params.getOrDefault(NOTIFICATION_JMS_ID_KEY, "Unknown").toString(), params.getOrDefault(NOTIFICATION_JSON_REQ_ID_KEY, "Unknown").toString(), JMSNotificationMessage.MessageStatus.parseString(params.get(NOTIFICATION_SERVICE_STATUS_KEY).toString()));
                for (int index = 0; index < this.m_callbacks.size(); ++index) {
                    final AbstractJMSCallback callback = this.m_callbacks.get(index);
                    JMSNotificationMessage[] replyVal = this.m_replyVals.get(index);
                    replyVal[0] = resultMsg;
                    if (callback.mustBeCalledInAWT()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                callback.run(true);
                            }
                        });
                        continue;
                    }
                    callback.run(true);
                }
            }
            catch (JSONRPC2ParseException | JMSException ex) {
                m_loggerProline.error(" JMS Notification Error handling JMS Message", ex);
            }
        } else {
            m_loggerProline.warn("**** Invalid JMS Message type : " + jmsMessage);
        }
    }
}

