/*
 * Decompiled with CFR 0.152.
 */
package com.thierry.filtering.report;

import com.thierry.filtering.ColorUtil;
import com.thierry.filtering.report.ReportBuilder;
import java.awt.Color;

public class HTMLReportBuilder
implements ReportBuilder {
    private StringBuilder builder = new StringBuilder(524288);

    @Override
    public void addCell(Color bgColor, Color fgColor, String content) {
        String bgColorStr = "#" + ColorUtil.getHexName(bgColor);
        String fgColorStr = "#" + ColorUtil.getHexName(fgColor);
        this.builder.append("<td bgColor=");
        this.builder.append(bgColorStr);
        this.builder.append(">");
        this.builder.append("<font color=");
        this.builder.append(fgColorStr);
        this.builder.append(">");
        this.builder.append(content);
        this.builder.append("</font></td>");
    }

    @Override
    public void addColumnHeader(String header) {
        this.builder.append("<th>");
        this.builder.append(header);
        this.builder.append("</th>");
    }

    @Override
    public void endTable() {
        this.builder.append("</table>");
    }

    @Override
    public void startTableHeader() {
        this.builder.append("<tr>");
    }

    @Override
    public void close() {
        this.builder.append("</body></html>");
    }

    @Override
    public void open() {
        this.builder.append("<html><body>");
    }

    @Override
    public void endLine() {
        this.builder.append("</tr>");
    }

    @Override
    public void endTableHeader() {
        this.builder.append("</tr>");
    }

    @Override
    public void startLine() {
        this.builder.append("<tr>");
    }

    @Override
    public void startTable() {
        this.builder.append("<table>");
    }

    public String toString() {
        return this.builder.toString();
    }
}

