/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MemoryPanel
extends JPanel
implements MouseListener {
    private static int NB_VALUES = 30;
    private static final Color BLUE = new Color(116, 208, 241);
    private static final Color MAX_COLOR = new Color(160, 7, 26);
    private static final Dimension m_dimension = new Dimension(NB_VALUES * 3, 20);
    private static final StringBuilder m_sb = new StringBuilder();
    private ActionListener m_actionListener = null;
    private Font m_font;
    private long m_maxMemory;
    private long m_totalMemory;
    private long m_usedMemory;
    private long[] m_values = new long[NB_VALUES];
    private int valueCurIndex = 0;
    private boolean m_firstPaint = true;

    public MemoryPanel() {
        this.setMinimumSize(m_dimension);
        this.setPreferredSize(m_dimension);
        this.addMouseListener(this);
    }

    public void setActionListener(ActionListener actionListener) {
        this.m_actionListener = actionListener;
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void startAnimation() {
        Timer t = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.peekMemoryValue();
                MemoryPanel.this.repaint();
            }
        });
        t.start();
    }

    private void peekMemoryValue() {
        this.m_maxMemory = Runtime.getRuntime().maxMemory();
        this.m_totalMemory = Runtime.getRuntime().totalMemory();
        this.m_values[this.valueCurIndex] = this.m_usedMemory = this.m_totalMemory - Runtime.getRuntime().freeMemory();
        ++this.valueCurIndex;
        if (this.valueCurIndex >= NB_VALUES) {
            this.valueCurIndex = 0;
        }
    }

    @Override
    public void paint(Graphics g) {
        int height;
        int i;
        if (this.m_firstPaint) {
            this.startAnimation();
            this.m_firstPaint = false;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int maxMemoryHeight = Math.round(this.getHeight() * 1);
        g.setColor(BLUE);
        int index = 0;
        for (i = this.valueCurIndex; i < NB_VALUES; ++i) {
            height = (int)Math.round((double)maxMemoryHeight * (double)this.m_values[i] / (double)this.m_totalMemory);
            g.fillRect(index * 3, this.getHeight() - height, 3, height);
            ++index;
        }
        for (i = 0; i < this.valueCurIndex; ++i) {
            height = (int)Math.round((double)maxMemoryHeight * (double)this.m_values[i] / (double)this.m_totalMemory);
            g.fillRect(index * 3, this.getHeight() - height, 3, height);
            ++index;
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int memAllocated = (int)this.m_totalMemory / 1024000;
        int memUsed = (int)this.m_usedMemory / 1024000;
        if (this.m_font == null) {
            this.m_font = g.getFont().deriveFont(1);
        }
        g.setFont(this.m_font);
        m_sb.setLength(0);
        m_sb.append(memUsed).append('/').append(memAllocated).append("Mo");
        String memString = m_sb.toString();
        int stringWidth = g.getFontMetrics().stringWidth(memString);
        g.drawString(memString, (this.getWidth() - stringWidth) / 2, this.getHeight() / 2 + 5);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.m_actionListener != null) {
            this.m_actionListener.actionPerformed(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

