/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.ViewChangeListener;
import fr.proline.studio.table.DecoratedTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public abstract class DecoratedMarkerTable
extends DecoratedTable
implements MarkerComponentInterface,
ChangeListener {
    private int m_firstVisibleRow = -1;
    private int m_lastVisibleRow = -1;
    private JViewport m_viewport = null;
    ArrayList<ViewChangeListener> viewChangeListeners = null;

    public DecoratedMarkerTable() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DecoratedMarkerTable.this.dispatchViewChange();
            }
        });
    }

    public void setViewport(JViewport viewport) {
        this.m_viewport = viewport;
        viewport.addChangeListener(this);
    }

    @Override
    public int getFirstVisibleRow() {
        return this.m_firstVisibleRow;
    }

    @Override
    public int getLastVisibleRow() {
        return this.m_lastVisibleRow;
    }

    @Override
    public void scrollToVisible(final int row) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DecoratedMarkerTable.this.scrollRectToVisible(new Rectangle(DecoratedMarkerTable.this.getCellRect(row, 0, true)));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JViewport viewport = (JViewport)DecoratedMarkerTable.this.getParent();
                        Rectangle rect = DecoratedMarkerTable.this.getCellRect(row, 0, true);
                        Point pt = viewport.getViewPosition();
                        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
                        if (!new Rectangle(viewport.getExtentSize()).contains(rect)) {
                            DecoratedMarkerTable.this.scrollToVisible(row);
                        }
                    }
                });
            }
        });
    }

    @Override
    public int getRowYStart(int row) {
        Rectangle viewRect = this.m_viewport.getViewRect();
        Rectangle r = this.getCellRect(row, 0, false);
        int headerHeight = 0;
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            headerHeight = header.getHeight();
        }
        return headerHeight + r.y - viewRect.y;
    }

    @Override
    public int getRowYStop(int row) {
        Rectangle viewRect = this.m_viewport.getViewRect();
        Rectangle r = this.getCellRect(row, 0, false);
        int headerHeight = 0;
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            headerHeight = header.getHeight();
        }
        return headerHeight + r.y + r.height - viewRect.y;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.calculateVisibleRange();
    }

    @Override
    public void calculateVisibleRange() {
        Rectangle viewRect = this.m_viewport.getViewRect();
        this.m_firstVisibleRow = this.rowAtPoint(new Point(0, viewRect.y));
        if (this.m_firstVisibleRow == -1) {
            this.m_lastVisibleRow = -1;
            return;
        }
        int modelRowCount = this.getModel().getRowCount() - 1;
        this.m_lastVisibleRow = this.rowAtPoint(new Point(0, viewRect.y + viewRect.height - 1));
        if (this.m_lastVisibleRow == -1 || this.m_lastVisibleRow > modelRowCount) {
            this.m_lastVisibleRow = modelRowCount;
        }
    }

    @Override
    public int getRowInNonFilteredModel(int y) {
        int row;
        Rectangle viewRect = this.m_viewport.getViewRect();
        int headerHeight = 0;
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            headerHeight = header.getHeight();
        }
        if ((row = this.rowAtPoint(new Point(0, y + viewRect.y - headerHeight))) == -1) {
            return -1;
        }
        int rowInModel = this.convertRowIndexToModel(row);
        TableModel model = this.getModel();
        if (model instanceof CompoundTableModel) {
            rowInModel = ((CompoundTableModel)model).convertCompoundRowToBaseModelRow(rowInModel);
        }
        return rowInModel;
    }

    @Override
    public int convertRowIndexToNonFilteredModel(int rowIndex) {
        if (rowIndex == -1) {
            return -1;
        }
        rowIndex = super.convertRowIndexToModel(rowIndex);
        TableModel model = this.getModel();
        if (model instanceof CompoundTableModel) {
            rowIndex = ((CompoundTableModel)model).convertCompoundRowToBaseModelRow(rowIndex);
        }
        return rowIndex;
    }

    @Override
    public int convertRowIndexNonFilteredModelToView(int rowIndex) {
        if (rowIndex == -1 || rowIndex >= this.getRowCount()) {
            return -1;
        }
        TableModel model = this.getModel();
        if (model instanceof CompoundTableModel) {
            rowIndex = ((CompoundTableModel)model).convertBaseModelRowToCompoundRow(rowIndex);
        }
        if (rowIndex == -1) {
            return -1;
        }
        return super.convertRowIndexToView(rowIndex);
    }

    @Override
    public void addViewChangeListerner(ViewChangeListener listener) {
        if (this.viewChangeListeners == null) {
            this.viewChangeListeners = new ArrayList();
        }
        this.viewChangeListeners.add(listener);
    }

    @Override
    public void removeViewChangeListener(ViewChangeListener listener) {
        if (this.viewChangeListeners == null) {
            return;
        }
        this.viewChangeListeners.remove(listener);
    }

    @Override
    public void dispatchViewChange() {
        if (this.viewChangeListeners == null) {
            return;
        }
        int nbListener = this.viewChangeListeners.size();
        for (int i = 0; i < nbListener; ++i) {
            this.viewChangeListeners.get(i).viewChanged();
        }
    }
}

