/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.tabs;

import fr.proline.studio.tabs.ILayoutPanel;
import fr.proline.studio.tabs.IWrappedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class PanelAsTab
extends JPanel
implements ILayoutPanel {
    private List<IWrappedPanel> m_panels;
    private JTabbedPane m_tabbedPane;

    public PanelAsTab() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.m_panels = new ArrayList<IWrappedPanel>();
        this.m_tabbedPane = new JTabbedPane();
        this.add(this.m_tabbedPane);
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public IWrappedPanel getSelectedPanel() {
        int id = this.m_tabbedPane.getSelectedIndex();
        if (id != -1 && id < this.m_panels.size()) {
            return this.m_panels.get(id);
        }
        return null;
    }

    @Override
    public void setPanels(List<IWrappedPanel> panels, Integer nbCols) {
        this.m_panels = panels;
        this.displayPanels();
    }

    @Override
    public void setSelectedPanel(IWrappedPanel panel) {
        int id = this.m_panels.indexOf(panel);
        if (id != -1) {
            this.m_tabbedPane.setSelectedIndex(id);
        }
    }

    private void displayPanels() {
        this.removeAll();
        this.m_tabbedPane = new JTabbedPane();
        int id = 0;
        for (IWrappedPanel panel : this.m_panels) {
            this.m_tabbedPane.add(panel.getTitle(), panel.getComponent());
            if (panel.getTabHeaderComponent() == null) continue;
            this.setTabHeaderComponentAt(id++, panel.getTabHeaderComponent());
        }
        this.add(this.m_tabbedPane);
    }

    @Override
    public void setTabHeaderComponentAt(int index, Component c) {
        this.m_tabbedPane.setTabComponentAt(index, c);
    }

    @Override
    public int indexOfTabHeaderComponent(Component c) {
        return this.m_tabbedPane.indexOfTabComponent(c);
    }

    @Override
    public void addPanel(IWrappedPanel panel) {
        this.m_panels.add(panel);
        this.m_tabbedPane.addTab(panel.getTitle(), panel.getComponent());
        if (panel.getTabHeaderComponent() != null) {
            this.setTabHeaderComponentAt(this.m_panels.size() - 1, panel.getTabHeaderComponent());
        }
    }

    @Override
    public void removePanel(int id) {
        this.m_tabbedPane.remove(id);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.m_tabbedPane.addChangeListener(l);
    }
}

