/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._IIRFilter;

public class Bessel
implements _IIRFilter {
    private double samplingFreq;

    public Bessel(double Fs) {
        this.samplingFreq = Fs;
    }

    @Override
    public double[] lowPassFilter(double[] signal, int order, double cutoffFreq) {
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Bessel lp = new uk.me.berndporr.iirj.Bessel();
        lp.lowPass(order, this.samplingFreq, cutoffFreq);
        for (int i = 0; i < output.length; ++i) {
            output[i] = lp.filter(signal[i]);
        }
        return output;
    }

    @Override
    public double[] highPassFilter(double[] signal, int order, double cutoffFreq) {
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Bessel hp = new uk.me.berndporr.iirj.Bessel();
        hp.highPass(order, this.samplingFreq, cutoffFreq);
        for (int i = 0; i < output.length; ++i) {
            output[i] = hp.filter(signal[i]);
        }
        return output;
    }

    @Override
    public double[] bandPassFilter(double[] signal, int order, double lowCutoff, double highCutoff) throws IllegalArgumentException {
        if (lowCutoff >= highCutoff) {
            throw new IllegalArgumentException("Lower Cutoff Frequency cannot be more than the Higher Cutoff Frequency");
        }
        double centreFreq = (highCutoff + lowCutoff) / 2.0;
        double width = Math.abs(highCutoff - lowCutoff);
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Bessel bp = new uk.me.berndporr.iirj.Bessel();
        bp.bandPass(order, this.samplingFreq, centreFreq, width);
        for (int i = 0; i < output.length; ++i) {
            output[i] = bp.filter(signal[i]);
        }
        return output;
    }

    @Override
    public double[] bandStopFilter(double[] signal, int order, double lowCutoff, double highCutoff) throws IllegalArgumentException {
        if (lowCutoff >= highCutoff) {
            throw new IllegalArgumentException("Lower Cutoff Frequency cannot be more than the Higher Cutoff Frequency");
        }
        double centreFreq = (highCutoff + lowCutoff) / 2.0;
        double width = Math.abs(highCutoff - lowCutoff);
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Bessel bs = new uk.me.berndporr.iirj.Bessel();
        bs.bandStop(order, this.samplingFreq, centreFreq, width);
        for (int i = 0; i < output.length; ++i) {
            output[i] = bs.filter(signal[i]);
        }
        return output;
    }
}

