/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._KernelFilter;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;

public class Median
implements _KernelFilter {
    private int windowSize;

    public Median() throws IllegalArgumentException {
        this.windowSize = 3;
    }

    public Median(int wsize) throws IllegalArgumentException {
        this.windowSize = wsize;
    }

    @Override
    public double[] filter(double[] signal) {
        if (this.windowSize >= signal.length) {
            throw new IllegalArgumentException("Window size cannot be greater than or equal to signal length");
        }
        int paddingSize = (this.windowSize - 1) / 2;
        double[] cons = new double[paddingSize];
        double[] newSignal = new double[signal.length];
        Arrays.fill(cons, 0.0);
        double[] paddedSignal = new double[]{};
        paddedSignal = UtilMethods.concatenateArray(paddedSignal, cons);
        paddedSignal = UtilMethods.concatenateArray(paddedSignal, signal);
        paddedSignal = UtilMethods.concatenateArray(paddedSignal, cons);
        for (int i = 0; i < signal.length; ++i) {
            newSignal[i] = StatUtils.percentile((double[])paddedSignal, (int)i, (int)this.windowSize, (double)50.0);
        }
        return newSignal;
    }
}

