/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter.adaptive;

import com.github.psambit9791.jdsp.filter.adaptive._Adaptive;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.Arrays;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.util.MathArrays;

public class AP
implements _Adaptive {
    private double[][] x_mem;
    private double[] d_mem;
    private double mu;
    private double eps;
    private double[][] ide;
    private double[][] ide_eps;
    private double[] weights;
    private double[] error;
    private double[] output;

    public AP(int order, double learningRate, double eps, double[] weights) {
        if (weights == null || weights.length == 0) {
            throw new IllegalArgumentException("Weights must be non-null and with a length greater than 0");
        }
        this.x_mem = new double[weights.length][order];
        this.d_mem = new double[order];
        this.mu = learningRate;
        this.eps = eps;
        this.weights = weights;
        this.ide = MatrixUtils.createRealIdentityMatrix((int)order).getData();
        this.ide_eps = MatrixUtils.createRealIdentityMatrix((int)order).getData();
        for (int i = 0; i < this.ide_eps.length; ++i) {
            this.ide_eps[i] = MathArrays.scale((double)this.eps, (double[])this.ide_eps[i]);
        }
    }

    public AP(double learningRate, double[] weights) {
        this(5, learningRate, 0.001, weights);
    }

    public AP(int length, int order, double learningRate, double eps, _Adaptive.WeightsFillMethod fillMethod) {
        int i;
        this.mu = learningRate;
        this.eps = eps;
        this.weights = new double[length];
        this.ide = MatrixUtils.createRealIdentityMatrix((int)order).getData();
        this.ide_eps = MatrixUtils.createRealIdentityMatrix((int)order).getData();
        for (i = 0; i < this.ide_eps.length; ++i) {
            this.ide_eps[i] = MathArrays.scale((double)this.eps, (double[])this.ide_eps[i]);
        }
        switch (fillMethod) {
            case RANDOM: {
                for (i = 0; i < length; ++i) {
                    this.weights[i] = Math.random();
                }
                break;
            }
            case ZEROS: {
                Arrays.fill(this.weights, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown weights fill method");
            }
        }
        this.x_mem = new double[length][order];
        this.d_mem = new double[order];
    }

    public AP(int length, double learningRate, _Adaptive.WeightsFillMethod fillMethod) {
        this(length, 5, learningRate, 0.001, fillMethod);
    }

    private double[][] update_memory(double[] data, double[][] mem) {
        mem = UtilMethods.transpose(mem);
        for (int i = mem.length - 2; i >= 0; --i) {
            mem[i + 1] = mem[i];
        }
        mem[0] = data;
        return UtilMethods.transpose(mem);
    }

    private double[] update_memory(double data, double[] mem) {
        for (int i = mem.length - 2; i >= 0; --i) {
            mem[i + 1] = mem[i];
        }
        mem[0] = data;
        return mem;
    }

    private double[] adaptWeights(double desired, double[] x) {
        RealVector soln;
        int i;
        this.x_mem = this.update_memory(x, this.x_mem);
        this.d_mem = this.update_memory(desired, this.d_mem);
        double[][] x_mem_T = UtilMethods.transpose(this.x_mem);
        double[] y_mem = UtilMethods.flattenMatrix(UtilMethods.matrixMultiply(x_mem_T, UtilMethods.transpose(new double[][]{this.weights})));
        double[] e_mem = MathArrays.ebeSubtract((double[])this.d_mem, (double[])y_mem);
        double[][] dw_p1 = UtilMethods.matrixMultiply(x_mem_T, this.x_mem);
        dw_p1 = UtilMethods.matrixAddition(dw_p1, this.ide_eps);
        double[][] dw_p2 = new double[dw_p1.length][dw_p1[0].length];
        try {
            DecompositionSolver solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])dw_p1)).getSolver();
            for (i = 0; i < dw_p2.length; ++i) {
                soln = solver.solve((RealVector)new ArrayRealVector(this.ide[i], false));
                dw_p2[i] = soln.toArray();
            }
        }
        catch (SingularMatrixException e) {
            DecompositionSolver solver = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])dw_p1)).getSolver();
            for (int i2 = 0; i2 < dw_p2.length; ++i2) {
                soln = solver.solve((RealVector)new ArrayRealVector(this.ide[i2], false));
                dw_p2[i2] = soln.toArray();
            }
        }
        double[] dw = UtilMethods.flattenMatrix(UtilMethods.matrixMultiply(this.x_mem, UtilMethods.matrixMultiply(dw_p2, UtilMethods.transpose(new double[][]{e_mem}))));
        for (i = 0; i < this.weights.length; ++i) {
            this.weights[i] = this.weights[i] + this.mu * dw[i];
        }
        return new double[]{y_mem[0], e_mem[0]};
    }

    @Override
    public void filter(double[] desired, double[] x) {
        if (desired == null || desired.length == 0) {
            throw new IllegalArgumentException("Desired signal cannot be null, or with size 0");
        }
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException("Input signal cannot be null, or with size 0");
        }
        if (x.length != desired.length) {
            throw new IllegalArgumentException("The length of the desired signal and input signal must be equal.");
        }
        if (this.weights.length > x.length) {
            throw new IllegalArgumentException("Filter length must not be greater than the signal length");
        }
        this.error = new double[x.length];
        this.output = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            double[] x_subset = new double[this.weights.length];
            Arrays.fill(x_subset, 0.0);
            for (int j = 0; j < x_subset.length; ++j) {
                if (i - j <= 0) continue;
                x_subset[x_subset.length - 1 - j] = x[i - j];
            }
            double[] out = this.adaptWeights(desired[i], x_subset);
            this.output[i] = out[0];
            this.error[i] = out[1];
        }
    }

    public double[] getWeights() {
        this.checkOutput();
        return this.weights;
    }

    public double[] getError() {
        this.checkOutput();
        return this.error;
    }

    public double[] getOutput() {
        this.checkOutput();
        return this.output;
    }

    private void checkOutput() {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute filter() function before returning result");
        }
    }
}

