/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter.adaptive;

import com.github.psambit9791.jdsp.filter.adaptive._Adaptive;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.Arrays;
import org.apache.commons.math3.util.MathArrays;

public class RLS
implements _Adaptive {
    private double[] weights;
    private double[] error;
    private double[] output;
    private double mu;
    private double[][] R;

    public RLS(double mu, double eps, double[] weights) {
        if (weights == null || weights.length == 0) {
            throw new IllegalArgumentException("Weights must be non-null and with a length greater than 0");
        }
        this.weights = weights;
        this.mu = mu;
        int length = weights.length;
        this.R = new double[length][length];
        for (int i = 0; i < length; ++i) {
            this.R[i][i] = 1.0 / eps;
        }
    }

    public RLS(double[] weights) {
        this(0.99, 0.1, weights);
    }

    public RLS(int length, double mu, double eps, _Adaptive.WeightsFillMethod fillMethod) {
        int i;
        this.weights = new double[length];
        this.mu = mu;
        switch (fillMethod) {
            case RANDOM: {
                for (i = 0; i < length; ++i) {
                    this.weights[i] = Math.random();
                }
                break;
            }
            case ZEROS: {
                Arrays.fill(this.weights, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown weights fill method");
            }
        }
        this.R = new double[length][length];
        for (i = 0; i < length; ++i) {
            this.R[i][i] = 1.0 / eps;
        }
    }

    public RLS(int length, _Adaptive.WeightsFillMethod fillMethod) {
        this(length, 0.99, 0.1, fillMethod);
    }

    private double[] adaptWeights(double desired, double[] x) {
        double y = UtilMethods.dotProduct(x, this.weights);
        double error = desired - y;
        double[][] x_squared = UtilMethods.matrixMultiply(UtilMethods.transpose(x), new double[][]{x});
        double[][] R1 = UtilMethods.matrixMultiply(this.R, x_squared);
        R1 = UtilMethods.matrixMultiply(R1, this.R);
        double[][] R2 = UtilMethods.matrixMultiply(new double[][]{x}, this.R);
        R2 = UtilMethods.matrixMultiply(R2, UtilMethods.transpose(x));
        double r2 = R2[0][0] + this.mu;
        for (int i = 0; i < this.R.length; ++i) {
            for (int j = 0; j < this.R[i].length; ++j) {
                this.R[i][j] = 1.0 / this.mu * (this.R[i][j] - R1[i][j] / r2);
            }
        }
        double[] dw = UtilMethods.flattenMatrix(UtilMethods.matrixMultiply(this.R, UtilMethods.transpose(x)));
        dw = UtilMethods.scalarArithmetic(dw, error, "mul");
        this.weights = MathArrays.ebeAdd((double[])this.weights, (double[])dw);
        return new double[]{y, error};
    }

    @Override
    public void filter(double[] desired, double[] x) {
        if (desired == null || desired.length == 0) {
            throw new IllegalArgumentException("Desired signal cannot be null, or with size 0");
        }
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException("Input signal cannot be null, or with size 0");
        }
        if (x.length != desired.length) {
            throw new IllegalArgumentException("The length of the desired signal and input signal must be equal.");
        }
        if (this.weights.length > x.length) {
            throw new IllegalArgumentException("Filter length must not be greater than the signal length");
        }
        this.error = new double[x.length];
        this.output = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            double[] x_subset = new double[this.weights.length];
            Arrays.fill(x_subset, 0.0);
            for (int j = 0; j < x_subset.length; ++j) {
                if (i - j <= 0) continue;
                x_subset[x_subset.length - 1 - j] = x[i - j];
            }
            double[] out = this.adaptWeights(desired[i], x_subset);
            this.output[i] = out[0];
            this.error[i] = out[1];
        }
    }

    public double[] getWeights() {
        this.checkOutput();
        return this.weights;
    }

    public double[] getError() {
        this.checkOutput();
        return this.error;
    }

    public double[] getOutput() {
        this.checkOutput();
        return this.output;
    }

    private void checkOutput() {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute filter() function before returning result");
        }
    }
}

