/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.io;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.wavfile.WavFile;
import com.github.psambit9791.wavfile.WavFileException;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class WAV {
    private WavFile wf;
    public Hashtable<String, Long> props;
    private double[][] dataInt;
    private double[][] dataLong;
    private double[][] dataDouble;

    public void readTemplate(int bitSize) throws WavFileException, IOException {
        File f = null;
        try {
            f = new File(this.getClass().getClassLoader().getResource("sample" + bitSize + ".wav").getFile());
        }
        catch (NullPointerException e) {
            System.out.println("File Not Found.");
        }
        this.wf = WavFile.openWavFile(f);
        this.computeProperties();
        this.storeArray("int");
        this.storeArray("long");
        this.storeArray("double");
    }

    public void readWAV(String filename) throws WavFileException, IOException {
        String ext = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        if (!ext.equalsIgnoreCase("wav")) {
            System.out.println("File is not of WAV format");
        } else {
            File f = null;
            try {
                f = new File(filename);
            }
            catch (NullPointerException e) {
                System.out.println("File Not Found.");
            }
            this.wf = WavFile.openWavFile((File)f);
            this.computeProperties();
            this.storeArray("int");
            this.storeArray("long");
            this.storeArray("double");
        }
    }

    private double[][] convertEightBitToSigned(double[][] signal) {
        for (int i = 0; i < signal.length; ++i) {
            for (int j = 0; j < signal[0].length; ++j) {
                signal[i][j] = signal[i][j] - 128.0;
            }
        }
        return signal;
    }

    private int[][] convertSignedToEightBit(int[][] signal) {
        for (int i = 0; i < signal.length; ++i) {
            for (int j = 0; j < signal[0].length; ++j) {
                signal[i][j] = signal[i][j] + 128;
            }
        }
        return signal;
    }

    private void computeProperties() {
        int bytesPerSample = (this.wf.getValidBits() + 7) / 8;
        this.props = new Hashtable();
        this.props.put("Channels", Long.valueOf(this.wf.getNumChannels()));
        this.props.put("Frames", this.wf.getNumFrames());
        this.props.put("SampleRate", this.wf.getSampleRate());
        this.props.put("BlockAlign", Long.valueOf(bytesPerSample * this.wf.getNumChannels()));
        this.props.put("ValidBits", Long.valueOf(this.wf.getValidBits()));
        this.props.put("BytesPerSample", Long.valueOf(bytesPerSample));
    }

    public Hashtable getProperties() {
        return this.props;
    }

    public int getDurationInMilliseconds() {
        return (int)UtilMethods.round((double)(this.props.get("Frames") * 1000L) / (double)this.props.get("SampleRate").longValue(), 0);
    }

    public int getRMS() throws IOException, WavFileException, IllegalArgumentException {
        double rms = 0.0;
        double[] temp = this.flatten(this.getData("int"));
        for (int i = 0; i < temp.length; ++i) {
            rms += temp[i] * temp[i];
        }
        rms = Math.sqrt(rms / (double)temp.length);
        return (int)rms;
    }

    private double[] flatten(double[][] signal) {
        double[] flat = new double[signal.length * signal[0].length];
        int idx = 0;
        for (int i = 0; i < signal.length; ++i) {
            for (int j = 0; j < signal[0].length; ++j) {
                flat[idx] = signal[i][j];
                ++idx;
            }
        }
        return flat;
    }

    private double[][] toDouble(int[][] a) {
        double[][] out = new double[a.length][a[0].length];
        for (int i = 0; i < out.length; ++i) {
            for (int j = 0; j < out[0].length; ++j) {
                out[i][j] = a[i][j];
            }
        }
        return out;
    }

    private double[][] toDouble(long[][] a) {
        double[][] out = new double[a.length][a[0].length];
        for (int i = 0; i < out.length; ++i) {
            for (int j = 0; j < out[0].length; ++j) {
                out[i][j] = a[i][j];
            }
        }
        return out;
    }

    private void storeArray(String type) throws IOException, WavFileException, IllegalArgumentException {
        int channels = this.props.get("Channels").intValue();
        int frames = this.props.get("Frames").intValue();
        if (type.equals("int")) {
            int[][] sig = new int[channels][frames];
            this.wf.readFrames(sig, frames);
            double[][] signal = this.toDouble(sig);
            this.dataInt = UtilMethods.transpose(signal);
            if (this.props.get("BytesPerSample") == 1L) {
                this.dataInt = this.convertEightBitToSigned(this.dataInt);
            }
        } else if (type.equals("long")) {
            long[][] sig = new long[channels][frames];
            this.wf.readFrames(sig, frames);
            double[][] signal = this.toDouble(sig);
            this.dataLong = UtilMethods.transpose(signal);
        } else if (type.equals("double")) {
            double[][] sig = new double[channels][frames];
            this.wf.readFrames(sig, frames);
            double[][] signal = sig;
            this.dataDouble = UtilMethods.transpose(signal);
        } else {
            throw new IllegalArgumentException("Type must be int, long or double");
        }
    }

    public double[][] getData(String type) throws IllegalArgumentException {
        if (type.equals("int")) {
            return this.dataInt;
        }
        if (type.equals("long")) {
            return this.dataLong;
        }
        if (type.equals("double")) {
            return this.dataDouble;
        }
        throw new IllegalArgumentException("Type must be int, long or double");
    }

    public void putData(double[][] signal, long samplingRate, String type, String filename) throws IOException, WavFileException, IllegalArgumentException {
        this.putData(signal, samplingRate, 16, type, filename);
    }

    public void putData(double[][] signal, long samplingRate, int validBits, String type, String filename) throws IOException, WavFileException, IllegalArgumentException {
        signal = UtilMethods.transpose(signal);
        int channels = signal.length;
        long frames = signal[0].length;
        File f = new File(filename);
        this.wf = WavFile.newWavFile((File)f, (int)channels, (long)frames, (int)validBits, (long)samplingRate);
        if (type.equals("int8")) {
            int[][] buffer = new int[channels][100];
            long frameCounter = 0L;
            while (frameCounter < frames) {
                long remaining = this.wf.getFramesRemaining();
                int toWrite = remaining > 100L ? 100 : (int)remaining;
                int s = 0;
                while (s < toWrite) {
                    for (int c = 0; c < channels; ++c) {
                        buffer[c][s] = (int)signal[c][(int)frameCounter];
                    }
                    ++s;
                    ++frameCounter;
                }
                buffer = this.convertSignedToEightBit(buffer);
                this.wf.writeFrames(buffer, toWrite);
            }
            this.wf.close();
        } else if (type.equals("int")) {
            int[][] buffer = new int[channels][100];
            long frameCounter = 0L;
            while (frameCounter < frames) {
                long remaining = this.wf.getFramesRemaining();
                int toWrite = remaining > 100L ? 100 : (int)remaining;
                int s = 0;
                while (s < toWrite) {
                    for (int c = 0; c < channels; ++c) {
                        buffer[c][s] = (int)signal[c][(int)frameCounter];
                    }
                    ++s;
                    ++frameCounter;
                }
                this.wf.writeFrames(buffer, toWrite);
            }
            this.wf.close();
        } else if (type.equals("long")) {
            long[][] buffer = new long[channels][100];
            long frameCounter = 0L;
            while (frameCounter < frames) {
                long remaining = this.wf.getFramesRemaining();
                int toWrite = remaining > 100L ? 100 : (int)remaining;
                int s = 0;
                while (s < toWrite) {
                    for (int c = 0; c < channels; ++c) {
                        buffer[c][s] = (long)signal[c][(int)frameCounter];
                    }
                    ++s;
                    ++frameCounter;
                }
                this.wf.writeFrames(buffer, toWrite);
            }
            this.wf.close();
        } else if (type.equals("double")) {
            double[][] buffer = new double[channels][100];
            long frameCounter = 0L;
            while (frameCounter < frames) {
                long remaining = this.wf.getFramesRemaining();
                int toWrite = remaining > 100L ? 100 : (int)remaining;
                int s = 0;
                while (s < toWrite) {
                    for (int c = 0; c < channels; ++c) {
                        buffer[c][s] = signal[c][(int)frameCounter];
                    }
                    ++s;
                    ++frameCounter;
                }
                this.wf.writeFrames(buffer, toWrite);
            }
            this.wf.close();
        } else {
            throw new IllegalArgumentException("Type must be int, long or double");
        }
    }
}

