/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.MathArrays;

public class UtilMethods {
    public static double[] linspace(int start, int stop, int samples, boolean includeEnd) {
        double T;
        double[] time = new double[samples];
        double span = stop - start;
        double stopVal = stop;
        double i = start;
        if (includeEnd) {
            T = span / (double)(samples - 1);
        } else {
            T = span / (double)samples;
            stopVal -= T;
        }
        int index = 0;
        time[index] = i;
        for (index = 1; index < time.length; ++index) {
            time[index] = i += T;
        }
        if (includeEnd) {
            time[time.length - 1] = stop;
        }
        return time;
    }

    public static double[] linspace(double start, double stop, int samples, boolean includeEnd) {
        double T;
        double[] time = new double[samples];
        double span = stop - start;
        double stopVal = stop;
        double i = start;
        if (includeEnd) {
            T = span / (double)(samples - 1);
        } else {
            T = span / (double)samples;
            stopVal -= T;
        }
        int index = 0;
        time[index] = i;
        for (index = 1; index < time.length; ++index) {
            time[index] = i += T;
        }
        if (includeEnd) {
            time[time.length - 1] = stop;
        }
        return time;
    }

    public static double[] linspace(int start, int stop, int samples, int repeats) {
        double[] time = new double[samples];
        double T = 1.0 / (double)(samples - 1);
        double i = start;
        int index = 0;
        time[index] = i;
        while (Math.abs(i - (double)stop) > 1.0E-5) {
            time[++index] = i += T;
        }
        double[] out = new double[]{};
        for (int j = 0; j < repeats; ++j) {
            out = UtilMethods.concatenateArray(out, time);
        }
        return out;
    }

    public static double[] arange(double start, double stop, double step) {
        if (start > stop) {
            throw new IllegalArgumentException("start cannot be greater than stop");
        }
        int size = (int)((stop - start) / step);
        double[] arr = new double[size];
        double temp = start;
        for (int i = 0; i < size; ++i) {
            arr[i] = temp;
            temp += step;
        }
        return arr;
    }

    public static int[] arange(int start, int stop, int step) {
        if (start > stop) {
            throw new IllegalArgumentException("start cannot be greater than stop");
        }
        int size = (stop - start) / step;
        int[] arr = new int[size];
        int temp = start;
        for (int i = 0; i < size; ++i) {
            arr[i] = temp;
            temp += step;
        }
        return arr;
    }

    public static double[] reverse(double[] arr) {
        double[] inv = new double[arr.length];
        for (int i = 0; i < inv.length; ++i) {
            inv[i] = arr[arr.length - 1 - i];
        }
        return inv;
    }

    public static Complex[] reverse(Complex[] arr) {
        Complex[] inv = new Complex[arr.length];
        for (int i = 0; i < inv.length; ++i) {
            inv[i] = arr[arr.length - 1 - i];
        }
        return inv;
    }

    public static int[] reverse(int[] arr) {
        int[] inv = new int[arr.length];
        for (int i = 0; i < inv.length; ++i) {
            inv[i] = arr[arr.length - 1 - i];
        }
        return inv;
    }

    public static double[] concatenateArray(double[] arr1, double[] arr2) {
        double[] out = new double[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, out, 0, arr1.length);
        System.arraycopy(arr2, 0, out, arr1.length, arr2.length);
        return out;
    }

    public static int[] concatenateArray(int[] arr1, int[] arr2) {
        int[] out = new int[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, out, 0, arr1.length);
        System.arraycopy(arr2, 0, out, arr1.length, arr2.length);
        return out;
    }

    public static int[][] reverseMatrix(int[][] mat) {
        int[][] rev = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat[0].length; ++i) {
            rev[i] = UtilMethods.reverse(mat[i]);
        }
        return rev;
    }

    public static double[][] reverseMatrix(double[][] mat) {
        double[][] rev = new double[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            rev[i] = UtilMethods.reverse(mat[i]);
        }
        return rev;
    }

    public static double[] splitByIndex(double[] arr, int start, int end) {
        double[] out = new double[end - start];
        System.arraycopy(arr, start, out, 0, out.length);
        return out;
    }

    public static int[] splitByIndex(int[] arr, int start, int end) {
        int[] out = new int[end - start];
        System.arraycopy(arr, start, out, 0, out.length);
        return out;
    }

    public static Complex[] splitByIndex(Complex[] arr, int start, int end) {
        Complex[] out = new Complex[end - start];
        System.arraycopy(arr, start, out, 0, out.length);
        return out;
    }

    public static double[][] pseudoInverse(double[][] mtrx) {
        RealMatrix M = MatrixUtils.createRealMatrix((double[][])mtrx);
        DecompositionSolver solver = new SingularValueDecomposition(M).getSolver();
        return solver.getInverse().getData();
    }

    public static double[] padSignal(double[] signal, String mode) {
        double[] newSignal;
        switch (mode) {
            case "reflect": {
                double[] revSig = UtilMethods.reverse(signal);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, revSig);
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, revSig);
                newSignal = newSig;
                break;
            }
            case "constant": {
                double[] cons = new double[signal.length];
                Arrays.fill(cons, 0.0);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, cons);
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, cons);
                newSignal = newSig;
                break;
            }
            case "nearest": {
                double[] left = new double[signal.length];
                Arrays.fill(left, signal[0]);
                double[] right = new double[signal.length];
                Arrays.fill(right, signal[signal.length - 1]);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, left);
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, right);
                newSignal = newSig;
                break;
            }
            case "mirror": {
                double[] temp = UtilMethods.splitByIndex(signal, 1, signal.length);
                temp = UtilMethods.reverse(temp);
                double[] val = new double[]{temp[1]};
                double[] left = UtilMethods.concatenateArray(val, temp);
                temp = UtilMethods.splitByIndex(signal, 0, signal.length - 1);
                temp = UtilMethods.reverse(temp);
                val = new double[]{temp[temp.length - 2]};
                double[] right = UtilMethods.concatenateArray(temp, val);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, left);
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, right);
                newSignal = newSig;
                break;
            }
            case "wrap": {
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSignal = newSig = UtilMethods.concatenateArray(newSig, signal);
                break;
            }
            default: {
                throw new IllegalArgumentException("padSignalforConvolution modes can only be reflect, constant, nearest, mirror, or wrap");
            }
        }
        return newSignal;
    }

    public static double[] padSignal(double[] signal, String mode, int length) {
        double[] newSignal;
        switch (mode) {
            case "reflect": {
                double[] revSig = UtilMethods.reverse(signal);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, UtilMethods.splitByIndex(revSig, signal.length - length, signal.length));
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, UtilMethods.splitByIndex(revSig, 0, length));
                newSignal = newSig;
                break;
            }
            case "constant": {
                double[] cons = new double[length];
                Arrays.fill(cons, 0.0);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, cons);
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSignal = newSig = UtilMethods.concatenateArray(newSig, cons);
                break;
            }
            case "nearest": {
                double[] left = new double[length];
                Arrays.fill(left, signal[0]);
                double[] right = new double[length];
                Arrays.fill(right, signal[signal.length - 1]);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, left);
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, right);
                newSignal = newSig;
                break;
            }
            case "mirror": {
                double[] temp = UtilMethods.splitByIndex(signal, 1, signal.length);
                temp = UtilMethods.reverse(temp);
                double[] val = new double[]{temp[1]};
                double[] left = UtilMethods.concatenateArray(val, temp);
                temp = UtilMethods.splitByIndex(signal, 0, signal.length - 1);
                temp = UtilMethods.reverse(temp);
                val = new double[]{temp[temp.length - 2]};
                double[] right = UtilMethods.concatenateArray(temp, val);
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, UtilMethods.splitByIndex(left, signal.length - length, signal.length));
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, UtilMethods.splitByIndex(right, 0, length));
                newSignal = newSig;
                break;
            }
            case "wrap": {
                double[] newSig = new double[]{};
                newSig = UtilMethods.concatenateArray(newSig, UtilMethods.splitByIndex(signal, signal.length - length, signal.length));
                newSig = UtilMethods.concatenateArray(newSig, signal);
                newSig = UtilMethods.concatenateArray(newSig, UtilMethods.splitByIndex(signal, 0, length));
                newSignal = newSig;
                break;
            }
            default: {
                throw new IllegalArgumentException("padSignalforConvolution modes can only be reflect, constant, nearest, mirror, or wrap");
            }
        }
        return newSignal;
    }

    public static double[] zeroPadSignal(double[] signal, int padSize) {
        if (padSize < 0) {
            throw new IllegalArgumentException("Pad size must be a positive integer");
        }
        double[] zeroes = new double[padSize];
        Arrays.fill(zeroes, 0.0);
        return UtilMethods.concatenateArray(signal, zeroes);
    }

    public static double[] truncateSignal(double[] signal, int signalSize) {
        if (signalSize < 0) {
            throw new IllegalArgumentException("Truncation size should be a positive integer");
        }
        if (signalSize > signal.length) {
            throw new IllegalArgumentException("Truncation size should be smaller than signal size");
        }
        return Arrays.copyOfRange(signal, 0, signalSize);
    }

    public static double[] diff(double[] arr) {
        double[] sig = new double[arr.length - 1];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = arr[i + 1] - arr[i];
        }
        return sig;
    }

    public static int[] diff(int[] arr) {
        int[] sig = new int[arr.length - 1];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = arr[i + 1] - arr[i];
        }
        return sig;
    }

    public static double[] unwrap(double[] arr) {
        int i;
        double[] diff = UtilMethods.diff(arr);
        double[] out = new double[arr.length];
        for (i = 0; i < diff.length; ++i) {
            diff[i] = UtilMethods.modulo(diff[i] + Math.PI, Math.PI * 2) - Math.PI;
        }
        out[0] = arr[0];
        for (i = 0; i < diff.length; ++i) {
            out[i + 1] = out[i] + diff[i];
        }
        return out;
    }

    public static double modulo(double dividend, double divisor) {
        return (dividend % divisor + divisor) % divisor;
    }

    public static int modulo(int dividend, int divisor) {
        return (dividend % divisor + divisor) % divisor;
    }

    public static double round(double value, int decimals) {
        double scale = Math.pow(10.0, decimals);
        return (double)Math.round(value * scale) / scale;
    }

    public static double[] round(double[] arr, int decimals) {
        return Arrays.stream(arr).map(c -> UtilMethods.round(c, decimals)).toArray();
    }

    public static double[] rescale(double[] arr, int min_value, int max_value) {
        double[] newArr = new double[arr.length];
        double minArr = StatUtils.min((double[])arr);
        double maxArr = StatUtils.max((double[])arr);
        for (int i = 0; i < arr.length; ++i) {
            newArr[i] = (arr[i] - minArr) / (maxArr - minArr) * (double)(max_value - min_value) + (double)min_value;
        }
        return newArr;
    }

    public static double[] standardize(double[] arr) {
        double[] newArr = new double[arr.length];
        double minArr = StatUtils.min((double[])arr);
        double maxArr = StatUtils.max((double[])arr);
        for (int i = 0; i < arr.length; ++i) {
            newArr[i] = (arr[i] - minArr) / (maxArr - minArr);
        }
        return newArr;
    }

    public static double[] normalize(double[] arr) {
        return StatUtils.normalize((double[])arr);
    }

    public static double[] zeroCenter(double[] arr) {
        double[] newArr = new double[arr.length];
        double mean = StatUtils.mean((double[])arr);
        for (int i = 0; i < arr.length; ++i) {
            newArr[i] = arr[i] - mean;
        }
        return newArr;
    }

    public static boolean almostEquals(double num1, double num2, double epsilon) {
        return Math.abs(num1 - num2) <= epsilon;
    }

    private static PolynomialSplineFunction linearInterp(double[] x, double[] y) {
        LinearInterpolator li = new LinearInterpolator();
        return li.interpolate(x, y);
    }

    public static int[] convertToPrimitiveInt(ArrayList<Integer> l) {
        int[] ret = new int[l.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = l.get(i);
        }
        return ret;
    }

    public static int[] convertToPrimitiveInt(LinkedList<Integer> l) {
        int[] ret = new int[l.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = l.get(i);
        }
        return ret;
    }

    public static double[] convertToPrimitiveDouble(ArrayList<Double> l) {
        double[] ret = new double[l.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = l.get(i);
        }
        return ret;
    }

    public static int argmin(double[] arr, boolean reverse) {
        double min = StatUtils.min((double[])arr);
        if (reverse) {
            arr = UtilMethods.reverse(arr);
        }
        int index = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (min != arr[i]) continue;
            index = i;
            break;
        }
        if (reverse) {
            index = arr.length - 1 - index;
        }
        return index;
    }

    public static int argmax(double[] arr, boolean reverse) {
        double max = StatUtils.max((double[])arr);
        if (reverse) {
            arr = UtilMethods.reverse(arr);
        }
        int index = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (max != arr[i]) continue;
            index = i;
            break;
        }
        if (reverse) {
            index = arr.length - 1 - index;
        }
        return index;
    }

    public static int[] argsort(final double[] arr, final boolean ascending) {
        int i;
        Integer[] indexes = new Integer[arr.length];
        int[] argsArray = new int[arr.length];
        for (i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return (ascending ? 1 : -1) * Double.compare(arr[i1], arr[i2]);
            }
        });
        for (i = 0; i < indexes.length; ++i) {
            argsArray[i] = indexes[i];
        }
        return argsArray;
    }

    public static double[] electrocardiogram() throws IOException {
        double[] data = new double[108000];
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream("ecg.dat");
        assert (is != null);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String[] line = br.readLine().trim().split(" ");
        for (int i = 0; i < line.length; ++i) {
            data[i] = Double.parseDouble(line[i]);
        }
        return data;
    }

    public static double[][] absoluteArray(double[][] m) {
        double[][] out = new double[m.length][m[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                out[i][j] = Math.abs(m[i][j]);
            }
        }
        return out;
    }

    public static double[] absoluteArray(double[] m) {
        double[] out = new double[m.length];
        for (int i = 0; i < m.length; ++i) {
            out[i] = Math.abs(m[i]);
        }
        return out;
    }

    public static int[] flattenMatrix(int[][] m) {
        int cols = m[0].length;
        int[] out = new int[m.length * cols];
        for (int i = 0; i < out.length; ++i) {
            out[i] = m[i / cols][i % cols];
        }
        return out;
    }

    public static double[] flattenMatrix(double[][] m) {
        int cols = m[0].length;
        double[] out = new double[m.length * cols];
        for (int i = 0; i < out.length; ++i) {
            out[i] = m[i / cols][i % cols];
        }
        return out;
    }

    public static double[] getRow(double[][] m, int rowIdx) {
        if (rowIdx < 0) {
            System.err.println("Row index can not be negative");
            return null;
        }
        if (rowIdx >= m.length) {
            System.err.println("Row index is greater than matrix row dimension");
            return null;
        }
        return m[rowIdx];
    }

    public static double[] getColumn(double[][] m, int colIdx) {
        if (colIdx < 0) {
            System.err.println("Column index can not be negative");
            return null;
        }
        if (colIdx >= m[0].length) {
            System.err.println("Column index is greater than matrix column dimension");
            return null;
        }
        double[] column = new double[m.length];
        for (int i = 0; i < column.length; ++i) {
            column[i] = m[i][colIdx];
        }
        return column;
    }

    public static double[][] transpose(double[][] m) {
        RealMatrix m1 = MatrixUtils.createRealMatrix((double[][])m);
        return m1.transpose().getData();
    }

    public static double[][] transpose(double[] m) {
        double[][] m1 = new double[m.length][1];
        for (int i = 0; i < m.length; ++i) {
            m1[i][0] = m[i];
        }
        return m1;
    }

    public static double[][] matrixMultiply(double[][] a, double[][] b) throws ArithmeticException {
        if (a[0].length != b.length) {
            throw new ArithmeticException("Columns in multiplier must be equal to Rows in Multiplicand");
        }
        RealMatrix m1 = MatrixUtils.createRealMatrix((double[][])a);
        RealMatrix m2 = MatrixUtils.createRealMatrix((double[][])b);
        RealMatrix m = m1.multiply(m2);
        return m.getData();
    }

    public static double[][] matrixAddition(double[][] a, double[][] b) throws ArithmeticException {
        if (a.length != b.length || a[0].length != b[0].length) {
            throw new ArithmeticException("Size of both matrices should be same");
        }
        RealMatrix m1 = MatrixUtils.createRealMatrix((double[][])a);
        RealMatrix m2 = MatrixUtils.createRealMatrix((double[][])b);
        RealMatrix m = m1.add(m2);
        return m.getData();
    }

    public static double[][] matrixSubtraction(double[][] a, double[][] b) throws ArithmeticException {
        if (a.length != b.length || a[0].length != b[0].length) {
            throw new ArithmeticException("Size of both matrices should be same");
        }
        RealMatrix m1 = MatrixUtils.createRealMatrix((double[][])a);
        RealMatrix m2 = MatrixUtils.createRealMatrix((double[][])b);
        RealMatrix m = m1.subtract(m2);
        return m.getData();
    }

    public static double[] scalarArithmetic(double[] arr, double val, String action) throws IllegalArgumentException {
        if (!(action.equals("add") || action.equals("sub") || action.equals("mul") || action.equals("reverse_sub") || action.equals("div") || action.equals("pow"))) {
            throw new ArithmeticException("action must be 'add', 'sub', 'reverse_sub', 'mul', 'div' or 'pow'");
        }
        double[] out = new double[arr.length];
        switch (action) {
            case "add": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = arr[i] + val;
                }
                break;
            }
            case "sub": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = arr[i] - val;
                }
                break;
            }
            case "reverse_sub": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = val - arr[i];
                }
                break;
            }
            case "mul": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = arr[i] * val;
                }
                break;
            }
            case "div": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = arr[i] / val;
                }
                break;
            }
            default: {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = Math.pow(arr[i], val);
                }
            }
        }
        return out;
    }

    public static double[] trigonometricArithmetic(double[] arr, String function) throws IllegalArgumentException {
        if (!(function.equals("sin") || function.equals("cos") || function.equals("tan") || function.equals("asin") || function.equals("acos") || function.equals("atan"))) {
            throw new ArithmeticException("action must be 'sin', 'cos', 'tan', 'asin', 'acos' or 'atan'");
        }
        double[] out = new double[arr.length];
        switch (function) {
            case "sin": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = Math.sin(arr[i]);
                }
                break;
            }
            case "cos": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = Math.cos(arr[i]);
                }
                break;
            }
            case "tan": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = Math.tan(arr[i]);
                }
                break;
            }
            case "asin": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = Math.asin(arr[i]);
                }
                break;
            }
            case "acos": {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = Math.acos(arr[i]);
                }
                break;
            }
            default: {
                for (int i = 0; i < arr.length; ++i) {
                    out[i] = Math.atan(arr[i]);
                }
            }
        }
        return out;
    }

    public static boolean isSorted(double[] arr, boolean descending) {
        if (descending) {
            for (int i = 0; i < arr.length - 1; ++i) {
                if (!(arr[i] < arr[i + 1])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < arr.length - 1; ++i) {
                if (!(arr[i] > arr[i + 1])) continue;
                return false;
            }
        }
        return true;
    }

    public static double interpolate(double point, double[] x, double[] y) {
        if (!UtilMethods.isSorted(x, false)) {
            throw new IllegalArgumentException("X-coordinates must be increasing");
        }
        LinearInterpolator li = new LinearInterpolator();
        PolynomialSplineFunction psf = li.interpolate(x, y);
        return psf.value(point);
    }

    public static double[] interpolate(double[] points, double[] x, double[] y) {
        if (!UtilMethods.isSorted(x, false)) {
            throw new IllegalArgumentException("X-coordinates must be increasing");
        }
        LinearInterpolator li = new LinearInterpolator();
        PolynomialSplineFunction psf = li.interpolate(x, y);
        double[] out = new double[points.length];
        for (int i = 0; i < points.length; ++i) {
            out[i] = psf.value(points[i]);
        }
        return out;
    }

    public static double[] chebyEval(double[] x, double[] arr) {
        double[] b0 = new double[]{arr[0]};
        double[] b1 = new double[]{0.0};
        double[] b2 = new double[]{0.0};
        for (int i = 1; i < arr.length; ++i) {
            b2 = b1;
            b1 = b0;
            if (b0.length == 1) {
                b0 = UtilMethods.scalarArithmetic(x, b1[0], "mul");
                b0 = UtilMethods.scalarArithmetic(b0, b2[0] - arr[i], "sub");
                continue;
            }
            if (b1.length > 1 && b2.length == 1) {
                b0 = MathArrays.ebeMultiply((double[])x, (double[])b1);
                b0 = UtilMethods.scalarArithmetic(b0, b2[0] - arr[i], "sub");
                continue;
            }
            b0 = MathArrays.ebeMultiply((double[])x, (double[])b1);
            b0 = MathArrays.ebeSubtract((double[])b0, (double[])b2);
            b0 = UtilMethods.scalarArithmetic(b0, arr[i], "add");
        }
        return MathArrays.scale((double)0.5, (double[])MathArrays.ebeSubtract((double[])b0, (double[])b2));
    }

    public static double chebyEval(double x, double[] arr) {
        double b0 = arr[0];
        double b1 = 0.0;
        double b2 = 0.0;
        for (int i = 1; i < arr.length; ++i) {
            b2 = b1;
            b1 = b0;
            b0 = x * b1 - b2 + arr[i];
        }
        return 0.5 * (b0 - b2);
    }

    public static double[] i0(double[] x) {
        double[] A = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
        double[] B = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
        double[] out = new double[x.length];
        x = UtilMethods.absoluteArray(x);
        for (int i = 0; i < x.length; ++i) {
            out[i] = x[i] <= 8.0 ? Math.exp(x[i]) * UtilMethods.chebyEval(x[i] / 2.0 - 2.0, A) : Math.exp(x[i]) * UtilMethods.chebyEval(32.0 / x[i] - 2.0, B) / Math.sqrt(x[i]);
        }
        return out;
    }

    public static double i0(double x) {
        double[] A = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
        double[] B = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
        double out = (x = Math.abs(x)) <= 8.0 ? Math.exp(x) * UtilMethods.chebyEval(x / 2.0 - 2.0, A) : Math.exp(x) * UtilMethods.chebyEval(32.0 / x - 2.0, B) / Math.sqrt(x);
        return out;
    }

    public static double[] i0e(double[] x) {
        double[] A = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
        double[] B = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
        double[] out = new double[x.length];
        x = UtilMethods.absoluteArray(x);
        for (int i = 0; i < x.length; ++i) {
            out[i] = x[i] <= 8.0 ? UtilMethods.chebyEval(x[i] / 2.0 - 2.0, A) : UtilMethods.chebyEval(32.0 / x[i] - 2.0, B) / Math.sqrt(x[i]);
        }
        return out;
    }

    public static double i0e(double x) {
        double[] A = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
        double[] B = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
        double out = (x = Math.abs(x)) <= 8.0 ? UtilMethods.chebyEval(x / 2.0 - 2.0, A) : UtilMethods.chebyEval(32.0 / x - 2.0, B) / Math.sqrt(x);
        return out;
    }

    public static double sinc(double x) {
        double y = x == 0.0 ? 1.0E-20 : x;
        y = Math.PI * y;
        return Math.sin(y) / y;
    }

    public static double[] sinc(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = UtilMethods.sinc(x[i]);
        }
        return y;
    }

    public static double[][] toeplitz(double[] x) {
        double[][] matrix = new double[x.length][x.length];
        for (int i = 0; i < x.length; ++i) {
            int j;
            int index = 0;
            for (j = i; j < x.length; ++j) {
                matrix[i][j] = x[index++];
            }
            index = 0;
            for (j = i - 1; j >= 0; --j) {
                matrix[i][j] = x[++index];
            }
        }
        return matrix;
    }

    public static double[][] hankel(double[] c) {
        double[][] matrix;
        for (double[] row : matrix = new double[c.length][c.length]) {
            Arrays.fill(row, 0.0);
        }
        for (int i = 0; i < c.length; ++i) {
            int index = i;
            for (int j = 0; j < c.length - i; ++j) {
                matrix[i][j] = c[index++];
            }
        }
        return matrix;
    }

    public static double[][] hankel(double[] c, double[] r) {
        double[][] matrix = new double[c.length][r.length];
        if (c[c.length - 1] != r[0]) {
            throw new IllegalArgumentException("Last element of c and First element of x must be same");
        }
        double[] temp_r = UtilMethods.splitByIndex(r, 1, r.length);
        double[] vals = UtilMethods.concatenateArray(c, temp_r);
        for (int i = 0; i < c.length; ++i) {
            int index = i;
            for (int j = 0; j < r.length; ++j) {
                matrix[i][j] = vals[index++];
            }
        }
        return matrix;
    }

    public static Complex[] matToComplex(double[] arr) {
        Complex[] out = new Complex[arr.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new Complex(arr[i]);
        }
        return out;
    }

    public static Complex[] matToComplex(double[][] arr) {
        Complex[] out = new Complex[arr.length];
        for (int i = 0; i < out.length; ++i) {
            if (arr[i].length == 2) {
                out[i] = new Complex(arr[i][0], arr[i][1]);
                continue;
            }
            if (arr[i].length == 1) {
                out[i] = new Complex(arr[i][0]);
                continue;
            }
            throw new IllegalArgumentException("Dimension 2 must be of length 1 or 2.");
        }
        return out;
    }

    public static Complex[][] matToComplex(double[][][] arr) {
        Complex[][] out = new Complex[arr.length][arr[0].length];
        for (int i = 0; i < out.length; ++i) {
            for (int j = 0; j < out[0].length; ++j) {
                if (arr[i][j].length == 2) {
                    out[i][j] = new Complex(arr[i][j][0], arr[i][j][1]);
                    continue;
                }
                if (arr[i][j].length == 1) {
                    out[i][j] = new Complex(arr[i][j][0]);
                    continue;
                }
                throw new IllegalArgumentException("Dimension 3 must be of length 1 or 2.");
            }
        }
        return out;
    }

    public static double[][] complexTo2D(Complex[] arr) {
        double[][] out = new double[arr.length][2];
        for (int i = 0; i < arr.length; ++i) {
            out[i][0] = arr[i].getReal();
            out[i][1] = arr[i].getImaginary();
        }
        return out;
    }

    public static double log(int y, int base) {
        return Math.log(y) / Math.log(base);
    }

    public static double log(double y, int base) {
        return Math.log(y) / Math.log(base);
    }

    public static double antilog(int x, int base) {
        return Math.pow(base, x);
    }

    public static double antilog(double x, int base) {
        return Math.pow(base, x);
    }

    public static RealMatrix ebeMultiply(RealMatrix m1, RealMatrix m2) {
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (rowDim != m2.getRowDimension() || colDim != m2.getColumnDimension()) {
            throw new IllegalArgumentException("Dimensions of m1 and m2 matrices must be the same");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        for (int i = 0; i < rowDim; ++i) {
            for (int j = 0; j < colDim; ++j) {
                out.setEntry(i, j, m1.getEntry(i, j) * m2.getEntry(i, j));
            }
        }
        return out;
    }

    public static RealMatrix ebeMultiply(RealMatrix m1, RealMatrix m2, String type) {
        int j;
        int i;
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (!type.equals("row") && !type.equals("column")) {
            throw new IllegalArgumentException("Type must be either 'row' or 'column'");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        if (type.equals("column")) {
            if (rowDim != m2.getRowDimension() || m2.getColumnDimension() != 1) {
                throw new IllegalArgumentException("Rows of m1 and m2 matrices must be the same and m2 should have only 1 column");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) * m2.getEntry(i, 0));
                }
            }
        }
        if (type.equals("row")) {
            if (colDim != m2.getColumnDimension() || m2.getRowDimension() != 1) {
                throw new IllegalArgumentException("Columns of m1 and m2 matrices must be the same and m2 should have only 1 row");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) * m2.getEntry(0, j));
                }
            }
        }
        return out;
    }

    public static RealMatrix ebeDivide(RealMatrix m1, RealMatrix m2) {
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (rowDim != m2.getRowDimension() || colDim != m2.getColumnDimension()) {
            throw new IllegalArgumentException("Dimensions of m1 and m2 matrices must be the same");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        for (int i = 0; i < rowDim; ++i) {
            for (int j = 0; j < colDim; ++j) {
                out.setEntry(i, j, m1.getEntry(i, j) / m2.getEntry(i, j));
            }
        }
        return out;
    }

    public static RealMatrix ebeDivide(RealMatrix m1, RealMatrix m2, String type) {
        int j;
        int i;
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (!type.equals("row") && !type.equals("column")) {
            throw new IllegalArgumentException("Type must be either 'row' or 'column'");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        if (type.equals("column")) {
            if (rowDim != m2.getRowDimension() || m2.getColumnDimension() != 1) {
                throw new IllegalArgumentException("Rows of m1 and m2 matrices must be the same and m2 should have only 1 column");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) / m2.getEntry(i, 0));
                }
            }
        }
        if (type.equals("row")) {
            if (colDim != m2.getColumnDimension() || m2.getRowDimension() != 1) {
                throw new IllegalArgumentException("Columns of m1 and m2 matrices must be the same and m2 should have only 1 row");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) / m2.getEntry(0, j));
                }
            }
        }
        return out;
    }

    public static RealMatrix ebeAdd(RealMatrix m1, RealMatrix m2) {
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (rowDim != m2.getRowDimension() || colDim != m2.getColumnDimension()) {
            throw new IllegalArgumentException("Dimensions of m1 and m2 matrices must be the same");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        for (int i = 0; i < rowDim; ++i) {
            for (int j = 0; j < colDim; ++j) {
                out.setEntry(i, j, m1.getEntry(i, j) + m2.getEntry(i, j));
            }
        }
        return out;
    }

    public static RealMatrix ebeAdd(RealMatrix m1, RealMatrix m2, String type) {
        int j;
        int i;
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (!type.equals("row") && !type.equals("column")) {
            throw new IllegalArgumentException("Type must be either 'row' or 'column'");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        if (type.equals("column")) {
            if (rowDim != m2.getRowDimension() || m2.getColumnDimension() != 1) {
                throw new IllegalArgumentException("Rows of m1 and m2 matrices must be the same and m2 should have only 1 column");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) + m2.getEntry(i, 0));
                }
            }
        }
        if (type.equals("row")) {
            if (colDim != m2.getColumnDimension() || m2.getRowDimension() != 1) {
                throw new IllegalArgumentException("Columns of m1 and m2 matrices must be the same and m2 should have only 1 row");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) + m2.getEntry(0, j));
                }
            }
        }
        return out;
    }

    public static RealMatrix ebeSubtract(RealMatrix m1, RealMatrix m2) {
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (rowDim != m2.getRowDimension() || colDim != m2.getColumnDimension()) {
            throw new IllegalArgumentException("Dimensions of m1 and m2 matrices must be the same");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        for (int i = 0; i < rowDim; ++i) {
            for (int j = 0; j < colDim; ++j) {
                out.setEntry(i, j, m1.getEntry(i, j) - m2.getEntry(i, j));
            }
        }
        return out;
    }

    public static RealMatrix ebeSubtract(RealMatrix m1, RealMatrix m2, String type) {
        int j;
        int i;
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        if (!type.equals("row") && !type.equals("column")) {
            throw new IllegalArgumentException("Type must be either 'row' or 'column'");
        }
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        if (type.equals("column")) {
            if (rowDim != m2.getRowDimension() || m2.getColumnDimension() != 1) {
                throw new IllegalArgumentException("Rows of m1 and m2 matrices must be the same and m2 should have only 1 column");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) - m2.getEntry(i, 0));
                }
            }
        }
        if (type.equals("row")) {
            if (colDim != m2.getColumnDimension() || m2.getRowDimension() != 1) {
                throw new IllegalArgumentException("Columns of m1 and m2 matrices must be the same and m2 should have only 1 row");
            }
            for (i = 0; i < rowDim; ++i) {
                for (j = 0; j < colDim; ++j) {
                    out.setEntry(i, j, m1.getEntry(i, j) - m2.getEntry(0, j));
                }
            }
        }
        return out;
    }

    public static RealMatrix ebeInvert(RealMatrix m1) {
        int rowDim = m1.getRowDimension();
        int colDim = m1.getColumnDimension();
        RealMatrix out = MatrixUtils.createRealMatrix((int)rowDim, (int)colDim);
        for (int i = 0; i < rowDim; ++i) {
            for (int j = 0; j < colDim; ++j) {
                out.setEntry(i, j, 1.0 / m1.getEntry(i, j));
            }
        }
        return out;
    }

    public static double dotProduct(double[] w, double[] x) {
        ArrayRealVector a = new ArrayRealVector(w, false);
        ArrayRealVector b = new ArrayRealVector(x, false);
        return a.dotProduct((RealVector)b);
    }

    public static double decibelToRatio(double db) {
        return Math.pow(10.0, db / 20.0);
    }

    public static double decibelToRatio(double db, boolean using_amplitude) {
        double ratio = using_amplitude ? Math.pow(10.0, db / 20.0) : Math.pow(10.0, db / 10.0);
        return ratio;
    }

    public static Double ratioToDecibels(double ratio) {
        if (ratio == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 20.0 * UtilMethods.log(ratio, 10);
    }

    public static Double ratioToDecibels(double ratio, boolean using_amplitude) {
        Double decibels = 0.0;
        decibels = ratio == 0.0 ? Double.valueOf(Double.POSITIVE_INFINITY) : (using_amplitude ? Double.valueOf(20.0 * UtilMethods.log(ratio, 10)) : Double.valueOf(10.0 * UtilMethods.log(ratio, 10)));
        return decibels;
    }

    public static boolean integerToBoolean(int value) {
        return value != 0;
    }
}

