/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.Deconvolution;
import java.security.InvalidParameterException;
import org.apache.commons.math3.complex.Complex;

public class ComplexDeconvolution {
    public double[] signal;
    public Complex[] complexSignal;
    public double[] kernel;
    public Complex[] complexKernel;
    public Complex[] convolutionOutput;
    public boolean complex;

    public ComplexDeconvolution(Complex[] signal, double[] window) {
        this.convolutionOutput = signal;
        this.kernel = window;
        this.complex = true;
    }

    public ComplexDeconvolution(Complex[] signal, Complex[] window) {
        this.convolutionOutput = signal;
        this.complexKernel = window;
        this.complex = false;
    }

    private void deconvolve2Complex(String mode) {
        double[][] out = UtilMethods.transpose(UtilMethods.complexTo2D(this.convolutionOutput));
        double[] window = this.kernel;
        Deconvolution d1 = new Deconvolution(out[0], window);
        Deconvolution d2 = new Deconvolution(out[1], window);
        Object sig = new double[][]{d1.deconvolve(mode), d2.deconvolve(mode)};
        sig = UtilMethods.transpose(sig);
        this.complexSignal = UtilMethods.matToComplex(sig);
    }

    private void deconvolve2Double(String mode) {
        double[][] out = UtilMethods.transpose(UtilMethods.complexTo2D(this.convolutionOutput));
        double[][] window = UtilMethods.transpose(UtilMethods.complexTo2D(this.complexKernel));
        Deconvolution d1 = new Deconvolution(out[0], window[0]);
        this.signal = d1.deconvolve(mode);
    }

    public void deconvolve(String mode) {
        if (this.complexKernel != null) {
            this.deconvolve2Double(mode);
        } else if (this.kernel != null) {
            this.deconvolve2Complex(mode);
        } else {
            throw new ExceptionInInitializerError("Either signal is complex & kernel is real, or signal is real & kernel is complex.");
        }
    }

    public double[] getRealOutput() {
        if (this.complex) {
            throw new InvalidParameterException("The signal generated is complex. Please use getComplexOutput().");
        }
        if (this.signal == null) {
            throw new ExceptionInInitializerError("Execute deconvolve() function before returning result");
        }
        return this.signal;
    }

    public Complex[] getComplexOutput() {
        if (!this.complex) {
            throw new InvalidParameterException("The signal generated is real. Please use getRealOutput().");
        }
        if (this.complexSignal == null) {
            throw new ExceptionInInitializerError("Execute deconvolve() function before returning result");
        }
        return this.complexSignal;
    }
}

