/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.MathArrays;

public class Generate {
    private int Fs;
    private double[] time;

    public Generate() {
    }

    public Generate(int start, int stop, int samplingFreq) {
        this.Fs = samplingFreq;
        this.time = UtilMethods.linspace(start, stop, (stop - start) * samplingFreq, true);
    }

    public double[] getTimeArray() {
        return this.time;
    }

    public double[] generateSineWave(int waveFreq) {
        double[] sine = new double[this.time.length];
        for (int i = 0; i < this.time.length; ++i) {
            double temp = Math.PI * 2 * (double)waveFreq * this.time[i];
            sine[i] = Math.sin(temp);
        }
        return sine;
    }

    public double[] generateCosineWave(int waveFreq) {
        double[] cosine = new double[this.time.length];
        for (int i = 0; i < this.time.length; ++i) {
            double temp = Math.PI * 2 * (double)waveFreq * this.time[i];
            cosine[i] = Math.cos(temp);
        }
        return cosine;
    }

    public double[] generateSquareWave(int waveFreq) {
        double[] square = new double[this.time.length];
        for (int i = 0; i < this.time.length; ++i) {
            double temp = Math.PI * 2 * (double)waveFreq * this.time[i];
            square[i] = Math.signum(Math.sin(temp));
            if (!(Math.abs(Math.sin(temp)) - 0.0 < 1.0E-6)) continue;
            square[i] = 1.0;
        }
        return square;
    }

    public double[][] generateGaussianPulse(int centralFreq) {
        double bw = 0.5;
        double bwr = -6.0;
        double ref = Math.pow(10.0, bwr / 20.0);
        double a = Math.pow(Math.PI * (double)centralFreq * bw, 2.0) * -1.0 / (4.0 * Math.log(ref));
        double[] gauss_env = new double[this.time.length];
        double[] gauss_pulse = new double[this.time.length];
        for (int i = 0; i < this.time.length; ++i) {
            gauss_env[i] = Math.exp(-a * this.time[i] * this.time[i]);
            gauss_pulse[i] = gauss_env[i] * Math.cos(Math.PI * 2 * (double)centralFreq * this.time[i]);
        }
        return new double[][]{gauss_pulse, gauss_env};
    }

    public double[] generateUnitImpulse(double time) {
        int index = (int)(time * (double)this.Fs);
        if (index >= this.time.length) {
            throw new IllegalArgumentException("Time must not be more than time length");
        }
        double[] imp = new double[this.time.length];
        Arrays.fill(imp, 0.0);
        imp[index] = 1.0;
        return imp;
    }

    public double[] generateSawtooth(int waveFreq, double width) {
        int i;
        int i2;
        if (width < 0.0 || width > 1.0) {
            throw new IllegalArgumentException("Width must be between 0 and 1");
        }
        double[] sawtooth = new double[this.time.length];
        double[] t = new double[this.time.length];
        double[] tmod = new double[this.time.length];
        for (int i3 = 0; i3 < this.time.length; ++i3) {
            t[i3] = Math.PI * 2 * (double)waveFreq * this.time[i3];
            tmod[i3] = UtilMethods.modulo(t[i3], Math.PI * 2);
        }
        double[] w = new double[this.time.length];
        Arrays.fill(w, width);
        boolean[] mask2 = new boolean[this.time.length];
        double threshold = width * 2.0 * Math.PI;
        for (i2 = 0; i2 < mask2.length; ++i2) {
            mask2[i2] = tmod[i2] < threshold;
        }
        for (i2 = 0; i2 < sawtooth.length; ++i2) {
            if (!mask2[i2]) continue;
            sawtooth[i2] = tmod[i2] / (Math.PI * w[i2]) - 1.0;
        }
        boolean[] mask3 = new boolean[this.time.length];
        for (i = 0; i < mask3.length; ++i) {
            mask3[i] = !mask2[i];
        }
        for (i = 0; i < sawtooth.length; ++i) {
            if (!mask3[i]) continue;
            sawtooth[i] = (Math.PI * (w[i] + 1.0) - tmod[i]) / (Math.PI * (1.0 - w[i]));
        }
        return sawtooth;
    }

    public double[] generateRicker(int points, double width) {
        double A = 2.0 / (Math.sqrt(3.0 * width) * Math.pow(Math.PI, 0.25));
        double wsq = Math.pow(width, 2.0);
        double[] vec = UtilMethods.arange(0.0, (double)points, 1.0);
        vec = UtilMethods.scalarArithmetic(vec, (double)(points - 1) / 2.0, "sub");
        vec = UtilMethods.scalarArithmetic(vec, 2.0, "pow");
        double[] mod = UtilMethods.scalarArithmetic(vec, wsq, "div");
        mod = UtilMethods.scalarArithmetic(mod, 1.0, "reverse_sub");
        double[] gauss = UtilMethods.scalarArithmetic(vec, 2.0 * wsq, "div");
        for (int i = 0; i < gauss.length; ++i) {
            gauss[i] = Math.exp(0.0 - gauss[i]);
        }
        double[] out = MathArrays.ebeMultiply((double[])mod, (double[])gauss);
        return UtilMethods.scalarArithmetic(out, A, "mul");
    }

    public Complex[] generateMorletComplex(int points, double omega0, double scale) {
        double[] x = UtilMethods.linspace(-scale * 2.0 * Math.PI, 2.0 * scale * Math.PI, points, true);
        Complex[] output = new Complex[points];
        for (int i = 0; i < points; ++i) {
            Complex temp1 = new Complex(0.0, omega0 * x[i]);
            temp1 = temp1.exp();
            Complex temp2 = new Complex(-0.5 * Math.pow(omega0, 2.0), 0.0);
            temp2 = temp2.exp();
            temp1 = temp1.subtract(temp2);
            output[i] = temp1 = temp1.multiply(Math.exp(-0.5 * Math.pow(x[i], 2.0)) * Math.pow(Math.PI, -0.25));
        }
        return output;
    }

    public double[][] generateMorlet(int points, double omega0, double scale) {
        Complex[] temp = this.generateMorletComplex(points, omega0, scale);
        return UtilMethods.complexTo2D(temp);
    }

    public Complex[] generateMorletCWTComplex(int points, double omega0, double width) {
        double[] x = UtilMethods.arange(0.0, (double)points, 1.0);
        double sub_const = (double)(points - 1) / 2.0;
        double pi_root_root = Math.pow(Math.PI, -0.25);
        double width_sqrt = Math.pow(1.0 / width, 0.5);
        for (int i = 0; i < x.length; ++i) {
            x[i] = (x[i] - sub_const) / width;
        }
        Complex[] output = new Complex[points];
        for (int i = 0; i < points; ++i) {
            Complex temp1 = new Complex(0.0, omega0 * x[i]);
            temp1 = temp1.exp();
            Complex temp2 = new Complex(-0.5 * Math.pow(x[i], 2.0), 0.0);
            temp2 = temp2.exp();
            temp1 = temp1.multiply(temp2);
            temp1 = temp1.multiply(pi_root_root);
            output[i] = temp1.multiply(width_sqrt);
        }
        return output;
    }

    public double[][] generateMorletCWT(int points, double omega0, double width) {
        Complex[] temp = this.generateMorletCWTComplex(points, omega0, width);
        return UtilMethods.complexTo2D(temp);
    }

    public Complex[] generatePaulComplex(int order, double width) {
        double M = width * 10.0;
        double[] x = UtilMethods.arange((-M + 1.0) / 2.0, (M + 1.0) / 2.0, 1.0);
        Complex mul_const = new Complex(0.0, 1.0);
        mul_const = mul_const.pow((double)order).multiply((double)CombinatoricsUtils.factorial((int)order));
        mul_const = mul_const.multiply(Math.pow(2.0, order));
        mul_const = mul_const.divide(Math.pow(Math.PI * (double)CombinatoricsUtils.factorial((int)(2 * order)), 0.5));
        Complex[] output = new Complex[x.length];
        for (int i = 0; i < output.length; ++i) {
            Complex func_form = new Complex(1.0, -1.0 * x[i]);
            func_form = func_form.pow((double)(-(order + 1)));
            output[i] = mul_const.multiply(func_form);
        }
        return output;
    }

    public Complex[] generatePaulComplex(int order, double width, double scale) {
        double M = width * 10.0;
        double[] x = UtilMethods.arange((-M + 1.0) / 2.0, (M + 1.0) / 2.0, 1.0);
        for (int i = 0; i < x.length; ++i) {
            x[i] = x[i] / scale;
        }
        Complex mul_const = new Complex(0.0, 1.0);
        mul_const = mul_const.pow((double)order).multiply((double)CombinatoricsUtils.factorial((int)order));
        mul_const = mul_const.multiply(Math.pow(2.0, order));
        mul_const = mul_const.divide(Math.pow(Math.PI * (double)CombinatoricsUtils.factorial((int)(2 * order)), 0.5));
        Complex[] output = new Complex[x.length];
        for (int i = 0; i < output.length; ++i) {
            Complex func_form = new Complex(1.0, -1.0 * x[i]);
            func_form = func_form.pow((double)(-(order + 1)));
            output[i] = mul_const.multiply(func_form);
        }
        return output;
    }

    public double[][] generatePaul(int order, double width) {
        Complex[] temp = this.generatePaulComplex(order, width);
        return UtilMethods.complexTo2D(temp);
    }

    public double[] generateChirp(double startFreq, double endFreq, double phi0) {
        double[] out = new double[this.time.length];
        double T = this.time[this.time.length - 1] - this.time[0];
        double c = (endFreq - startFreq) / T;
        for (int i = 0; i < out.length; ++i) {
            out[i] = Math.sin(phi0 + Math.PI * 2 * (c / 2.0 * Math.pow(this.time[i], 2.0) + startFreq * this.time[i]));
        }
        return out;
    }

    public double[] generateChirp(double startFreq, double endFreq) {
        return this.generateChirp(startFreq, endFreq, 0.0);
    }
}

