/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal.peaks;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Peak {
    private double[] signal;
    private int[] midpoints;
    private double[] height;
    private int[] plateau_size;
    private int[] distance = null;
    private double[][] sharpness = null;
    private double[][] prominenceData = null;
    private double[][] widthData = null;
    private double[] width;
    private double[] prominence;
    private double relative_height;

    public Peak(double[] s, int[] m, int[] l, int[] r, String mode) {
        this.signal = s;
        this.midpoints = m;
        this.height = new double[m.length];
        this.plateau_size = new int[m.length];
        for (int i = 0; i < m.length; ++i) {
            if (mode.equals("peak")) {
                this.height[i] = s[this.midpoints[i]];
            } else if (mode.equals("trough")) {
                this.height[i] = 0.0 - s[this.midpoints[i]];
            }
            this.plateau_size[i] = Math.abs(r[i] - l[i] + 1);
        }
        this.distance = this.findPeakDistance(this.midpoints);
        this.sharpness = this.findPeakSharpness(this.midpoints);
        this.prominenceData = this.findPeakProminence(this.midpoints);
        this.prominence = this.prominenceData[0];
        this.relative_height = 0.5;
        this.widthData = this.findPeakWidth(this.midpoints, this.relative_height);
        this.width = this.widthData[0];
    }

    public Peak(double[] s, int[] m, int[] l, int[] r, double rel_height, String mode) {
        this.signal = s;
        this.midpoints = m;
        this.height = new double[m.length];
        this.plateau_size = new int[m.length];
        for (int i = 0; i < m.length; ++i) {
            if (mode.equals("peak")) {
                this.height[i] = s[this.midpoints[i]];
            } else if (mode.equals("trough")) {
                this.height[i] = 0.0 - s[this.midpoints[i]];
            }
            this.plateau_size[i] = Math.abs(r[i] - l[i] + 1);
        }
        this.distance = this.findPeakDistance(this.midpoints);
        this.sharpness = this.findPeakSharpness(this.midpoints);
        this.prominenceData = this.findPeakProminence(this.midpoints);
        this.prominence = this.prominenceData[0];
        this.relative_height = 0.5;
        this.widthData = this.findPeakWidth(this.midpoints, this.relative_height);
        this.width = this.widthData[0];
    }

    private int[] getIndexFromPeak(int[] peaks) {
        int[] indices = new int[peaks.length];
        int indexCounter = 0;
        int i = 0;
        int j = 0;
        while (i < this.midpoints.length && j < peaks.length) {
            if (this.midpoints[i] == peaks[j]) {
                indices[j] = i++;
                ++indexCounter;
                ++j;
                continue;
            }
            ++i;
        }
        if (indexCounter != peaks.length) {
            throw new IllegalArgumentException("Peaks in argument does not exist in the original peak list");
        }
        return indices;
    }

    public double[] findPeakHeights(int[] peaks) {
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            this.getIndexFromPeak(peaks);
        } else {
            peaks = this.midpoints;
        }
        double[] newHeight = new double[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            newHeight[i] = this.signal[peaks[i]];
        }
        return newHeight;
    }

    public int[] findPlateauSize(int[] peaks) {
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            this.getIndexFromPeak(peaks);
        } else {
            peaks = this.midpoints;
        }
        int[] peak_indices = this.getIndexFromPeak(peaks);
        int[] newPS = new int[peaks.length];
        for (int i = 0; i < peak_indices.length; ++i) {
            newPS[i] = this.plateau_size[peak_indices[i]];
        }
        return newPS;
    }

    public double[][] findPeakSharpness(int[] peaks) {
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            this.getIndexFromPeak(peaks);
        } else {
            peaks = this.midpoints;
        }
        double[][] sharpness = new double[2][peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            sharpness[0][i] = this.signal[peaks[i]] - this.signal[peaks[i] - 1];
            sharpness[1][i] = this.signal[peaks[i]] - this.signal[peaks[i] + 1];
        }
        return sharpness;
    }

    public int[] findPeakDistance(int[] peaks) {
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            this.getIndexFromPeak(peaks);
        } else {
            peaks = this.midpoints;
        }
        return UtilMethods.diff(peaks);
    }

    public double[][] findPeakProminence(int[] peaks) {
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            this.getIndexFromPeak(peaks);
        } else {
            peaks = this.midpoints;
        }
        double[] prominence = new double[peaks.length];
        double[] left_base = new double[peaks.length];
        double[] right_base = new double[peaks.length];
        HashMap<Integer, ProminenceCalculationData> pcd = new HashMap<Integer, ProminenceCalculationData>();
        int signalIndex = 0;
        for (int peakIndex = 0; signalIndex < this.signal.length && peakIndex < peaks.length; ++peakIndex) {
            int nextSignalIndex;
            int minLeftIndex = nextSignalIndex = peaks[peakIndex];
            double minLeft = this.signal[nextSignalIndex];
            for (int i = nextSignalIndex - 1; i >= signalIndex; --i) {
                if (!(this.signal[i] < minLeft)) continue;
                minLeft = this.signal[i];
                minLeftIndex = i;
            }
            int minRightIndex = nextSignalIndex;
            double minRight = this.signal[nextSignalIndex];
            int lastRightIndex = peakIndex + 1 < peaks.length ? peaks[peakIndex + 1] : this.signal.length - 1;
            for (int i = nextSignalIndex + 1; i <= lastRightIndex; ++i) {
                if (!(this.signal[i] < minRight)) continue;
                minRight = this.signal[i];
                minRightIndex = i;
            }
            double th = this.signal[peaks[peakIndex]];
            pcd.put(peakIndex, new ProminenceCalculationData(minLeftIndex, minRightIndex, minLeft, minRight, th));
            signalIndex = nextSignalIndex;
        }
        for (int ref = 0; ref < pcd.size(); ++ref) {
            int finalRef = ref;
            double thRef = ((ProminenceCalculationData)pcd.get((Object)Integer.valueOf((int)finalRef))).threshold;
            ProminenceCalculationData relativeLeftProminence = (ProminenceCalculationData)pcd.get(ref);
            for (int i = ref - 1; i >= 0 && !(((ProminenceCalculationData)pcd.get((Object)Integer.valueOf((int)i))).threshold >= thRef); --i) {
                if (!(((ProminenceCalculationData)pcd.get((Object)Integer.valueOf((int)i))).minLeft < relativeLeftProminence.minLeft)) continue;
                relativeLeftProminence = (ProminenceCalculationData)pcd.get(i);
            }
            ProminenceCalculationData relativeRightProminence = (ProminenceCalculationData)pcd.get(ref);
            for (int i = ref + 1; i < pcd.size() && !(((ProminenceCalculationData)pcd.get((Object)Integer.valueOf((int)i))).threshold >= thRef); ++i) {
                if (!(((ProminenceCalculationData)pcd.get((Object)Integer.valueOf((int)i))).minRight < relativeRightProminence.minRight)) continue;
                relativeRightProminence = (ProminenceCalculationData)pcd.get(i);
            }
            left_base[finalRef] = relativeLeftProminence.minLeftIndex;
            right_base[finalRef] = relativeRightProminence.minRightIndex;
            prominence[finalRef] = Math.min(thRef - relativeLeftProminence.minLeft, thRef - relativeRightProminence.minRight);
        }
        double[][] promData = new double[3][peaks.length];
        promData[0] = prominence;
        promData[1] = left_base;
        promData[2] = right_base;
        return promData;
    }

    public double[][] findPeakWidth(int[] peaks, double rel_height) throws IllegalArgumentException {
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            this.getIndexFromPeak(peaks);
        } else {
            peaks = this.midpoints;
        }
        if (rel_height > 1.0 || rel_height < 0.0) {
            throw new IllegalArgumentException("rel_height can be between 0.0 and 1.0");
        }
        double[] width = new double[peaks.length];
        double[][] promData = this.prominenceData;
        double[] prominence = promData[0];
        double[] left_bases = promData[1];
        double[] right_bases = promData[2];
        double[] widthHeight = new double[peaks.length];
        double[] leftIntersectPoint = new double[peaks.length];
        double[] rightIntersectPoint = new double[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            widthHeight[i] = this.signal[peaks[i]] - prominence[i] * rel_height;
            int j = peaks[i];
            while (left_bases[i] < (double)j && widthHeight[i] < this.signal[j]) {
                --j;
            }
            leftIntersectPoint[i] = j;
            if (this.signal[j] < widthHeight[i]) {
                int n = i;
                leftIntersectPoint[n] = leftIntersectPoint[n] + (widthHeight[i] - this.signal[j]) / (this.signal[j + 1] - this.signal[j]);
            }
            j = peaks[i];
            while ((double)j < right_bases[i] && widthHeight[i] < this.signal[j]) {
                ++j;
            }
            rightIntersectPoint[i] = j;
            if (this.signal[j] < widthHeight[i]) {
                int n = i;
                rightIntersectPoint[n] = rightIntersectPoint[n] - (widthHeight[i] - this.signal[j]) / (this.signal[j - 1] - this.signal[j]);
            }
            width[i] = rightIntersectPoint[i] - leftIntersectPoint[i];
        }
        double[][] wData = new double[4][peaks.length];
        wData[0] = width;
        wData[1] = widthHeight;
        wData[2] = leftIntersectPoint;
        wData[3] = rightIntersectPoint;
        return wData;
    }

    public int[] getPeaks() {
        return this.midpoints;
    }

    public double[] getHeights() {
        return this.height;
    }

    public double[][] getPeakSharpness() {
        return this.sharpness;
    }

    public int[] getPlateauSize() {
        return this.plateau_size;
    }

    public int[] getPeakDistance() {
        return this.distance;
    }

    public double[] getWidth() {
        return this.width;
    }

    public double[][] getWidthData() {
        return this.widthData;
    }

    public double[] getProminence() {
        return this.prominence;
    }

    public double[][] getProminenceData() {
        return this.prominenceData;
    }

    public int[] filterByHeight(Double lower_threshold, Double upper_threshold) {
        return this.filterByHeight(this.midpoints, lower_threshold, upper_threshold);
    }

    public int[] filterByHeight(int[] peaks, Double lower_threshold, Double upper_threshold) {
        int i;
        ArrayList<Integer> newPeaks = new ArrayList<Integer>();
        double[] height = new double[peaks.length];
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            int[] indices = this.getIndexFromPeak(peaks);
            for (i = 0; i < indices.length; ++i) {
                height[i] = this.height[indices[i]];
            }
        } else {
            peaks = this.midpoints;
            height = this.height;
        }
        if (lower_threshold == null && upper_threshold == null) {
            throw new IllegalArgumentException("All thresholds cannot be null");
        }
        if (lower_threshold != null && upper_threshold == null) {
            for (i = 0; i < height.length; ++i) {
                if (!(height[i] >= lower_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else if (lower_threshold == null && upper_threshold != null) {
            for (i = 0; i < height.length; ++i) {
                if (!(height[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else {
            for (i = 0; i < height.length; ++i) {
                if (!(height[i] >= lower_threshold) || !(height[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        }
        return UtilMethods.convertToPrimitiveInt(newPeaks);
    }

    public int[] filterByPlateauSize(Double lower_threshold, Double upper_threshold) {
        return this.filterByPlateauSize(this.midpoints, lower_threshold, upper_threshold);
    }

    public int[] filterByPlateauSize(int[] peaks, Double lower_threshold, Double upper_threshold) {
        int i;
        ArrayList<Integer> newPeaks = new ArrayList<Integer>();
        int[] plateau_size = new int[peaks.length];
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            int[] indices = this.getIndexFromPeak(peaks);
            for (i = 0; i < indices.length; ++i) {
                plateau_size[i] = this.plateau_size[indices[i]];
            }
        } else {
            peaks = this.midpoints;
            plateau_size = this.plateau_size;
        }
        if (lower_threshold == null && upper_threshold == null) {
            throw new IllegalArgumentException("All thresholds cannot be null");
        }
        if (lower_threshold != null && upper_threshold == null) {
            for (i = 0; i < plateau_size.length; ++i) {
                if (!((double)plateau_size[i] >= lower_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else if (lower_threshold == null && upper_threshold != null) {
            for (i = 0; i < plateau_size.length; ++i) {
                if (!((double)plateau_size[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else {
            for (i = 0; i < plateau_size.length; ++i) {
                if (!((double)plateau_size[i] >= lower_threshold) || !((double)plateau_size[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        }
        return UtilMethods.convertToPrimitiveInt(newPeaks);
    }

    public int[] filterByProminence(Double lower_threshold, Double upper_threshold) {
        return this.filterByProminence(this.midpoints, lower_threshold, upper_threshold);
    }

    public int[] filterByProminence(int[] peaks, Double lower_threshold, Double upper_threshold) {
        int i;
        if (this.prominenceData == null) {
            this.getProminenceData();
        }
        ArrayList<Integer> newPeaks = new ArrayList<Integer>();
        double[] prominence = new double[peaks.length];
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            int[] indices = this.getIndexFromPeak(peaks);
            for (i = 0; i < indices.length; ++i) {
                prominence[i] = this.prominenceData[0][indices[i]];
            }
        } else {
            peaks = this.midpoints;
            prominence = this.prominenceData[0];
        }
        if (lower_threshold == null && upper_threshold == null) {
            throw new IllegalArgumentException("All thresholds cannot be null");
        }
        if (lower_threshold != null && upper_threshold == null) {
            for (i = 0; i < prominence.length; ++i) {
                if (!(prominence[i] >= lower_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else if (lower_threshold == null && upper_threshold != null) {
            for (i = 0; i < prominence.length; ++i) {
                if (!(prominence[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else {
            for (i = 0; i < prominence.length; ++i) {
                if (!(prominence[i] >= lower_threshold) || !(prominence[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        }
        return UtilMethods.convertToPrimitiveInt(newPeaks);
    }

    public int[] filterByWidth(Double lower_threshold, Double upper_threshold) {
        return this.filterByWidth(this.midpoints, lower_threshold, upper_threshold);
    }

    public int[] filterByWidth(int[] peaks, Double lower_threshold, Double upper_threshold) {
        int i;
        if (this.widthData == null) {
            this.getWidthData();
        }
        ArrayList<Integer> newPeaks = new ArrayList<Integer>();
        double[] width = new double[peaks.length];
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            int[] indices = this.getIndexFromPeak(peaks);
            for (i = 0; i < indices.length; ++i) {
                width[i] = this.widthData[0][indices[i]];
            }
        } else {
            peaks = this.midpoints;
            width = this.widthData[0];
        }
        if (lower_threshold == null && upper_threshold == null) {
            throw new IllegalArgumentException("All thresholds cannot be null");
        }
        if (lower_threshold != null && upper_threshold == null) {
            for (i = 0; i < width.length; ++i) {
                if (!(width[i] >= lower_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else if (lower_threshold == null && upper_threshold != null) {
            for (i = 0; i < width.length; ++i) {
                if (!(width[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        } else {
            for (i = 0; i < width.length; ++i) {
                if (!(width[i] >= lower_threshold) || !(width[i] <= upper_threshold)) continue;
                newPeaks.add(peaks[i]);
            }
        }
        return UtilMethods.convertToPrimitiveInt(newPeaks);
    }

    public int[] filterByPeakDistance(int distance) {
        return this.filterByPeakDistance(this.midpoints, distance);
    }

    public int[] filterByPeakDistance(int[] peaks, int distance) {
        int[] keep = new int[peaks.length];
        Arrays.fill(keep, 1);
        double[] heights = this.findPeakHeights(peaks);
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            int[] indices = this.getIndexFromPeak(peaks);
            for (int i = 0; i < indices.length; ++i) {
                heights[i] = this.height[indices[i]];
            }
        } else {
            peaks = this.midpoints;
            heights = this.height;
        }
        int[] priority = UtilMethods.argsort(heights, true);
        for (int i = peaks.length - 1; i >= 0; --i) {
            int k;
            int j = priority[i];
            if (keep[j] == 0) continue;
            for (k = j - 1; 0 <= k && peaks[j] - peaks[k] < distance; --k) {
                keep[k] = 0;
            }
            for (k = j + 1; k < peaks.length && peaks[k] - peaks[j] < distance; ++k) {
                keep[k] = 0;
            }
        }
        ArrayList<Integer> newPeaks = new ArrayList<Integer>();
        for (int i = 0; i < keep.length; ++i) {
            if (keep[i] != 1) continue;
            newPeaks.add(peaks[i]);
        }
        return UtilMethods.convertToPrimitiveInt(newPeaks);
    }

    public int[] filterBySharpness(Double lower_threshold, Double upper_threshold) {
        return this.filterBySharpness(this.midpoints, lower_threshold, upper_threshold);
    }

    public int[] filterBySharpness(int[] peaks, Double lower_threshold, Double upper_threshold) {
        double maxVal;
        double minVal;
        int i;
        if (this.sharpness == null) {
            this.getPeakSharpness();
        }
        ArrayList<Integer> newPeaks = new ArrayList<Integer>();
        double[][] sharpness = this.sharpness;
        int[] keep = new int[peaks.length];
        Arrays.fill(keep, 1);
        if (!Arrays.equals(this.midpoints, peaks)) {
            Arrays.sort(peaks);
            int[] indices = this.getIndexFromPeak(peaks);
            for (i = 0; i < indices.length; ++i) {
                sharpness[0][i] = this.sharpness[0][indices[i]];
                sharpness[1][i] = this.sharpness[1][indices[i]];
            }
        } else {
            peaks = this.midpoints;
            sharpness = this.sharpness;
        }
        if (lower_threshold == null && upper_threshold == null) {
            throw new IllegalArgumentException("All thresholds cannot be null");
        }
        if (lower_threshold != null && upper_threshold == null) {
            for (i = 0; i < sharpness[0].length; ++i) {
                minVal = Math.min(sharpness[0][i], sharpness[1][i]);
                if (!(minVal < lower_threshold)) continue;
                keep[i] = 0;
            }
        } else if (lower_threshold == null && upper_threshold != null) {
            for (i = 0; i < sharpness[0].length; ++i) {
                maxVal = Math.max(sharpness[0][i], sharpness[1][i]);
                if (!(maxVal > upper_threshold)) continue;
                keep[i] = 0;
            }
        } else {
            for (i = 0; i < sharpness[0].length; ++i) {
                minVal = Math.min(sharpness[0][i], sharpness[1][i]);
                if (!(minVal < lower_threshold)) continue;
                keep[i] = 0;
            }
            for (i = 0; i < sharpness[0].length; ++i) {
                maxVal = Math.max(sharpness[0][i], sharpness[1][i]);
                if (!(maxVal > upper_threshold)) continue;
                keep[i] = 0;
            }
        }
        for (i = 0; i < keep.length; ++i) {
            if (keep[i] != 1) continue;
            newPeaks.add(peaks[i]);
        }
        return UtilMethods.convertToPrimitiveInt(newPeaks);
    }

    private class ProminenceCalculationData {
        final int minLeftIndex;
        final int minRightIndex;
        final double minLeft;
        final double minRight;
        final double threshold;

        public ProminenceCalculationData(int minLeftIndex, int minRightIndex, double minLeft, double minRight, double threshold) {
            this.minLeftIndex = minLeftIndex;
            this.minRightIndex = minRightIndex;
            this.minLeft = minLeft;
            this.minRight = minRight;
            this.threshold = threshold;
        }
    }
}

