/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.splines;

import com.github.psambit9791.jdsp.misc.UtilMethods;

public class BSpline {
    private int order;
    private double xMin;
    private double xMax;
    private umontreal.ssj.functionfit.BSpline psf;

    public BSpline(int order) {
        if (order < 2 || order > 5) {
            throw new IllegalArgumentException("Order must be between 2 and 5");
        }
        this.order = order;
        this.psf = null;
    }

    public umontreal.ssj.functionfit.BSpline getFunction() {
        if (this.psf == null) {
            throw new ExceptionInInitializerError("Execute computeFunction() before calling this function");
        }
        return this.psf;
    }

    public void computeFunction(double[] x, double[] y) {
        if (!UtilMethods.isSorted(x, false)) {
            throw new IllegalArgumentException("X-coordinates must be increasing");
        }
        this.xMin = x[0];
        this.xMax = x[x.length - 1];
        this.psf = new umontreal.ssj.functionfit.BSpline(x, y, this.order);
    }

    private boolean isValidPoint(double val) {
        return val <= this.xMax && val >= this.xMin;
    }

    public double getValue(double x) {
        if (this.psf == null) {
            throw new ExceptionInInitializerError("Execute computeFunction() before calling this function");
        }
        if (!this.isValidPoint(x)) {
            throw new IllegalArgumentException("Point has to be within the interpolating range");
        }
        return this.psf.evaluate(x);
    }

    public double[] getValue(double[] x) {
        if (this.psf == null) {
            throw new ExceptionInInitializerError("Execute computeFunction() before calling this function");
        }
        double[] out = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            if (!this.isValidPoint(x[i])) {
                throw new IllegalArgumentException("Point at index " + i + "has to be within the interpolating range");
            }
            out[i] = this.psf.evaluate(x[i]);
        }
        return out;
    }
}

