/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.transform.DiscreteCosine;
import com.github.psambit9791.jdsp.transform._InverseSineCosine;
import com.github.psambit9791.jdsp.transform._SineCosine;

public class InverseDiscreteCosine
implements _InverseSineCosine {
    private double[] signal;
    private double[] output = null;
    private int type;
    private _InverseSineCosine.Normalization norm;

    private int inferType(int t) {
        int inf = 0;
        if (t == 1 || t == 4) {
            inf = t;
        } else if (t == 2) {
            inf = 3;
        } else if (t == 3) {
            inf = 2;
        }
        return inf;
    }

    public InverseDiscreteCosine(double[] s, int type, _InverseSineCosine.Normalization norm) throws IllegalArgumentException {
        if (type <= 0 || type > 4) {
            throw new IllegalArgumentException("Type must be between 1 and 4");
        }
        this.signal = s;
        this.type = this.inferType(type);
        this.norm = norm;
    }

    public InverseDiscreteCosine(double[] s, _InverseSineCosine.Normalization norm) {
        this.signal = s;
        this.type = this.inferType(2);
        this.norm = norm;
    }

    public InverseDiscreteCosine(double[] s, int type) throws IllegalArgumentException {
        if (type <= 0 || type > 4) {
            throw new IllegalArgumentException("Type must be between 1 and 4");
        }
        this.signal = s;
        this.type = this.inferType(type);
        this.norm = _InverseSineCosine.Normalization.STANDARD;
    }

    public InverseDiscreteCosine(double[] s) {
        this.signal = s;
        this.type = this.inferType(2);
        this.norm = _InverseSineCosine.Normalization.STANDARD;
    }

    @Override
    public void transform() {
        DiscreteCosine dct = this.norm == _InverseSineCosine.Normalization.STANDARD ? new DiscreteCosine(this.signal, this.type, _SineCosine.Normalization.STANDARD) : new DiscreteCosine(this.signal, this.type, _SineCosine.Normalization.ORTHOGONAL);
        dct.transform();
        this.output = dct.getMagnitude();
    }

    @Override
    public double[] getMagnitude() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        return this.output;
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }
}

