/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform._InverseSineCosine;
import org.apache.commons.math3.transform.DctNormalization;
import org.apache.commons.math3.transform.FastCosineTransformer;
import org.apache.commons.math3.transform.TransformType;

public class InverseFastCosine
implements _InverseSineCosine {
    private double[] signal;
    private double[] output;
    private FastCosineTransformer fct;

    private void extendSignal() {
        double power = Math.log(this.signal.length - 1) / Math.log(2.0);
        double raised_power = Math.ceil(power);
        int new_length = (int)Math.pow(2.0, raised_power) + 1;
        if (new_length != this.signal.length) {
            this.signal = UtilMethods.zeroPadSignal(this.signal, new_length - this.signal.length);
        }
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }

    public InverseFastCosine(double[] signal) {
        this.signal = signal;
        this.extendSignal();
        this.fct = new FastCosineTransformer(DctNormalization.STANDARD_DCT_I);
    }

    public InverseFastCosine(double[] signal, _InverseSineCosine.Normalization norm) {
        this.signal = signal;
        this.extendSignal();
        this.fct = norm == _InverseSineCosine.Normalization.ORTHOGONAL ? new FastCosineTransformer(DctNormalization.ORTHOGONAL_DCT_I) : new FastCosineTransformer(DctNormalization.STANDARD_DCT_I);
    }

    @Override
    public void transform() {
        this.output = this.fct.transform(this.signal, TransformType.INVERSE);
    }

    @Override
    public double[] getMagnitude() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        return this.output;
    }
}

