/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform.InverseDiscreteFourier;
import com.github.psambit9791.jdsp.transform.InverseFastFourier;
import com.github.psambit9791.jdsp.transform._Fourier;
import com.github.psambit9791.jdsp.transform._InverseFourier;
import com.github.psambit9791.jdsp.windows.Rectangular;
import com.github.psambit9791.jdsp.windows._Window;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;

public class InverseShortTimeFourier {
    private final _Fourier[] signal;
    private final int overlap;
    private final int frameLength;
    private final _Window window;
    private Complex[] output;

    public InverseShortTimeFourier(_Fourier[] signal, int frameLength, int overlap, _Window window) {
        if (signal == null) {
            throw new IllegalArgumentException("Signal can not be null");
        }
        if (frameLength > signal[0].getComplex(false).length) {
            throw new IllegalArgumentException("Frame length can not be larger than signal Fourier length");
        }
        if (overlap >= frameLength) {
            throw new IllegalArgumentException("Overlap must be smaller than frame length");
        }
        if (window == null) {
            throw new IllegalArgumentException("Window can not be null");
        }
        if (window.getWindow().length != frameLength) {
            throw new IllegalArgumentException("Window and frame dimensions must match");
        }
        this.signal = signal;
        this.frameLength = frameLength;
        this.overlap = overlap;
        this.window = window;
    }

    public InverseShortTimeFourier(_Fourier[] signal, int frameLength, int overlap) {
        this(signal, frameLength, overlap, new Rectangular(frameLength));
    }

    public InverseShortTimeFourier(_Fourier[] signal, int frameLength) {
        this(signal, frameLength, frameLength / 2, new Rectangular(frameLength));
    }

    public InverseShortTimeFourier(_Fourier[] signal) {
        this(signal, signal[0].getComplex(false).length, signal[0].getComplex(false).length / 2, new Rectangular(signal[0].getComplex(false).length));
    }

    public void transform() {
        int signalLength = (int)Math.floor((this.signal.length - 1) * (this.frameLength - this.overlap) + this.frameLength);
        this.output = new Complex[signalLength];
        int[] averageDivisor = new int[signalLength];
        Arrays.fill(averageDivisor, 1);
        int arrPastePosition = 0;
        boolean dataLost = false;
        for (_Fourier dtft : this.signal) {
            double[][] seq = UtilMethods.complexTo2D(dtft.getComplex(false));
            double logval = Math.log(seq.length) / Math.log(2.0);
            _InverseFourier idft = logval == (double)((int)logval) ? new InverseFastFourier(UtilMethods.matToComplex(seq), false) : new InverseDiscreteFourier(seq, false);
            idft.transform();
            Complex[] idft_result = idft.getComplex();
            for (int i = 0; i < this.frameLength; ++i) {
                double windowVal = this.window.getWindow()[i];
                double real = idft_result[i].getReal();
                double imaginary = idft_result[i].getImaginary();
                if (windowVal != 0.0) {
                    real /= windowVal;
                } else {
                    dataLost = true;
                }
                if (this.output[i + arrPastePosition] != null) {
                    int n = i + arrPastePosition;
                    averageDivisor[n] = averageDivisor[n] + 1;
                    real += this.output[i + arrPastePosition].getReal();
                    imaginary += this.output[i + arrPastePosition].getImaginary();
                }
                this.output[i + arrPastePosition] = new Complex(real, imaginary);
            }
            arrPastePosition += this.frameLength - this.overlap;
        }
        for (int i = 0; i < averageDivisor.length; ++i) {
            if (averageDivisor[i] <= 1) continue;
            double real = this.output[i].getReal() / (double)averageDivisor[i];
            double imaginary = this.output[i].getImaginary() / (double)averageDivisor[i];
            this.output[i] = new Complex(real, imaginary);
        }
        if (dataLost) {
            System.err.println("The original window function contained a zero-element, which causes some of the data to be irretrievably lost.");
        }
    }

    public Complex[] getComplex() throws ExceptionInInitializerError {
        this.checkOutput();
        return this.output;
    }

    public double[][] getComplex2D() throws ExceptionInInitializerError {
        return UtilMethods.complexTo2D(this.getComplex());
    }

    public double[] getReal() throws ExceptionInInitializerError {
        this.checkOutput();
        return Arrays.stream(this.output).mapToDouble(Complex::getReal).toArray();
    }

    public double[] getImaginary() throws ExceptionInInitializerError {
        this.checkOutput();
        return Arrays.stream(this.output).mapToDouble(Complex::getImaginary).toArray();
    }

    public double[] getMagnitude() throws ExceptionInInitializerError {
        this.checkOutput();
        return Arrays.stream(this.output).mapToDouble(Complex::abs).toArray();
    }

    public double[] getPhase() throws ExceptionInInitializerError {
        this.checkOutput();
        return Arrays.stream(this.output).mapToDouble(Complex::getArgument).toArray();
    }

    private void checkOutput() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute istft() function before returning result");
        }
    }
}

