/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows._Window;

public class BartlettHann
extends _Window {
    private double[] window;
    private final boolean sym;
    private final int len;

    public BartlettHann(int len, boolean sym) throws IllegalArgumentException {
        super(len);
        this.len = len;
        this.sym = sym;
        this.generateWindow();
    }

    public BartlettHann(int len) throws IllegalArgumentException {
        this(len, true);
    }

    private void generateWindow() {
        int tempLen = super.extend(this.len, this.sym);
        this.window = UtilMethods.arange(0.0, (double)tempLen, 1.0);
        for (int i = 0; i < this.window.length; ++i) {
            double fac = Math.abs(this.window[i] / (double)(tempLen - 1) - 0.5);
            this.window[i] = 0.62 - 0.48 * fac + 0.38 * Math.cos(Math.PI * 2 * fac);
        }
        this.window = super.truncate(this.window);
    }

    @Override
    public double[] getWindow() {
        return this.window;
    }
}

