/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows._Window;

public class Triangular
extends _Window {
    private double[] window;
    private final boolean sym;
    private final int len;

    public Triangular(int len, boolean sym) throws IllegalArgumentException {
        super(len);
        this.len = len;
        this.sym = sym;
        this.generateWindow();
    }

    public Triangular(int len) throws IllegalArgumentException {
        this(len, true);
    }

    private void generateWindow() {
        int tempLen = super.extend(this.len, this.sym);
        int halfPoint = (tempLen + 1) / 2 + 1;
        double[] n = UtilMethods.arange(1.0, (double)halfPoint, 1.0);
        if (tempLen % 2 == 0) {
            for (int i = 0; i < n.length; ++i) {
                n[i] = (2.0 * n[i] - 1.0) / (double)tempLen;
            }
            double[] nRev = UtilMethods.reverse(n);
            this.window = UtilMethods.concatenateArray(n, nRev);
        } else {
            for (int i = 0; i < n.length; ++i) {
                n[i] = 2.0 * n[i] / (double)(tempLen + 1);
            }
            double[] nRev = UtilMethods.splitByIndex(n, 0, n.length - 1);
            nRev = UtilMethods.reverse(nRev);
            this.window = UtilMethods.concatenateArray(n, nRev);
        }
        this.window = super.truncate(this.window);
    }

    @Override
    public double[] getWindow() {
        return this.window;
    }
}

