/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.lcms;

import fr.proline.core.orm.lcms.IPeakelData;
import fr.proline.core.orm.lcms.Peak;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.MessagePack;
import org.msgpack.annotation.Message;
import org.msgpack.type.Value;

@Message
public class PeakelDataMatrix
implements IPeakelData {
    private List<Long> scanIds;
    private List<Float> elutionTimes;
    private List<Double> mzValues;
    private List<Float> intensityValues;

    public PeakelDataMatrix() {
    }

    public PeakelDataMatrix(List<Long> scanIds, List<Float> elutionTimes, List<Double> mzValues, List<Float> intensityValues) {
        this.scanIds = scanIds;
        this.elutionTimes = elutionTimes;
        this.mzValues = mzValues;
        this.intensityValues = intensityValues;
    }

    @Override
    public List<Long> getScanIds() {
        return this.scanIds;
    }

    public void setScanIds(List<Long> scanIds) {
        this.scanIds = scanIds;
    }

    @Override
    public List<Float> getElutionTimes() {
        return this.elutionTimes;
    }

    public void setElutionTimes(List<Float> elutionTimes) {
        this.elutionTimes = elutionTimes;
    }

    @Override
    public List<Double> getMzValues() {
        return this.mzValues;
    }

    public void setMzValues(List<Double> mzValues) {
        this.mzValues = mzValues;
    }

    @Override
    public List<Float> getIntensityValues() {
        return this.intensityValues;
    }

    public void setIntensityValues(List<Float> intensityValues) {
        this.intensityValues = intensityValues;
    }

    public Peak getPeak(int id) {
        if (id < 0 || id >= this.getNbPeaks()) {
            return null;
        }
        return new Peak(this.scanIds.get(id), this.mzValues.get(id), this.elutionTimes.get(id), this.intensityValues.get(id));
    }

    public int getNbPeaks() {
        return this.mzValues == null ? 0 : this.mzValues.size();
    }

    public static PeakelDataMatrix getPeaks(byte[] blob) throws Exception {
        MessagePack msgpack = new MessagePack();
        Value o = msgpack.read(blob);
        PeakelDataMatrix peakelDataMatrix = new PeakelDataMatrix();
        List so = (List)((List)o).get(0);
        List eo = (List)((List)o).get(1);
        List mo = (List)((List)o).get(2);
        List io = (List)((List)o).get(3);
        ArrayList<Long> scanIds = new ArrayList<Long>();
        int nb = so.size();
        for (int i = 0; i < nb; ++i) {
            scanIds.add(Long.valueOf(so.get(i).toString()));
        }
        ArrayList<Float> elutionTimes = new ArrayList<Float>();
        nb = eo.size();
        for (int i = 0; i < nb; ++i) {
            elutionTimes.add(Float.valueOf(eo.get(i).toString()));
        }
        ArrayList<Double> mzValues = new ArrayList<Double>();
        nb = mo.size();
        for (int i = 0; i < nb; ++i) {
            mzValues.add(Double.valueOf(mo.get(i).toString()));
        }
        ArrayList<Float> intensities = new ArrayList<Float>();
        nb = io.size();
        for (int i = 0; i < nb; ++i) {
            intensities.add(Float.valueOf(io.get(i).toString()));
        }
        peakelDataMatrix.setScanIds(scanIds);
        peakelDataMatrix.setElutionTimes(elutionTimes);
        peakelDataMatrix.setMzValues(mzValues);
        peakelDataMatrix.setIntensityValues(intensities);
        return peakelDataMatrix;
    }
}

