/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.lcms;

import fr.proline.core.orm.lcms.MapTime;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.core.orm.lcms.ProcessedMapMozCalibrationPK;
import fr.proline.core.orm.util.JsonSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="processed_map_moz_calibration")
@NamedQuery(name="ProcessedMapMozCalibration.findAll", query="SELECT p FROM ProcessedMapMozCalibration p")
public class ProcessedMapMozCalibration {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProcessedMapMozCalibration.class);
    @EmbeddedId
    private ProcessedMapMozCalibrationPK id;
    @Column(name="delta_moz_list")
    private String deltaMozList;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="moz_list")
    private String mozList;
    @ManyToOne
    @JoinColumn(name="processed_map_id")
    @MapsId(value="processedMapId")
    private ProcessedMap processedMap;
    @Transient
    private List<MapTime> processedMapMozList;
    @Transient
    private Map<String, Object> serializedPropertiesMap = null;

    public ProcessedMapMozCalibrationPK getId() {
        return this.id;
    }

    public void setId(ProcessedMapMozCalibrationPK id) {
        this.id = id;
    }

    public String getDeltaMozList() {
        return this.deltaMozList;
    }

    public void setDeltaMozList(String deltaMozList) {
        this.deltaMozList = deltaMozList;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public String getMozList() {
        return this.mozList;
    }

    public void setMozList(String mozList) {
        this.mozList = mozList;
    }

    public ProcessedMap getProcessedMap() {
        return this.processedMap;
    }

    public void setProcessedMap(ProcessedMap processedMap) {
        this.processedMap = processedMap;
    }

    public void setProcessedMapMozList(List<MapTime> pmapTimeist) {
        this.processedMapMozList = pmapTimeist;
    }

    public List<MapTime> getProcessedMapMozList() {
        if (this.processedMapMozList == null) {
            try {
                this.processedMapMozList = new ArrayList<MapTime>();
                String[] timeSplited = this.mozList.split(" ");
                String[] deltaMozSplited = this.deltaMozList.split(" ");
                if (timeSplited.length != deltaMozSplited.length) {
                    LOG.error("Error Parsing MoZ List : time and delta moz are different ");
                } else {
                    for (int i = 0; i < timeSplited.length; ++i) {
                        Double time = Double.parseDouble(timeSplited[i]);
                        Double deltaMoz = Double.parseDouble(deltaMozSplited[i]);
                        this.processedMapMozList.add(new MapTime(time, deltaMoz));
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error Parsing processedMapMozList ", (Throwable)e);
                this.processedMapMozList = null;
            }
        }
        return this.processedMapMozList;
    }

    public Map<String, Object> getSerializedPropertiesAsMap() throws Exception {
        if (this.serializedPropertiesMap == null && this.serializedProperties != null) {
            this.serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(this.getSerializedProperties(), Map.class);
        }
        return this.serializedPropertiesMap;
    }
}

