/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import com.fasterxml.jackson.core.type.TypeReference;
import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.msi.MasterQuantComponent;
import fr.proline.core.orm.msi.MasterQuantPeptideIon;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DQuantReporterIon;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="master_quant_reporter_ion")
public class MasterQuantReporterIon
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MapAlignment.class);
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="ms_query_id")
    private long msQueryId;
    @ManyToOne
    @JoinColumn(name="master_quant_component_id")
    private MasterQuantComponent masterQuantComponent;
    @ManyToOne
    @JoinColumn(name="master_quant_peptide_ion_id")
    private MasterQuantPeptideIon masterQuantPeptideIon;
    @ManyToOne
    @JoinColumn(name="result_summary_id")
    private ResultSummary resultSummary;
    @Transient
    private TransientData transientData = null;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public ResultSummary getResultSummary() {
        return this.resultSummary;
    }

    public void setResultSummary(ResultSummary resultSummary) {
        this.resultSummary = resultSummary;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public long getMsQueryId() {
        return this.msQueryId;
    }

    public void setMsQueryId(long pMsQueryId) {
        this.msQueryId = pMsQueryId;
    }

    public MasterQuantComponent getMasterQuantComponent() {
        return this.masterQuantComponent;
    }

    public void setMasterQuantComponent(MasterQuantComponent masterQuantComponent) {
        this.masterQuantComponent = masterQuantComponent;
    }

    public MasterQuantPeptideIon getMasterQuantPeptideIon() {
        return this.masterQuantPeptideIon;
    }

    public void setMasterQuantPeptideIon(MasterQuantPeptideIon masterQuantPeptideIon) {
        this.masterQuantPeptideIon = masterQuantPeptideIon;
    }

    public TransientData getTransientData() {
        if (this.transientData == null) {
            this.transientData = new TransientData();
        }
        return this.transientData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseAnSetQuantReporterIonFromProperties(String quantReporterIonData) {
        HashMap<Long, DQuantReporterIon> quantReporterIonByQchIds = null;
        try {
            List quantReporterIons = (List)JsonSerializer.getMapper().readValue(quantReporterIonData, (TypeReference)new TypeReference<List<DQuantReporterIon>>(){});
            quantReporterIonByQchIds = new HashMap<Long, DQuantReporterIon>();
            if (quantReporterIons != null) {
                for (int i = 0; i < quantReporterIons.size(); ++i) {
                    DQuantReporterIon nextQuantRepIon = (DQuantReporterIon)quantReporterIons.get(i);
                    if (nextQuantRepIon == null) continue;
                    quantReporterIonByQchIds.put(nextQuantRepIon.getQuantChannelId(), nextQuantRepIon);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error Parsing DQuantReporterIon ", (Throwable)e);
            LOG.warn("quantReporterIonData= " + quantReporterIonData);
            quantReporterIonByQchIds = null;
        }
        finally {
            this.getTransientData().setQuantReporterIonByQchIds(quantReporterIonByQchIds);
        }
    }

    public static class TransientData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DPeptideMatch peptideMatch;
        private DMasterQuantPeptideIon masterQuantPeptideIon;
        private Map<Long, DQuantReporterIon> quantReporterIonByQchIds = null;

        public DMasterQuantPeptideIon getDMasterQuantPeptideIon() {
            return this.masterQuantPeptideIon;
        }

        public void setDMasterQuantPeptideIon(DMasterQuantPeptideIon masterQuantPeptideIon) {
            this.masterQuantPeptideIon = masterQuantPeptideIon;
        }

        public DPeptideMatch getPeptideMatch() {
            return this.peptideMatch;
        }

        public void setPeptideMatch(DPeptideMatch peptideMatch) {
            this.peptideMatch = peptideMatch;
        }

        public Map<Long, DQuantReporterIon> getQuantReporterIonByQchIds() {
            return this.quantReporterIonByQchIds;
        }

        public void setQuantReporterIonByQchIds(Map<Long, DQuantReporterIon> quantReporterIonByQchIds) {
            this.quantReporterIonByQchIds = quantReporterIonByQchIds;
        }
    }
}

