/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.ProteinSetProteinMatchItem;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="protein_set")
public class ProteinSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="is_decoy")
    private boolean isDecoy;
    @Column(name="is_validated")
    private boolean isValidated;
    @Column(name="master_quant_component_id")
    private Long masterQuantComponentId;
    @ManyToOne
    @JoinColumn(name="result_summary_id")
    private ResultSummary resultSummary;
    @Column(name="selection_level")
    private int selectionLevel;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="representative_protein_match_id")
    private long representativeProteinMatchId;
    @OneToMany(mappedBy="proteinSet")
    private Set<ProteinSetProteinMatchItem> proteinSetProteinMatchItems;
    @ElementCollection
    @MapKeyColumn(name="schema_name")
    @Column(name="object_tree_id")
    @CollectionTable(name="protein_set_object_tree_map", joinColumns={@JoinColumn(name="protein_set_id", referencedColumnName="id")})
    private Map<String, Long> objectTreeIdByName;
    @Transient
    private Map<String, Object> serializedPropertiesMap;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public boolean getIsDecoy() {
        return this.isDecoy;
    }

    public void setIsDecoy(boolean pIsDecoy) {
        this.isDecoy = pIsDecoy;
    }

    public boolean getIsValidated() {
        return this.isValidated;
    }

    public void setIsValidated(boolean pIsValidated) {
        this.isValidated = pIsValidated;
    }

    public Long getMasterQuantComponentId() {
        return this.masterQuantComponentId;
    }

    public void setMasterQuantComponentId(Long pMasterQuantComponentId) {
        this.masterQuantComponentId = pMasterQuantComponentId;
    }

    public ResultSummary getResultSummary() {
        return this.resultSummary;
    }

    public void setResultSummary(ResultSummary resultSummary) {
        this.resultSummary = resultSummary;
    }

    public int getSelectionLevel() {
        return this.selectionLevel;
    }

    public void setSelectionLevel(int pSelectionLevel) {
        this.selectionLevel = pSelectionLevel;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
        this.serializedPropertiesMap = null;
    }

    public long getProteinMatchId() {
        return this.representativeProteinMatchId;
    }

    public void setProteinMatchId(long pProteinMatchId) {
        this.representativeProteinMatchId = pProteinMatchId;
    }

    public Set<ProteinSetProteinMatchItem> getProteinSetProteinMatchItems() {
        return this.proteinSetProteinMatchItems;
    }

    public void setProteinSetProteinMatchItems(Set<ProteinSetProteinMatchItem> proteinSetProteinMatchItems) {
        this.proteinSetProteinMatchItems = proteinSetProteinMatchItems;
    }

    void setObjectTreeIdByName(Map<String, Long> objectTree) {
        this.objectTreeIdByName = objectTree;
    }

    public Map<String, Long> getObjectTreeIdByName() {
        return this.objectTreeIdByName;
    }

    public Long putObject(String schemaName, long objectId) {
        if (StringUtils.isEmpty((String)schemaName)) {
            throw new IllegalArgumentException("Invalid schemaName");
        }
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree == null) {
            localObjectTree = new HashMap<String, Long>();
            this.setObjectTreeIdByName(localObjectTree);
        }
        return localObjectTree.put(schemaName, objectId);
    }

    public Long removeObject(String schemaName) {
        Long result = null;
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree != null) {
            result = localObjectTree.remove(schemaName);
        }
        return result;
    }

    public Map<String, Object> getSerializedPropertiesAsMap() throws Exception {
        if (this.serializedPropertiesMap == null && this.serializedProperties != null) {
            this.serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(this.getSerializedProperties(), Map.class);
        }
        return this.serializedPropertiesMap;
    }

    public void setSerializedPropertiesAsMap(Map<String, Object> serializedPropertiesMap) throws Exception {
        this.serializedPropertiesMap = serializedPropertiesMap;
        this.serializedProperties = JsonSerializer.getMapper().writeValueAsString(serializedPropertiesMap);
    }
}

