/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.repository.util.JPAUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetRepository {
    private static Logger logger = LoggerFactory.getLogger(ResultSetRepository.class);

    private ResultSetRepository() {
    }

    public static List<Long> findChildMsiSearchIdsForResultSet(EntityManager msiEm, Long rsId) {
        ArrayList<Long> childMsiSearches = new ArrayList<Long>();
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (rsId == null || rsId < 1L) {
            return childMsiSearches;
        }
        ResultSet rs = (ResultSet)msiEm.find(ResultSet.class, (Object)rsId);
        if (rs == null) {
            return childMsiSearches;
        }
        MsiSearch msiSearch = rs.getMsiSearch();
        if (msiSearch != null) {
            childMsiSearches.add(msiSearch.getId());
        }
        ArrayList<Long> rsIds = new ArrayList<Long>();
        rsIds.add(rsId);
        ResultSetRepository.fillChildMsiSearches(msiEm, rsIds, childMsiSearches);
        return childMsiSearches;
    }

    private static void fillChildMsiSearches(EntityManager msiEm, List<Long> rsIds, List<Long> childMsiSearchIds) {
        if (rsIds.isEmpty()) {
            return;
        }
        ArrayList<Long> childRsIds = new ArrayList<Long>();
        Query query = msiEm.createNativeQuery("SELECT result_set_relation.child_result_set_id, result_set.msi_search_id FROM result_set, result_set_relation WHERE result_set.id = result_set_relation.child_result_set_id AND result_set_relation.parent_result_set_id IN (:rsIds)");
        query.setParameter("rsIds", rsIds);
        List queryResult = query.getResultList();
        for (Object[] nextResult : queryResult) {
            Long msiSearchId;
            childRsIds.add(((BigInteger)nextResult[0]).longValue());
            if (nextResult[1] == null || childMsiSearchIds.contains(msiSearchId = Long.valueOf(((BigInteger)nextResult[1]).longValue()))) continue;
            childMsiSearchIds.add(msiSearchId);
        }
        ResultSetRepository.fillChildMsiSearches(msiEm, childRsIds, childMsiSearchIds);
    }
}

