/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.uds.QuantitationLabel;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@NamedQueries(value={@NamedQuery(name="findQuantMethodForTypeAndUnit", query="select qm from fr.proline.core.orm.uds.QuantitationMethod qm where (upper(qm.type) = upper(:searchType)) and (upper(qm.abundanceUnit) = upper(:searchAbundanceUnit))"), @NamedQuery(name="findQuantMethodForType", query="select qm from fr.proline.core.orm.uds.QuantitationMethod qm where (upper(qm.type) = upper(:searchType))")})
@Table(name="quant_method")
public class QuantitationMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="abundance_unit")
    private String abundanceUnit;
    private String name;
    @Column(name="serialized_properties")
    private String serializedProperties;
    private String type;
    @OneToMany(mappedBy="method")
    @OrderBy(value="number")
    private List<QuantitationLabel> labels;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getAbundanceUnit() {
        return this.abundanceUnit;
    }

    public void setAbundanceUnit(String abundanceUnit) {
        this.abundanceUnit = abundanceUnit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<QuantitationLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(List<QuantitationLabel> labels) {
        this.labels = labels;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Long.valueOf(this.getId()).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantitationMethod that = (QuantitationMethod)o;
        return this.id == that.id;
    }

    public static enum Type {
        ATOM_LABELING("atom_labeling"),
        ISOBARIC_TAGGING("isobaric_tagging"),
        LABEL_FREE("label_free"),
        RESIDUE_LABELING("residue_labeling");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type findType(String name) {
            if (StringUtils.isEmpty((String)name)) {
                throw new IllegalArgumentException("Invalid specified method type");
            }
            Type result = null;
            for (Type nextType : Type.values()) {
                if (!nextType.type.equalsIgnoreCase(name)) continue;
                result = nextType;
                break;
            }
            return result;
        }
    }
}

